"""Generated client library for storage version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from samples.storage_sample.storage_v1 import storage_v1_messages as messages


class StorageV1(base_api.BaseApiClient):
  """Generated client library for service storage version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://www.googleapis.com/storage/v1/'
  MTLS_BASE_URL = 'https://www.mtls.googleapis.com/storage/v1/'

  _PACKAGE = 'storage'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform', 'https://www.googleapis.com/auth/cloud-platform.read-only', 'https://www.googleapis.com/auth/devstorage.full_control', 'https://www.googleapis.com/auth/devstorage.read_only', 'https://www.googleapis.com/auth/devstorage.read_write']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'x_Tw5K8nnjoRAqULM9PFAC2b'
  _CLIENT_CLASS_NAME = 'StorageV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new storage handle."""
    url = url or self.BASE_URL
    super(StorageV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.bucketAccessControls = self.BucketAccessControlsService(self)
    self.buckets = self.BucketsService(self)
    self.channels = self.ChannelsService(self)
    self.defaultObjectAccessControls = self.DefaultObjectAccessControlsService(self)
    self.notifications = self.NotificationsService(self)
    self.objectAccessControls = self.ObjectAccessControlsService(self)
    self.objects = self.ObjectsService(self)

  class BucketAccessControlsService(base_api.BaseApiService):
    """Service class for the bucketAccessControls resource."""

    _NAME = 'bucketAccessControls'

    def __init__(self, client):
      super(StorageV1.BucketAccessControlsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Permanently deletes the ACL entry for the specified entity on the specified bucket.

      Args:
        request: (StorageBucketAccessControlsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StorageBucketAccessControlsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='storage.bucketAccessControls.delete',
        ordered_params=['bucket', 'entity'],
        path_params=['bucket', 'entity'],
        query_params=[],
        relative_path='b/{bucket}/acl/{entity}',
        request_field='',
        request_type_name='StorageBucketAccessControlsDeleteRequest',
        response_type_name='StorageBucketAccessControlsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the ACL entry for the specified entity on the specified bucket.

      Args:
        request: (StorageBucketAccessControlsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BucketAccessControl) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.bucketAccessControls.get',
        ordered_params=['bucket', 'entity'],
        path_params=['bucket', 'entity'],
        query_params=[],
        relative_path='b/{bucket}/acl/{entity}',
        request_field='',
        request_type_name='StorageBucketAccessControlsGetRequest',
        response_type_name='BucketAccessControl',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new ACL entry on the specified bucket.

      Args:
        request: (BucketAccessControl) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BucketAccessControl) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.bucketAccessControls.insert',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=[],
        relative_path='b/{bucket}/acl',
        request_field='<request>',
        request_type_name='BucketAccessControl',
        response_type_name='BucketAccessControl',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves ACL entries on the specified bucket.

      Args:
        request: (StorageBucketAccessControlsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BucketAccessControls) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.bucketAccessControls.list',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=[],
        relative_path='b/{bucket}/acl',
        request_field='',
        request_type_name='StorageBucketAccessControlsListRequest',
        response_type_name='BucketAccessControls',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an ACL entry on the specified bucket. This method supports patch semantics.

      Args:
        request: (BucketAccessControl) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BucketAccessControl) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='storage.bucketAccessControls.patch',
        ordered_params=['bucket', 'entity'],
        path_params=['bucket', 'entity'],
        query_params=[],
        relative_path='b/{bucket}/acl/{entity}',
        request_field='<request>',
        request_type_name='BucketAccessControl',
        response_type_name='BucketAccessControl',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an ACL entry on the specified bucket.

      Args:
        request: (BucketAccessControl) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (BucketAccessControl) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='storage.bucketAccessControls.update',
        ordered_params=['bucket', 'entity'],
        path_params=['bucket', 'entity'],
        query_params=[],
        relative_path='b/{bucket}/acl/{entity}',
        request_field='<request>',
        request_type_name='BucketAccessControl',
        response_type_name='BucketAccessControl',
        supports_download=False,
    )

  class BucketsService(base_api.BaseApiService):
    """Service class for the buckets resource."""

    _NAME = 'buckets'

    def __init__(self, client):
      super(StorageV1.BucketsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Permanently deletes an empty bucket.

      Args:
        request: (StorageBucketsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StorageBucketsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='storage.buckets.delete',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=['ifMetagenerationMatch', 'ifMetagenerationNotMatch'],
        relative_path='b/{bucket}',
        request_field='',
        request_type_name='StorageBucketsDeleteRequest',
        response_type_name='StorageBucketsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns metadata for the specified bucket.

      Args:
        request: (StorageBucketsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Bucket) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.buckets.get',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=['ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'projection'],
        relative_path='b/{bucket}',
        request_field='',
        request_type_name='StorageBucketsGetRequest',
        response_type_name='Bucket',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Returns an IAM policy for the specified bucket.

      Args:
        request: (StorageBucketsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.buckets.getIamPolicy',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=[],
        relative_path='b/{bucket}/iam',
        request_field='',
        request_type_name='StorageBucketsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new bucket.

      Args:
        request: (StorageBucketsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Bucket) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.buckets.insert',
        ordered_params=['project'],
        path_params=[],
        query_params=['predefinedAcl', 'predefinedDefaultObjectAcl', 'project', 'projection'],
        relative_path='b',
        request_field='bucket',
        request_type_name='StorageBucketsInsertRequest',
        response_type_name='Bucket',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of buckets for a given project.

      Args:
        request: (StorageBucketsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Buckets) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.buckets.list',
        ordered_params=['project'],
        path_params=[],
        query_params=['maxResults', 'pageToken', 'prefix', 'project', 'projection'],
        relative_path='b',
        request_field='',
        request_type_name='StorageBucketsListRequest',
        response_type_name='Buckets',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a bucket. This method supports patch semantics.

      Args:
        request: (StorageBucketsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Bucket) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='storage.buckets.patch',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=['ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'predefinedAcl', 'predefinedDefaultObjectAcl', 'projection'],
        relative_path='b/{bucket}',
        request_field='bucketResource',
        request_type_name='StorageBucketsPatchRequest',
        response_type_name='Bucket',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Updates an IAM policy for the specified bucket.

      Args:
        request: (StorageBucketsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='storage.buckets.setIamPolicy',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=[],
        relative_path='b/{bucket}/iam',
        request_field='policy',
        request_type_name='StorageBucketsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Tests a set of permissions on the given bucket to see which, if any, are held by the caller.

      Args:
        request: (StorageBucketsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.buckets.testIamPermissions',
        ordered_params=['bucket', 'permissions'],
        path_params=['bucket'],
        query_params=['permissions'],
        relative_path='b/{bucket}/iam/testPermissions',
        request_field='',
        request_type_name='StorageBucketsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a bucket.

      Args:
        request: (StorageBucketsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Bucket) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='storage.buckets.update',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=['ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'predefinedAcl', 'predefinedDefaultObjectAcl', 'projection'],
        relative_path='b/{bucket}',
        request_field='bucketResource',
        request_type_name='StorageBucketsUpdateRequest',
        response_type_name='Bucket',
        supports_download=False,
    )

  class ChannelsService(base_api.BaseApiService):
    """Service class for the channels resource."""

    _NAME = 'channels'

    def __init__(self, client):
      super(StorageV1.ChannelsService, self).__init__(client)
      self._upload_configs = {
          }

    def Stop(self, request, global_params=None):
      r"""Stop watching resources through this channel.

      Args:
        request: (Channel) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StorageChannelsStopResponse) The response message.
      """
      config = self.GetMethodConfig('Stop')
      return self._RunMethod(
          config, request, global_params=global_params)

    Stop.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.channels.stop',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='channels/stop',
        request_field='<request>',
        request_type_name='Channel',
        response_type_name='StorageChannelsStopResponse',
        supports_download=False,
    )

  class DefaultObjectAccessControlsService(base_api.BaseApiService):
    """Service class for the defaultObjectAccessControls resource."""

    _NAME = 'defaultObjectAccessControls'

    def __init__(self, client):
      super(StorageV1.DefaultObjectAccessControlsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Permanently deletes the default object ACL entry for the specified entity on the specified bucket.

      Args:
        request: (StorageDefaultObjectAccessControlsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StorageDefaultObjectAccessControlsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='storage.defaultObjectAccessControls.delete',
        ordered_params=['bucket', 'entity'],
        path_params=['bucket', 'entity'],
        query_params=[],
        relative_path='b/{bucket}/defaultObjectAcl/{entity}',
        request_field='',
        request_type_name='StorageDefaultObjectAccessControlsDeleteRequest',
        response_type_name='StorageDefaultObjectAccessControlsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the default object ACL entry for the specified entity on the specified bucket.

      Args:
        request: (StorageDefaultObjectAccessControlsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControl) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.defaultObjectAccessControls.get',
        ordered_params=['bucket', 'entity'],
        path_params=['bucket', 'entity'],
        query_params=[],
        relative_path='b/{bucket}/defaultObjectAcl/{entity}',
        request_field='',
        request_type_name='StorageDefaultObjectAccessControlsGetRequest',
        response_type_name='ObjectAccessControl',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new default object ACL entry on the specified bucket.

      Args:
        request: (ObjectAccessControl) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControl) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.defaultObjectAccessControls.insert',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=[],
        relative_path='b/{bucket}/defaultObjectAcl',
        request_field='<request>',
        request_type_name='ObjectAccessControl',
        response_type_name='ObjectAccessControl',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves default object ACL entries on the specified bucket.

      Args:
        request: (StorageDefaultObjectAccessControlsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControls) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.defaultObjectAccessControls.list',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=['ifMetagenerationMatch', 'ifMetagenerationNotMatch'],
        relative_path='b/{bucket}/defaultObjectAcl',
        request_field='',
        request_type_name='StorageDefaultObjectAccessControlsListRequest',
        response_type_name='ObjectAccessControls',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates a default object ACL entry on the specified bucket. This method supports patch semantics.

      Args:
        request: (ObjectAccessControl) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControl) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='storage.defaultObjectAccessControls.patch',
        ordered_params=['bucket', 'entity'],
        path_params=['bucket', 'entity'],
        query_params=[],
        relative_path='b/{bucket}/defaultObjectAcl/{entity}',
        request_field='<request>',
        request_type_name='ObjectAccessControl',
        response_type_name='ObjectAccessControl',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates a default object ACL entry on the specified bucket.

      Args:
        request: (ObjectAccessControl) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControl) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='storage.defaultObjectAccessControls.update',
        ordered_params=['bucket', 'entity'],
        path_params=['bucket', 'entity'],
        query_params=[],
        relative_path='b/{bucket}/defaultObjectAcl/{entity}',
        request_field='<request>',
        request_type_name='ObjectAccessControl',
        response_type_name='ObjectAccessControl',
        supports_download=False,
    )

  class NotificationsService(base_api.BaseApiService):
    """Service class for the notifications resource."""

    _NAME = 'notifications'

    def __init__(self, client):
      super(StorageV1.NotificationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Permanently deletes a notification subscription.

      Args:
        request: (StorageNotificationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StorageNotificationsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='storage.notifications.delete',
        ordered_params=['notification'],
        path_params=['notification'],
        query_params=[],
        relative_path='notifications/{notification}',
        request_field='',
        request_type_name='StorageNotificationsDeleteRequest',
        response_type_name='StorageNotificationsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""View a notification configuration.

      Args:
        request: (StorageNotificationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Notification) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.notifications.get',
        ordered_params=['notification'],
        path_params=['notification'],
        query_params=[],
        relative_path='notifications/{notification}',
        request_field='',
        request_type_name='StorageNotificationsGetRequest',
        response_type_name='Notification',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a notification subscription for a given bucket.

      Args:
        request: (Notification) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Notification) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.notifications.insert',
        ordered_params=[],
        path_params=[],
        query_params=[],
        relative_path='notifications',
        request_field='<request>',
        request_type_name='Notification',
        response_type_name='Notification',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of notification subscriptions for a given bucket.

      Args:
        request: (StorageNotificationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Notifications) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.notifications.list',
        ordered_params=['bucket'],
        path_params=[],
        query_params=['bucket'],
        relative_path='notifications',
        request_field='',
        request_type_name='StorageNotificationsListRequest',
        response_type_name='Notifications',
        supports_download=False,
    )

  class ObjectAccessControlsService(base_api.BaseApiService):
    """Service class for the objectAccessControls resource."""

    _NAME = 'objectAccessControls'

    def __init__(self, client):
      super(StorageV1.ObjectAccessControlsService, self).__init__(client)
      self._upload_configs = {
          }

    def Delete(self, request, global_params=None):
      r"""Permanently deletes the ACL entry for the specified entity on the specified object.

      Args:
        request: (StorageObjectAccessControlsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StorageObjectAccessControlsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='storage.objectAccessControls.delete',
        ordered_params=['bucket', 'object', 'entity'],
        path_params=['bucket', 'entity', 'object'],
        query_params=['generation'],
        relative_path='b/{bucket}/o/{object}/acl/{entity}',
        request_field='',
        request_type_name='StorageObjectAccessControlsDeleteRequest',
        response_type_name='StorageObjectAccessControlsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Returns the ACL entry for the specified entity on the specified object.

      Args:
        request: (StorageObjectAccessControlsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControl) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.objectAccessControls.get',
        ordered_params=['bucket', 'object', 'entity'],
        path_params=['bucket', 'entity', 'object'],
        query_params=['generation'],
        relative_path='b/{bucket}/o/{object}/acl/{entity}',
        request_field='',
        request_type_name='StorageObjectAccessControlsGetRequest',
        response_type_name='ObjectAccessControl',
        supports_download=False,
    )

    def Insert(self, request, global_params=None):
      r"""Creates a new ACL entry on the specified object.

      Args:
        request: (StorageObjectAccessControlsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControl) The response message.
      """
      config = self.GetMethodConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.objectAccessControls.insert',
        ordered_params=['bucket', 'object'],
        path_params=['bucket', 'object'],
        query_params=['generation'],
        relative_path='b/{bucket}/o/{object}/acl',
        request_field='objectAccessControl',
        request_type_name='StorageObjectAccessControlsInsertRequest',
        response_type_name='ObjectAccessControl',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Retrieves ACL entries on the specified object.

      Args:
        request: (StorageObjectAccessControlsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControls) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.objectAccessControls.list',
        ordered_params=['bucket', 'object'],
        path_params=['bucket', 'object'],
        query_params=['generation'],
        relative_path='b/{bucket}/o/{object}/acl',
        request_field='',
        request_type_name='StorageObjectAccessControlsListRequest',
        response_type_name='ObjectAccessControls',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an ACL entry on the specified object. This method supports patch semantics.

      Args:
        request: (StorageObjectAccessControlsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControl) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='storage.objectAccessControls.patch',
        ordered_params=['bucket', 'object', 'entity'],
        path_params=['bucket', 'entity', 'object'],
        query_params=['generation'],
        relative_path='b/{bucket}/o/{object}/acl/{entity}',
        request_field='objectAccessControl',
        request_type_name='StorageObjectAccessControlsPatchRequest',
        response_type_name='ObjectAccessControl',
        supports_download=False,
    )

    def Update(self, request, global_params=None):
      r"""Updates an ACL entry on the specified object.

      Args:
        request: (StorageObjectAccessControlsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ObjectAccessControl) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='storage.objectAccessControls.update',
        ordered_params=['bucket', 'object', 'entity'],
        path_params=['bucket', 'entity', 'object'],
        query_params=['generation'],
        relative_path='b/{bucket}/o/{object}/acl/{entity}',
        request_field='objectAccessControl',
        request_type_name='StorageObjectAccessControlsUpdateRequest',
        response_type_name='ObjectAccessControl',
        supports_download=False,
    )

  class ObjectsService(base_api.BaseApiService):
    """Service class for the objects resource."""

    _NAME = 'objects'

    def __init__(self, client):
      super(StorageV1.ObjectsService, self).__init__(client)
      self._upload_configs = {
          'Insert': base_api.ApiUploadInfo(
              accept=['*/*'],
              max_size=None,
              resumable_multipart=True,
              resumable_path='/resumable/upload/storage/v1/b/{bucket}/o',
              simple_multipart=True,
              simple_path='/upload/storage/v1/b/{bucket}/o',
          ),
          }

    def Compose(self, request, global_params=None, download=None):
      r"""Concatenates a list of existing objects into a new object in the same bucket.

      Args:
        request: (StorageObjectsComposeRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
        download: (Download, default: None) If present, download
            data from the request via this stream.
      Returns:
        (Object) The response message.
      """
      config = self.GetMethodConfig('Compose')
      return self._RunMethod(
          config, request, global_params=global_params,
          download=download)

    Compose.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.objects.compose',
        ordered_params=['destinationBucket', 'destinationObject'],
        path_params=['destinationBucket', 'destinationObject'],
        query_params=['destinationPredefinedAcl', 'ifGenerationMatch', 'ifMetagenerationMatch'],
        relative_path='b/{destinationBucket}/o/{destinationObject}/compose',
        request_field='composeRequest',
        request_type_name='StorageObjectsComposeRequest',
        response_type_name='Object',
        supports_download=True,
    )

    def Copy(self, request, global_params=None, download=None):
      r"""Copies a source object to a destination object. Optionally overrides metadata.

      Args:
        request: (StorageObjectsCopyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
        download: (Download, default: None) If present, download
            data from the request via this stream.
      Returns:
        (Object) The response message.
      """
      config = self.GetMethodConfig('Copy')
      return self._RunMethod(
          config, request, global_params=global_params,
          download=download)

    Copy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.objects.copy',
        ordered_params=['sourceBucket', 'sourceObject', 'destinationBucket', 'destinationObject'],
        path_params=['destinationBucket', 'destinationObject', 'sourceBucket', 'sourceObject'],
        query_params=['destinationPredefinedAcl', 'ifGenerationMatch', 'ifGenerationNotMatch', 'ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'ifSourceGenerationMatch', 'ifSourceGenerationNotMatch', 'ifSourceMetagenerationMatch', 'ifSourceMetagenerationNotMatch', 'projection', 'sourceGeneration'],
        relative_path='b/{sourceBucket}/o/{sourceObject}/copyTo/b/{destinationBucket}/o/{destinationObject}',
        request_field='object',
        request_type_name='StorageObjectsCopyRequest',
        response_type_name='Object',
        supports_download=True,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes an object and its metadata. Deletions are permanent if versioning is not enabled for the bucket, or if the generation parameter is used.

      Args:
        request: (StorageObjectsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (StorageObjectsDeleteResponse) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        http_method='DELETE',
        method_id='storage.objects.delete',
        ordered_params=['bucket', 'object'],
        path_params=['bucket', 'object'],
        query_params=['generation', 'ifGenerationMatch', 'ifGenerationNotMatch', 'ifMetagenerationMatch', 'ifMetagenerationNotMatch'],
        relative_path='b/{bucket}/o/{object}',
        request_field='',
        request_type_name='StorageObjectsDeleteRequest',
        response_type_name='StorageObjectsDeleteResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None, download=None):
      r"""Retrieves an object or its metadata.

      Args:
        request: (StorageObjectsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
        download: (Download, default: None) If present, download
            data from the request via this stream.
      Returns:
        (Object) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params,
          download=download)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.objects.get',
        ordered_params=['bucket', 'object'],
        path_params=['bucket', 'object'],
        query_params=['generation', 'ifGenerationMatch', 'ifGenerationNotMatch', 'ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'projection'],
        relative_path='b/{bucket}/o/{object}',
        request_field='',
        request_type_name='StorageObjectsGetRequest',
        response_type_name='Object',
        supports_download=True,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Returns an IAM policy for the specified object.

      Args:
        request: (StorageObjectsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.objects.getIamPolicy',
        ordered_params=['bucket', 'object'],
        path_params=['bucket', 'object'],
        query_params=['generation'],
        relative_path='b/{bucket}/o/{object}/iam',
        request_field='',
        request_type_name='StorageObjectsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def Insert(self, request, global_params=None, upload=None, download=None):
      r"""Stores a new object and metadata.

      Args:
        request: (StorageObjectsInsertRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
        upload: (Upload, default: None) If present, upload
            this stream with the request.
        download: (Download, default: None) If present, download
            data from the request via this stream.
      Returns:
        (Object) The response message.
      """
      config = self.GetMethodConfig('Insert')
      upload_config = self.GetUploadConfig('Insert')
      return self._RunMethod(
          config, request, global_params=global_params,
          upload=upload, upload_config=upload_config,
          download=download)

    Insert.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.objects.insert',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=['contentEncoding', 'ifGenerationMatch', 'ifGenerationNotMatch', 'ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'name', 'predefinedAcl', 'projection'],
        relative_path='b/{bucket}/o',
        request_field='object',
        request_type_name='StorageObjectsInsertRequest',
        response_type_name='Object',
        supports_download=True,
    )

    def List(self, request, global_params=None):
      r"""Retrieves a list of objects matching the criteria.

      Args:
        request: (StorageObjectsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Objects) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.objects.list',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=['delimiter', 'maxResults', 'pageToken', 'prefix', 'projection', 'versions'],
        relative_path='b/{bucket}/o',
        request_field='',
        request_type_name='StorageObjectsListRequest',
        response_type_name='Objects',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates an object's metadata. This method supports patch semantics.

      Args:
        request: (StorageObjectsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Object) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PATCH',
        method_id='storage.objects.patch',
        ordered_params=['bucket', 'object'],
        path_params=['bucket', 'object'],
        query_params=['generation', 'ifGenerationMatch', 'ifGenerationNotMatch', 'ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'predefinedAcl', 'projection'],
        relative_path='b/{bucket}/o/{object}',
        request_field='objectResource',
        request_type_name='StorageObjectsPatchRequest',
        response_type_name='Object',
        supports_download=False,
    )

    def Rewrite(self, request, global_params=None):
      r"""Rewrites a source object to a destination object. Optionally overrides metadata.

      Args:
        request: (StorageObjectsRewriteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RewriteResponse) The response message.
      """
      config = self.GetMethodConfig('Rewrite')
      return self._RunMethod(
          config, request, global_params=global_params)

    Rewrite.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.objects.rewrite',
        ordered_params=['sourceBucket', 'sourceObject', 'destinationBucket', 'destinationObject'],
        path_params=['destinationBucket', 'destinationObject', 'sourceBucket', 'sourceObject'],
        query_params=['destinationPredefinedAcl', 'ifGenerationMatch', 'ifGenerationNotMatch', 'ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'ifSourceGenerationMatch', 'ifSourceGenerationNotMatch', 'ifSourceMetagenerationMatch', 'ifSourceMetagenerationNotMatch', 'maxBytesRewrittenPerCall', 'projection', 'rewriteToken', 'sourceGeneration'],
        relative_path='b/{sourceBucket}/o/{sourceObject}/rewriteTo/b/{destinationBucket}/o/{destinationObject}',
        request_field='object',
        request_type_name='StorageObjectsRewriteRequest',
        response_type_name='RewriteResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Updates an IAM policy for the specified object.

      Args:
        request: (StorageObjectsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='storage.objects.setIamPolicy',
        ordered_params=['bucket', 'object'],
        path_params=['bucket', 'object'],
        query_params=['generation'],
        relative_path='b/{bucket}/o/{object}/iam',
        request_field='policy',
        request_type_name='StorageObjectsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Tests a set of permissions on the given object to see which, if any, are held by the caller.

      Args:
        request: (StorageObjectsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        http_method='GET',
        method_id='storage.objects.testIamPermissions',
        ordered_params=['bucket', 'object', 'permissions'],
        path_params=['bucket', 'object'],
        query_params=['generation', 'permissions'],
        relative_path='b/{bucket}/o/{object}/iam/testPermissions',
        request_field='',
        request_type_name='StorageObjectsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

    def Update(self, request, global_params=None, download=None):
      r"""Updates an object's metadata.

      Args:
        request: (StorageObjectsUpdateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
        download: (Download, default: None) If present, download
            data from the request via this stream.
      Returns:
        (Object) The response message.
      """
      config = self.GetMethodConfig('Update')
      return self._RunMethod(
          config, request, global_params=global_params,
          download=download)

    Update.method_config = lambda: base_api.ApiMethodInfo(
        http_method='PUT',
        method_id='storage.objects.update',
        ordered_params=['bucket', 'object'],
        path_params=['bucket', 'object'],
        query_params=['generation', 'ifGenerationMatch', 'ifGenerationNotMatch', 'ifMetagenerationMatch', 'ifMetagenerationNotMatch', 'predefinedAcl', 'projection'],
        relative_path='b/{bucket}/o/{object}',
        request_field='objectResource',
        request_type_name='StorageObjectsUpdateRequest',
        response_type_name='Object',
        supports_download=True,
    )

    def WatchAll(self, request, global_params=None):
      r"""Watch for changes on all objects in a bucket.

      Args:
        request: (StorageObjectsWatchAllRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Channel) The response message.
      """
      config = self.GetMethodConfig('WatchAll')
      return self._RunMethod(
          config, request, global_params=global_params)

    WatchAll.method_config = lambda: base_api.ApiMethodInfo(
        http_method='POST',
        method_id='storage.objects.watchAll',
        ordered_params=['bucket'],
        path_params=['bucket'],
        query_params=['delimiter', 'maxResults', 'pageToken', 'prefix', 'projection', 'versions'],
        relative_path='b/{bucket}/o/watch',
        request_field='channel',
        request_type_name='StorageObjectsWatchAllRequest',
        response_type_name='Channel',
        supports_download=False,
    )
