/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class ApplyMarkupAtDestinationAddressTask
extends VtTask {
    protected final List<VTMarkupItem> markupItems;
    protected final Address destinationAddress;
    protected final ToolOptions options;

    public ApplyMarkupAtDestinationAddressTask(VTSession session, List<VTMarkupItem> markupItems, Address destinationAddress, ToolOptions options) {
        this("Apply Markup Item at Destination Address", session, markupItems, destinationAddress, options);
    }

    protected ApplyMarkupAtDestinationAddressTask(String title, VTSession session, List<VTMarkupItem> markupItems, Address destinationAddress, ToolOptions options) {
        super(title, session);
        this.markupItems = markupItems;
        this.options = options;
        this.destinationAddress = destinationAddress;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        monitor.initialize((long)this.markupItems.size());
        for (VTMarkupItem markupItem : this.markupItems) {
            monitor.checkCancelled();
            try {
                VTMarkupType markupType;
                VTMarkupItemApplyActionType applyAction;
                if (!SystemUtilities.isEqual((Object)markupItem.getDestinationAddress(), (Object)this.destinationAddress)) {
                    markupItem.setDestinationAddress(this.destinationAddress);
                }
                if ((applyAction = (markupType = markupItem.getMarkupType()).getApplyAction(this.options)) == null) continue;
                markupItem.getAssociation().setAccepted();
                markupItem.apply(applyAction, this.options);
            }
            catch (VTAssociationStatusException | VersionTrackingApplyException e) {
                this.reportError(e);
            }
            monitor.incrementProgress(1L);
        }
        return true;
    }
}

