/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.impl;

import ghidra.feature.vt.api.db.VTMatchSetDB;
import ghidra.feature.vt.api.impl.VTProgramCorrelatorInfo;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.Msg;
import java.io.IOException;

public class ProgramCorrelatorInfoImpl
implements VTProgramCorrelatorInfo {
    private String correlatorClassName;
    private String name;
    private AddressSet sourceAddressSet;
    private AddressSet destinationAddressSet;
    private Options options;
    private final VTMatchSetDB matchSetDB;

    public ProgramCorrelatorInfoImpl(VTMatchSetDB matchSet) {
        this.matchSetDB = matchSet;
    }

    @Override
    public String getCorrelatorClassName() {
        if (this.correlatorClassName == null) {
            this.correlatorClassName = this.matchSetDB.getProgramCorrelatorClassName();
        }
        return this.correlatorClassName;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.matchSetDB.getProgramCorrelatorName();
        }
        return this.name;
    }

    @Override
    public AddressSetView getSourceAddressSet() {
        if (this.sourceAddressSet == null) {
            try {
                this.sourceAddressSet = this.matchSetDB.getSourceAddressSet();
            }
            catch (IOException e) {
                Msg.showError((Object)this, null, (String)"Unable to Retrieve ProgramCorrelatorInfo", (Object)("Unexpected exception retrieving source addresses: " + this.getCorrelatorClassName()), (Throwable)e);
            }
        }
        return this.sourceAddressSet;
    }

    @Override
    public AddressSetView getDestinationAddressSet() {
        if (this.destinationAddressSet == null) {
            try {
                this.destinationAddressSet = this.matchSetDB.getDestinationAddressSet();
            }
            catch (IOException e) {
                Msg.showError((Object)this, null, (String)"Unable to Retrieve ProgramCorrelatorInfo", (Object)("Unexpected exception retrieving destination addresses: " + this.getCorrelatorClassName()), (Throwable)e);
            }
        }
        return this.destinationAddressSet;
    }

    @Override
    public Options getOptions() {
        if (this.options == null) {
            this.options = this.matchSetDB.getOptions();
        }
        return this.options;
    }
}

