/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import db.Transaction;
import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.action.builder.ToggleActionBuilder;
import ghidra.app.plugin.core.debug.gui.DebuggerBlockChooserDialog;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerAddRegionDialog;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionActionContext;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsPanel;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsPlugin;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.plugin.core.debug.service.modules.MapRegionsBackgroundCommand;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.model.DebuggerObjectActionContext;
import ghidra.debug.api.modules.MapProposal;
import ghidra.debug.api.modules.RegionMapProposal;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DebuggerRegionsProvider
extends ComponentProviderAdapter {
    final DebuggerRegionsPlugin plugin;
    @AutoServiceConsumed
    ProgramManager programManager;
    @AutoServiceConsumed
    DebuggerListingService listingService;
    @AutoServiceConsumed
    private DebuggerStaticMappingService staticMappingService;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private final AutoService.Wiring autoServiceWiring;
    private DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    private Program currentProgram;
    private ProgramLocation currentLocation;
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    DebuggerRegionsPanel panel;
    private final DebuggerBlockChooserDialog blockChooserDialog;
    private final DebuggerRegionMapProposalDialog regionProposalDialog;
    private final DebuggerAddRegionDialog addRegionDialog;
    DockingAction actionMapRegions;
    DockingAction actionMapRegionTo;
    DockingAction actionMapRegionsTo;
    SelectAddressesAction actionSelectAddresses;
    DockingAction actionSelectRows;
    DockingAction actionAddRegion;
    DockingAction actionDeleteRegions;
    ToggleDockingAction actionForceFullView;

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (a.getSnap() != b.getSnap()) {
            return false;
        }
        return Objects.equals(a.getObject(), b.getObject());
    }

    public DebuggerRegionsProvider(DebuggerRegionsPlugin plugin) {
        super(plugin.getTool(), "Regions", plugin.getName(), DebuggerRegionActionContext.class);
        this.plugin = plugin;
        this.setIcon(DebuggerResources.ICON_PROVIDER_REGIONS);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_REGIONS);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.blockChooserDialog = new DebuggerBlockChooserDialog(this.tool);
        this.regionProposalDialog = new DebuggerRegionMapProposalDialog(this);
        this.addRegionDialog = new DebuggerAddRegionDialog();
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setVisible(true);
        this.createActions();
    }

    void dispose() {
        this.blockChooserDialog.dispose();
        this.regionProposalDialog.dispose();
    }

    protected void buildMainPanel() {
        this.panel = new DebuggerRegionsPanel(this);
        this.mainPanel.add(this.panel);
    }

    protected void createActions() {
        this.actionMapRegions = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapRegionsAction.builder(this.plugin).enabledWhen(ctx -> this.isContextNonEmpty((ActionContext)ctx) && this.isContextNotForcedSingle((ActionContext)ctx))).popupWhen(ctx -> this.isContextNonEmpty((ActionContext)ctx) && this.isContextNotForcedSingle((ActionContext)ctx))).onAction(this::activatedMapRegions)).buildAndInstall((Tool)this.tool);
        this.actionMapRegionTo = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapRegionToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && this.isContextSingleSelection((ActionContext)ctx))).popupWhen(ctx -> this.currentProgram != null && this.isContextSingleSelection((ActionContext)ctx))).onAction(this::activatedMapRegionTo)).buildAndInstall((Tool)this.tool);
        this.actionMapRegionsTo = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)MapRegionsToAction.builder(this.plugin).enabledWhen(ctx -> this.currentProgram != null && this.isContextNonEmpty((ActionContext)ctx) && this.isContextNotForcedSingle((ActionContext)ctx))).popupWhen(ctx -> this.currentProgram != null && this.isContextNonEmpty((ActionContext)ctx) && this.isContextNotForcedSingle((ActionContext)ctx))).onAction(this::activatedMapRegionsTo)).buildAndInstall((Tool)this.tool);
        this.actionSelectAddresses = new SelectAddressesAction();
        this.actionSelectRows = (DockingAction)((ActionBuilder)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectRowsAction.builder(this.plugin).description("Select regions by dynamic selection")).enabledWhen(ctx -> this.current.getTrace() != null)).onAction(this::activatedSelectCurrent)).buildAndInstallLocal((ComponentProvider)this);
        this.actionAddRegion = (DockingAction)((ActionBuilder)((ActionBuilder)AddRegionAction.builder(this.plugin).enabledWhen(ctx -> this.current.getTrace() != null)).onAction(this::activatedAddRegion)).buildAndInstallLocal((ComponentProvider)this);
        this.actionDeleteRegions = (DockingAction)((ActionBuilder)((ActionBuilder)DeleteRegionsAction.builder(this.plugin).enabledWhen(this::isContextNonEmpty)).onAction(this::activatedDeleteRegions)).buildAndInstallLocal((ComponentProvider)this);
        this.actionForceFullView = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)ForceFullViewAction.builder(this.plugin).enabledWhen(ctx -> this.current.getTrace() != null)).onAction(this::activatedForceFullView)).buildAndInstallLocal((ComponentProvider)this);
        this.contextChanged();
    }

    public ActionContext getActionContext(MouseEvent event) {
        DebuggerObjectActionContext context = this.panel.getActionContext();
        if (context != null) {
            return context;
        }
        return super.getActionContext(event);
    }

    private boolean isContextNonEmpty(ActionContext context) {
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return this.panel.isContextNonEmpty(ctx);
        }
        return false;
    }

    private boolean isContextNotForcedSingle(ActionContext context) {
        if (context instanceof DebuggerRegionActionContext) {
            DebuggerRegionActionContext ctx = (DebuggerRegionActionContext)context;
            return !ctx.isForcedSingle();
        }
        return true;
    }

    private boolean isContextSingleSelection(ActionContext context) {
        Set<TraceMemoryRegion> sel = this.getSelectedRegions(context);
        return sel != null && sel.size() == 1;
    }

    private Set<TraceMemoryRegion> getSelectedRegions(ActionContext context) {
        if (context instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext ctx = (DebuggerObjectActionContext)context;
            return this.panel.getSelectedRegions(ctx);
        }
        return null;
    }

    private void activatedMapRegions(ActionContext context) {
        this.mapRegions(this.getSelectedRegions(context));
    }

    private void activatedMapRegionTo(ActionContext context) {
        Set<TraceMemoryRegion> sel = this.getSelectedRegions(context);
        if (sel == null || sel.size() != 1) {
            return;
        }
        this.mapRegionTo(sel.iterator().next());
    }

    private void activatedMapRegionsTo(ActionContext context) {
        Set<TraceMemoryRegion> sel = this.getSelectedRegions(context);
        if (sel == null || sel.isEmpty()) {
            return;
        }
        this.mapRegionsTo(sel);
    }

    protected void promptRegionProposal(Collection<RegionMapProposal.RegionMapEntry> proposal) {
        if (proposal.isEmpty()) {
            Msg.showInfo((Object)((Object)this), (Component)this.getComponent(), (String)"Map Regions", (Object)"Could not formulate a propsal for any selection region. You may need to import and/or open the destination images first.");
            return;
        }
        Collection<RegionMapProposal.RegionMapEntry> adjusted = this.regionProposalDialog.adjustCollection(this.getTool(), proposal);
        if (adjusted == null || this.staticMappingService == null) {
            return;
        }
        this.tool.executeBackgroundCommand((BackgroundCommand)new MapRegionsBackgroundCommand(this.staticMappingService, adjusted), (DomainObject)this.current.getTrace());
    }

    protected void mapRegions(Set<TraceMemoryRegion> regions) {
        if (this.staticMappingService == null) {
            return;
        }
        Map map = this.staticMappingService.proposeRegionMaps(regions, this.current.getSnap(), List.of(this.programManager.getAllOpenPrograms()));
        Collection proposal = MapProposal.flatten(map.values());
        this.promptRegionProposal(proposal);
    }

    protected void mapRegionsTo(Set<TraceMemoryRegion> regions) {
        if (this.staticMappingService == null) {
            return;
        }
        Program program = this.currentProgram;
        if (program == null) {
            return;
        }
        RegionMapProposal map = this.staticMappingService.proposeRegionMap(regions, this.current.getSnap(), program);
        Collection<RegionMapProposal.RegionMapEntry> proposal = map.computeMap().values();
        this.promptRegionProposal(proposal);
    }

    protected void mapRegionTo(TraceMemoryRegion region) {
        if (this.staticMappingService == null) {
            return;
        }
        ProgramLocation location = this.currentLocation;
        MemoryBlock block = DebuggerRegionsProvider.computeBlock(location);
        if (block == null) {
            return;
        }
        RegionMapProposal map = this.staticMappingService.proposeRegionMap(region, this.current.getSnap(), location.getProgram(), block);
        this.promptRegionProposal(map.computeMap().values());
    }

    private void activatedSelectCurrent(ActionContext ignored) {
        TraceMemoryRegion reg;
        if (this.listingService == null || this.traceManager == null || this.current.getTrace() == null) {
            return;
        }
        ProgramSelection progSel = this.listingService.getCurrentSelection();
        TraceMemoryManager memoryManager = this.current.getTrace().getMemoryManager();
        if (progSel != null && !progSel.isEmpty()) {
            HashSet<TraceMemoryRegion> regSel = new HashSet<TraceMemoryRegion>();
            for (AddressRange range : progSel) {
                regSel.addAll(memoryManager.getRegionsIntersecting(Lifespan.at((long)this.traceManager.getCurrentSnap()), range));
            }
            this.setSelectedRegions(regSel);
            return;
        }
        ProgramLocation progLoc = this.listingService.getCurrentLocation();
        if (progLoc != null && (reg = memoryManager.getRegionContaining(this.traceManager.getCurrentSnap(), progLoc.getAddress())) != null) {
            this.setSelectedRegions(Set.of(reg));
            return;
        }
    }

    private void activatedAddRegion(ActionContext ignored) {
        if (this.current.getTrace() == null) {
            return;
        }
        this.addRegionDialog.show(this.tool, this.current);
    }

    private void activatedDeleteRegions(ActionContext ctx) {
        Set<TraceMemoryRegion> sel = this.getSelectedRegions(ctx);
        if (sel.isEmpty()) {
            return;
        }
        try (Transaction tx = this.current.getTrace().openTransaction("Delete regions");){
            for (TraceMemoryRegion region : sel) {
                region.delete();
            }
        }
    }

    private void activatedForceFullView(ActionContext ignored) {
        if (this.current.getTrace() == null) {
            return;
        }
        this.current.getTrace().getProgramView().getMemory().setForceFullView(this.actionForceFullView.isSelected());
    }

    public void setSelectedRegions(Set<TraceMemoryRegion> sel) {
        this.panel.setSelectedRegions(sel);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void setProgram(Program program) {
        this.currentProgram = program;
        String name = program == null ? "..." : program.getName();
        this.actionMapRegionTo.getPopupMenuData().setMenuItemName("Map Region to " + name);
        this.actionMapRegionsTo.getPopupMenuData().setMenuItemName("Map Regions to " + name);
    }

    public static MemoryBlock computeBlock(ProgramLocation location) {
        return DebuggerModulesProvider.computeBlock(location);
    }

    public static String computeBlockName(ProgramLocation location) {
        return DebuggerModulesProvider.computeBlockName(location);
    }

    public void setLocation(ProgramLocation location) {
        this.currentLocation = location;
        String name = "Map Region to " + DebuggerRegionsProvider.computeBlockName(location);
        this.actionMapRegionTo.getPopupMenuData().setMenuItemName(name);
    }

    public void programClosed(Program program) {
        if (this.currentProgram == program) {
            this.currentProgram = null;
        }
    }

    public void contextChanged() {
        super.contextChanged();
        Trace trace = this.current.getTrace();
        this.actionForceFullView.setSelected(trace == null ? false : trace.getProgramView().getMemory().isForceFullView());
    }

    public Map.Entry<Program, MemoryBlock> askBlock(TraceMemoryRegion region, Program program, MemoryBlock block) {
        if (this.programManager == null) {
            Msg.warn((Object)((Object)this), (Object)"No program manager!");
            return null;
        }
        return this.blockChooserDialog.chooseBlock(this.getTool(), region, this.current.getSnap(), List.of(this.programManager.getAllOpenPrograms()));
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerRegionsProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.current = coordinates;
        this.panel.coordinatesActivated(coordinates);
        this.contextChanged();
    }

    static interface MapRegionsAction {
        public static final String NAME = "Map Regions";
        public static final String DESCRIPTION = "Map selected regions to program memory blocks";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_regions";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{NAME})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapRegionToAction {
        public static final String NAME_PREFIX = "Map Region to ";
        public static final String DESCRIPTION = "Map the selected region to the current program";
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_region_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Region to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface MapRegionsToAction {
        public static final String NAME_PREFIX = "Map Regions to ";
        public static final String DESCRIPTION = "Map the selected (module) regions to the current program";
        public static final Icon ICON = DebuggerResources.ICON_MAP_SECTIONS;
        public static final String GROUP = "Dbg9. Map Modules/Sections";
        public static final String HELP_ANCHOR = "map_regions_to";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME_PREFIX, ownerName).description(DESCRIPTION)).popupMenuPath(new String[]{"Map Regions to ..."})).popupMenuGroup(GROUP)).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    protected class SelectAddressesAction
    extends DebuggerResources.AbstractSelectAddressesAction {
        public static final String GROUP = "Dbg1. General";

        public SelectAddressesAction() {
            super(DebuggerRegionsProvider.this.plugin);
            this.setDescription("Select addresses contained in regions");
            this.setToolBarData(new ToolBarData(ICON, GROUP));
            this.setPopupMenuData(new MenuData(new String[]{"Select Addresses"}, GROUP));
            DebuggerRegionsProvider.this.addLocalAction((DockingActionIf)this);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionContext context) {
            if (DebuggerRegionsProvider.this.listingService == null) {
                return;
            }
            Set<TraceMemoryRegion> regions = DebuggerRegionsProvider.this.getSelectedRegions(context);
            if (regions == null) {
                return;
            }
            AddressSet sel = new AddressSet();
            for (TraceMemoryRegion s : regions) {
                sel.add(s.getRange(DebuggerRegionsProvider.this.current.getSnap()));
            }
            ProgramSelection ps = new ProgramSelection((AddressSetView)sel);
            DebuggerRegionsProvider.this.listingService.setCurrentSelection(ps);
        }

        public boolean isEnabledForContext(ActionContext context) {
            Set<TraceMemoryRegion> sel = DebuggerRegionsProvider.this.getSelectedRegions(context);
            return sel != null && !sel.isEmpty();
        }
    }

    static interface AddRegionAction {
        public static final String NAME = "Add Region";
        public static final String DESCRIPTION = "Manually add a region to the memory map";
        public static final String GROUP = "Dbg8. Maintenance";
        public static final String HELP_ANCHOR = "add_region";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup(GROUP)).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface DeleteRegionsAction {
        public static final String NAME = "Delete Regions";
        public static final String DESCRIPTION = "Delete one or more regions from the memory map";
        public static final String GROUP = "Dbg8. Maintenance";
        public static final String HELP_ANCHOR = "delete_regions";

        public static ActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder(NAME, ownerName).description(DESCRIPTION)).popupMenuGroup(GROUP)).popupMenuPath(new String[]{NAME, "Yes, really. Delete them!"})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }

    static interface ForceFullViewAction {
        public static final String NAME = "Force Full View";
        public static final String DESCRIPTION = "Ignore regions and fiew full address spaces";
        public static final String GROUP = "Dbg1. General";
        public static final String HELP_ANCHOR = "force_full_view";

        public static ToggleActionBuilder builder(Plugin owner) {
            String ownerName = owner.getName();
            return (ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder(NAME, ownerName).description(DESCRIPTION)).menuGroup(GROUP)).menuPath(new String[]{NAME})).helpLocation(new HelpLocation(ownerName, HELP_ANCHOR));
        }
    }
}

