/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.ingest;

import generic.lsh.vector.LSHVectorFactory;
import generic.lsh.vector.WeightedLSHCosineVectorFactory;
import ghidra.app.decompiler.DecompileException;
import ghidra.features.bsim.query.BSimClientFactory;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.FunctionDatabase;
import ghidra.features.bsim.query.GenSignatures;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.client.Configuration;
import ghidra.features.bsim.query.client.tables.ExeTable;
import ghidra.features.bsim.query.description.DatabaseInformation;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.features.bsim.query.ingest.IterateRepository;
import ghidra.features.bsim.query.protocol.AdjustVectorIndex;
import ghidra.features.bsim.query.protocol.CreateDatabase;
import ghidra.features.bsim.query.protocol.ExeSpecifier;
import ghidra.features.bsim.query.protocol.InsertRequest;
import ghidra.features.bsim.query.protocol.InstallCategoryRequest;
import ghidra.features.bsim.query.protocol.InstallMetadataRequest;
import ghidra.features.bsim.query.protocol.InstallTagRequest;
import ghidra.features.bsim.query.protocol.PairInput;
import ghidra.features.bsim.query.protocol.PairNote;
import ghidra.features.bsim.query.protocol.PrewarmRequest;
import ghidra.features.bsim.query.protocol.QueryDelete;
import ghidra.features.bsim.query.protocol.QueryExeCount;
import ghidra.features.bsim.query.protocol.QueryExeInfo;
import ghidra.features.bsim.query.protocol.QueryName;
import ghidra.features.bsim.query.protocol.QueryPair;
import ghidra.features.bsim.query.protocol.QueryUpdate;
import ghidra.features.bsim.query.protocol.ResponseAdjustIndex;
import ghidra.features.bsim.query.protocol.ResponseDelete;
import ghidra.features.bsim.query.protocol.ResponseExe;
import ghidra.features.bsim.query.protocol.ResponseInfo;
import ghidra.features.bsim.query.protocol.ResponseName;
import ghidra.features.bsim.query.protocol.ResponsePair;
import ghidra.features.bsim.query.protocol.ResponsePrewarm;
import ghidra.features.bsim.query.protocol.ResponseUpdate;
import ghidra.framework.Application;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.help.UnsupportedOperationException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class BulkSignatures
implements AutoCloseable {
    private final BSimServerInfo bsimServerInfo;
    private FunctionDatabase querydb;

    public BulkSignatures(BSimServerInfo bsimServerInfo, String connectingUserName) {
        if (bsimServerInfo != null && !StringUtils.isBlank((CharSequence)connectingUserName)) {
            if (!bsimServerInfo.hasDefaultLogin()) {
                String username = bsimServerInfo.getUserName();
                if (!username.equals(connectingUserName)) {
                    Msg.warn((Object)this, (Object)("BSim DB server info specifies user '" + username + "'.  Ignoring user name option: '" + connectingUserName + "'"));
                }
            } else {
                bsimServerInfo = new BSimServerInfo(bsimServerInfo.getDBType(), connectingUserName, bsimServerInfo.getServerName(), bsimServerInfo.getPort(), bsimServerInfo.getDBName());
            }
        }
        this.bsimServerInfo = bsimServerInfo;
    }

    public BulkSignatures(BSimServerInfo bsimServerInfo) {
        this.bsimServerInfo = bsimServerInfo;
    }

    private void checkBSimServerOperation() {
        if (this.bsimServerInfo == null) {
            throw new UnsupportedOperationException("BSim server has not been specified");
        }
    }

    private DatabaseInformation establishQueryServerConnection(boolean async) throws IOException {
        if (this.querydb != null) {
            return this.querydb.getInfo();
        }
        this.checkBSimServerOperation();
        this.querydb = BSimClientFactory.buildClient(this.bsimServerInfo, async);
        if (!this.querydb.initialize()) {
            throw new IOException(this.querydb.getLastError().message);
        }
        DatabaseInformation info = this.querydb.getInfo();
        if (info == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            if (lastError != null && lastError.category == FunctionDatabase.ErrorCategory.Nodatabase) {
                throw new IOException(lastError.message);
            }
            throw new IOException("Unknown error connection to: " + this.bsimServerInfo.toString());
        }
        Msg.debug((Object)this, (Object)("Connected to " + info.databasename));
        return info;
    }

    @Override
    public void close() {
        this.closeConnection();
    }

    private void closeConnection() {
        if (this.querydb != null) {
            this.querydb.close();
            this.querydb = null;
        }
    }

    private List<File> gatherXml(String prefix, File dir) throws IOException {
        ArrayList<File> res = new ArrayList<File>();
        File[] listFiles = dir.listFiles();
        if (listFiles == null) {
            throw new IOException("Bad xml directory");
        }
        for (File file : listFiles) {
            if (!file.getName().startsWith(prefix)) continue;
            res.add(file);
        }
        return res;
    }

    private void loadSignatureXml(File file, DescriptionManager manage) throws SAXException, IOException, LSHException {
        ErrorHandler handler = SpecXmlUtils.getXmlHandler();
        NonThreadedXmlPullParserImpl parser = new NonThreadedXmlPullParserImpl(file, handler, false);
        manage.restoreXml((XmlPullParser)parser, this.querydb.getLSHVectorFactory());
    }

    protected void sendXmlToQueryServer(File dir, URL ghidraOverrideURL, String filter, TaskMonitor monitor) throws IOException, SAXException, LSHException, CancelledException {
        this.establishQueryServerConnection(true);
        filter = filter == null ? "sigs_" : "sigs_" + (String)filter;
        List<File> files = this.gatherXml((String)filter, dir);
        if (files.isEmpty()) {
            throw new IOException("No signature files found in " + dir.getAbsolutePath());
        }
        monitor.setMessage("Writing signatures");
        monitor.setMaximum((long)files.size());
        for (File file : files) {
            monitor.checkCancelled();
            monitor.incrementProgress(1L);
            Msg.info((Object)this, (Object)("Writing signatures for " + file.getName()));
            InsertRequest insertreq = new InsertRequest();
            if (ghidraOverrideURL != null) {
                insertreq.repo_override = GhidraURL.getProjectURL((URL)ghidraOverrideURL).toExternalForm();
                insertreq.path_override = GhidraURL.getProjectPathname((URL)ghidraOverrideURL);
            }
            this.loadSignatureXml(file, insertreq.manage);
            if (insertreq.manage.numFunctions() == 0) {
                Msg.warn((Object)this, (Object)(file.getName() + ": does not define any functions"));
                continue;
            }
            if (insertreq.execute(this.querydb) != null) continue;
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            if (lastError.category == FunctionDatabase.ErrorCategory.Format || lastError.category == FunctionDatabase.ErrorCategory.Nonfatal) {
                Msg.warn((Object)this, (Object)(file.getName() + ": " + lastError.message));
                continue;
            }
            throw new IOException(file.getName() + ": " + lastError.message);
        }
    }

    protected void sendUpdateToServer(File dir) throws IOException, SAXException, LSHException {
        this.establishQueryServerConnection(true);
        List<File> files = this.gatherXml("update_", dir);
        if (files.isEmpty()) {
            throw new IOException("No update files found in " + dir.getAbsolutePath());
        }
        for (File file : files) {
            Msg.info((Object)this, (Object)("Updating metadata for " + file.getName()));
            QueryUpdate update = new QueryUpdate();
            this.loadSignatureXml(file, update.manage);
            ResponseUpdate respup = (ResponseUpdate)update.execute(this.querydb);
            if (respup == null) {
                FunctionDatabase.BSimError lastError = this.querydb.getLastError();
                if (lastError.category == FunctionDatabase.ErrorCategory.Format || lastError.category == FunctionDatabase.ErrorCategory.Nonfatal) {
                    Msg.warn((Object)this, (Object)(file.getName() + ": " + lastError.message));
                    continue;
                }
                throw new IOException(file.getName() + ": " + lastError.message);
            }
            if (!respup.badexe.isEmpty()) {
                for (ExecutableRecord erec : respup.badexe) {
                    Msg.error((Object)this, (Object)("Unable to find executable: " + erec.getNameExec()));
                }
            }
            if (!respup.badfunc.isEmpty()) {
                int max = respup.badfunc.size();
                if (max > 3) {
                    Msg.error((Object)this, (Object)("Could not find " + Integer.toString(respup.badfunc.size()) + " functions"));
                    max = 3;
                }
                for (int j = 0; j < max; ++j) {
                    FunctionDescription func = respup.badfunc.get(j);
                    Msg.error((Object)this, (Object)("Could not update function " + func.getFunctionName()));
                }
            }
            if (respup.exeupdate > 0) {
                Msg.info((Object)this, (Object)("Updated " + Integer.toString(respup.exeupdate) + " executables"));
            }
            if (respup.funcupdate > 0) {
                Msg.info((Object)this, (Object)("Updated " + Integer.toString(respup.funcupdate) + " functions"));
            }
            if (respup.exeupdate != 0 || respup.funcupdate != 0) continue;
            Msg.info((Object)this, (Object)"No changes");
        }
    }

    private DatabaseInformation createQueryDatabase(String template, String name, String owner, String description, boolean track) throws IOException {
        CreateDatabase command = new CreateDatabase();
        command.info = new DatabaseInformation();
        command.info.databasename = name;
        command.info.owner = owner;
        command.info.description = description;
        command.config_template = template;
        command.info.trackcallgraph = track;
        ResponseInfo response = (ResponseInfo)command.execute(this.querydb);
        if (response == null) {
            throw new IOException(this.querydb.getLastError().message);
        }
        return response.info;
    }

    private void formatCategories(List<String> execats, StringBuilder buf) {
        if (execats == null) {
            return;
        }
        buf.append(" Categories:\n");
        for (String execat : execats) {
            buf.append("   ");
            buf.append(execat);
            buf.append("\n");
        }
    }

    private void formatFunctionTags(List<String> tags, StringBuilder buf) {
        if (tags == null) {
            return;
        }
        buf.append(" Function Tags:\n");
        for (String tag : tags) {
            buf.append("   ");
            buf.append(tag);
            buf.append("\n");
        }
    }

    private String formatDatabaseDetails(DatabaseInformation info) {
        StringBuilder buf = new StringBuilder();
        buf.append("Using configuration for:\n");
        buf.append(" Database: ");
        buf.append(info.databasename);
        buf.append("\n");
        buf.append(" Owner:    ");
        buf.append(info.owner);
        buf.append("\n");
        this.formatCategories(info.execats, buf);
        this.formatFunctionTags(info.functionTags, buf);
        if (info.dateColumnName != null) {
            buf.append(" Date column: ");
            buf.append(info.dateColumnName);
            buf.append("\n");
        }
        return buf.toString();
    }

    protected File generateSignaturesFromServer(URL ghidraURL, String xmlDirectory, boolean overwrite, String configtemplate, TaskMonitor monitor) throws Exception, CancelledException {
        DatabaseInformation info;
        File dir = this.establishTemporaryDirectory(xmlDirectory);
        WeightedLSHCosineVectorFactory vectorFactory = null;
        if (configtemplate == null) {
            info = this.establishQueryServerConnection(false);
            Msg.debug((Object)this, (Object)("Attempting to pull configuration from: " + this.bsimServerInfo.toString()));
            vectorFactory = this.querydb.getLSHVectorFactory();
        } else {
            Configuration config = FunctionDatabase.loadConfigurationTemplate(configtemplate);
            info = config.info;
            vectorFactory = FunctionDatabase.generateLSHVectorFactory();
            vectorFactory.set(config.weightfactory, config.idflookup, config.info.settings);
        }
        Msg.info((Object)this, (Object)this.formatDatabaseDetails(info));
        String repositoryURLString = GhidraURL.getProjectURL((URL)ghidraURL).toExternalForm();
        SignatureRepository sigrepo = new SignatureRepository(this, dir, repositoryURLString, overwrite, info, (LSHVectorFactory)vectorFactory);
        sigrepo.process(ghidraURL, monitor);
        return dir;
    }

    protected File generateUpdatesFromServer(URL ghidraURL, String xmlDirectory, boolean overwrite, String configtemplate, TaskMonitor monitor) throws Exception, CancelledException {
        DatabaseInformation info;
        File dir = this.establishTemporaryDirectory(xmlDirectory);
        LSHVectorFactory vectorFactory = null;
        if (configtemplate == null) {
            info = this.establishQueryServerConnection(false);
            vectorFactory = this.querydb.getLSHVectorFactory();
        } else {
            Configuration config = FunctionDatabase.loadConfigurationTemplate(configtemplate);
            info = config.info;
            vectorFactory = FunctionDatabase.generateLSHVectorFactory();
            vectorFactory.set(config.weightfactory, config.idflookup, config.info.settings);
        }
        Msg.info((Object)this, (Object)this.formatDatabaseDetails(info));
        String repositoryURLString = GhidraURL.getProjectURL((URL)ghidraURL).toExternalForm();
        UpdateRepository updaterepo = new UpdateRepository(this, dir, repositoryURLString, overwrite, info, vectorFactory);
        updaterepo.process(ghidraURL, monitor);
        return dir;
    }

    public void createDatabase(String configTemplate, String name, String owner, String description, boolean trackCall) throws IOException {
        this.closeConnection();
        this.checkBSimServerOperation();
        this.querydb = BSimClientFactory.buildClient(this.bsimServerInfo, true);
        try {
            DatabaseInformation info = this.createQueryDatabase(configTemplate, name, owner, description, trackCall);
            StringBuilder buf = new StringBuilder();
            buf.append("Created database: ");
            buf.append(info.databasename);
            buf.append("\n");
            buf.append("   owner       = ");
            buf.append(info.owner);
            buf.append("\n");
            buf.append("   description = ");
            buf.append(info.description);
            buf.append("\n");
            buf.append("   template    = ");
            buf.append(configTemplate);
            buf.append("\n");
            Msg.info((Object)this, (Object)buf.toString());
        }
        catch (IOException ex) {
            Msg.error((Object)this, (Object)("Unable to create database: " + ex.getMessage()));
            return;
        }
        boolean success = this.querydb.initialize();
        if (!success) {
            Msg.error((Object)this, (Object)("Database initialization error: " + this.querydb.getLastError().message));
        }
    }

    public void signatureRepo(URL ghidraURL, String sigsLocation, boolean overwrite, TaskMonitor monitor) throws Exception, CancelledException {
        String xmlDirectory = null;
        boolean usestmpdir = false;
        if (!StringUtils.isBlank((CharSequence)sigsLocation)) {
            xmlDirectory = sigsLocation;
        } else {
            usestmpdir = true;
        }
        File dir = this.generateSignaturesFromServer(ghidraURL, xmlDirectory, overwrite, null, monitor);
        this.sendXmlToQueryServer(dir, null, null, monitor);
        if (usestmpdir) {
            this.deleteTemporaryDirectory(dir);
        }
    }

    public void updateRepoSignatures(URL ghidraURL, String sigsLocation, boolean overwrite, TaskMonitor monitor) throws Exception, CancelledException {
        String xmlDirectory = null;
        boolean usestmpdir = false;
        if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{sigsLocation})) {
            xmlDirectory = sigsLocation;
        } else {
            usestmpdir = true;
        }
        File dir = this.generateUpdatesFromServer(ghidraURL, xmlDirectory, overwrite, null, monitor);
        this.sendUpdateToServer(dir);
        if (usestmpdir) {
            this.deleteTemporaryDirectory(dir);
        }
    }

    public void deleteExecutable(String md5, String name) throws IOException, LSHException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{md5}) && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{name})) {
            throw new IOException("Must specify \"md5=\" or \"name=\" option");
        }
        ExeSpecifier spec = new ExeSpecifier();
        spec.exemd5 = md5;
        spec.exename = name;
        spec.arch = null;
        spec.execompname = null;
        this.deleteExecutables(spec);
    }

    protected void deleteExecutables(ExeSpecifier spec) throws IOException, LSHException {
        QueryDelete query = new QueryDelete();
        query.addSpecifier(spec);
        this.establishQueryServerConnection(true);
        ResponseDelete respdel = (ResponseDelete)query.execute(this.querydb);
        if (respdel == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException("Could not perform delete: " + lastError.message);
        }
        for (ResponseDelete.DeleteResult delres : respdel.reslist) {
            Msg.info((Object)this, (Object)("Successfully deleted " + delres.name + "(" + Integer.toString(delres.funccount) + " functions)" + delres.md5));
        }
        for (ExeSpecifier missedSpec : respdel.missedlist) {
            Msg.error((Object)this, (Object)("Unable to uniquely identify: " + missedSpec.getExeNameWithMD5()));
        }
    }

    public void dropIndex() throws IOException, LSHException {
        DatabaseInformation info = this.establishQueryServerConnection(false);
        AdjustVectorIndex query = new AdjustVectorIndex();
        query.doRebuild = false;
        ResponseAdjustIndex response = (ResponseAdjustIndex)query.execute(this.querydb);
        if (response == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException("Could not drop index: " + lastError.message);
        }
        String dbDetail = "for database " + info.databasename + " (" + String.valueOf(this.bsimServerInfo) + ")";
        if (!response.success) {
            String msg = "Could not drop the index " + dbDetail;
            if (!response.operationSupported) {
                msg = msg + ": operation not supported";
            }
            Msg.error((Object)this, (Object)msg);
        } else {
            Msg.info((Object)this, (Object)("Successfully dropped index " + dbDetail));
        }
    }

    public void rebuildIndex() throws IOException, LSHException {
        DatabaseInformation info = this.establishQueryServerConnection(false);
        AdjustVectorIndex query = new AdjustVectorIndex();
        query.doRebuild = true;
        System.out.println("Starting rebuild ...");
        ResponseAdjustIndex response = (ResponseAdjustIndex)query.execute(this.querydb);
        if (response == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException("Could not rebuild index: " + lastError.message);
        }
        String dbDetail = "for database " + info.databasename + " (" + String.valueOf(this.bsimServerInfo) + ")";
        if (!response.success) {
            String msg = "Could not rebuild index " + dbDetail;
            if (!response.operationSupported) {
                msg = msg + ": operation not supported";
            }
            Msg.error((Object)this, (Object)msg);
        } else {
            Msg.info((Object)this, (Object)("Successfully rebuilt index " + dbDetail));
        }
    }

    public void prewarm() throws IOException, LSHException {
        DatabaseInformation info = this.establishQueryServerConnection(false);
        PrewarmRequest request = new PrewarmRequest();
        ResponsePrewarm response = (ResponsePrewarm)request.execute(this.querydb);
        if (response == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException("Prewarm failed: " + lastError.message);
        }
        String dbDetail = "for database " + info.databasename + " (" + String.valueOf(this.bsimServerInfo) + ")";
        if (!response.operationSupported) {
            Msg.error((Object)this, (Object)("Prewarm operation not supported " + dbDetail));
        } else {
            Msg.info((Object)this, (Object)("Successfully prewarmed " + Integer.toString(response.blockCount) + " blocks of main index " + dbDetail));
        }
    }

    protected List<ExecutableRecord> getExes(int limit, String md5Filter, String exeNameFilter, String archFilter, String compilerFilter, String sortCol, boolean incFakes) throws IOException, LSHException {
        this.establishQueryServerConnection(false);
        ExeTable.ExeTableOrderColumn sortEnum = sortCol != null ? ExeTable.ExeTableOrderColumn.valueOf(sortCol.toUpperCase()) : ExeTable.ExeTableOrderColumn.MD5;
        QueryExeInfo exeQuery = new QueryExeInfo(limit, md5Filter, exeNameFilter, archFilter, compilerFilter, sortEnum, incFakes);
        ResponseExe response = (ResponseExe)exeQuery.execute(this.querydb);
        if (response == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException("Could not perform getexeinfo: " + lastError.message);
        }
        return response.records;
    }

    public int getCount(String md5Filter, String exeNameFilter, String archFilter, String compilerFilter, boolean incFakes) throws IOException {
        this.establishQueryServerConnection(false);
        QueryExeCount exeQuery = new QueryExeCount(md5Filter, exeNameFilter, archFilter, compilerFilter, incFakes);
        ResponseExe response = (ResponseExe)exeQuery.execute(this.querydb);
        if (response == null) {
            return 0;
        }
        return response.recordCount;
    }

    protected static String dequoteString(String val) {
        if (val.length() < 3) {
            return val;
        }
        if (val.charAt(0) != '\"') {
            return val;
        }
        if (val.charAt(val.length() - 1) != '\"') {
            return val;
        }
        val = val.substring(1, val.length() - 1);
        return val;
    }

    protected void installMetadata(String name, String owner, String description) throws IOException, LSHException {
        DatabaseInformation info = this.establishQueryServerConnection(false);
        InstallMetadataRequest req = new InstallMetadataRequest();
        req.dbname = name;
        req.owner = owner;
        req.description = description;
        ResponseInfo resp = (ResponseInfo)req.execute(this.querydb);
        if (resp == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException("Could not change metadata: " + lastError.message);
        }
        info = resp.info;
        Msg.info((Object)this, (Object)"Updated BSim metadata: ");
        Msg.info((Object)this, (Object)("   Database:     " + info.databasename));
        Msg.info((Object)this, (Object)("   Owner:        " + info.owner));
        Msg.info((Object)this, (Object)("   Description:  " + info.description));
    }

    public void printMetadata() throws IOException {
        DatabaseInformation info = this.establishQueryServerConnection(false);
        Msg.info((Object)this, (Object)"BSim metadata: ");
        Msg.info((Object)this, (Object)("   Database:     " + info.databasename));
        Msg.info((Object)this, (Object)("   Owner:        " + info.owner));
        Msg.info((Object)this, (Object)("   Description:  " + info.description));
    }

    public void installCategory(String categoryName, boolean isDate) throws LSHException, IOException {
        DatabaseInformation info = this.establishQueryServerConnection(false);
        InstallCategoryRequest req = new InstallCategoryRequest();
        req.type_name = BulkSignatures.dequoteString(categoryName);
        req.isdatecolumn = isDate;
        ResponseInfo resp = (ResponseInfo)req.execute(this.querydb);
        if (resp == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException("Could not install new category: " + lastError.message);
        }
        info = resp.info;
        StringBuilder buf = new StringBuilder();
        buf.append("BSim Database ");
        buf.append(info.databasename);
        buf.append(" now contains:\n");
        this.formatCategories(info.execats, buf);
        if (info.dateColumnName != null) {
            buf.append(" Date column: ");
            buf.append(info.dateColumnName);
            buf.append("\n");
        }
        Msg.info((Object)this, (Object)buf.toString());
    }

    public void installTags(String tagName) throws IOException, LSHException {
        DatabaseInformation info = this.establishQueryServerConnection(false);
        InstallTagRequest req = new InstallTagRequest();
        req.tag_name = BulkSignatures.dequoteString(tagName);
        ResponseInfo resp = (ResponseInfo)req.execute(this.querydb);
        if (resp == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException(lastError.message);
        }
        info = resp.info;
        StringBuilder buf = new StringBuilder();
        buf.append("BSim Database ");
        buf.append(info.databasename);
        buf.append(" now contains:\n");
        this.formatFunctionTags(info.functionTags, buf);
        Msg.info((Object)this, (Object)buf.toString());
    }

    protected static int readQueryPairs(XmlPullParser parser, int count, List<PairInput> pairs) {
        for (int i = 0; i < count; ++i) {
            if (!parser.peek().isStart()) {
                return i;
            }
            PairInput pairInput = new PairInput();
            pairInput.restoreXml(parser);
            pairs.add(pairInput);
        }
        return count;
    }

    protected void queryPair(File inputFile, File outputFile) throws IOException, SAXException, LSHException {
        if (!inputFile.isFile()) {
            throw new IOException(inputFile.getAbsolutePath() + " is not an XML file");
        }
        if (outputFile.isFile()) {
            Msg.info((Object)this, (Object)("Overwriting file " + outputFile.getAbsolutePath()));
            outputFile.delete();
        }
        this.establishQueryServerConnection(true);
        QueryPair query = new QueryPair();
        query.pairs = new ArrayList<PairInput>();
        ErrorHandler handler = SpecXmlUtils.getXmlHandler();
        XmlPullParser parser = XmlPullParserFactory.create((File)inputFile, (ErrorHandler)handler, (boolean)false);
        parser.start(new String[]{"querypair"});
        try (FileWriter writer = new FileWriter(outputFile);){
            writer.append("<responsepair>\n");
            ResponsePair.Accumulator accumulator = new ResponsePair.Accumulator();
            ResponsePair finalResponse = new ResponsePair();
            int count = BulkSignatures.readQueryPairs(parser, 20, query.pairs);
            while (count != 0) {
                ResponsePair responsePair = (ResponsePair)query.execute(this.querydb);
                if (responsePair == null) {
                    FunctionDatabase.BSimError lastError = this.querydb.getLastError();
                    throw new LSHException(lastError.message);
                }
                for (PairNote note : responsePair.notes) {
                    note.saveXml(writer);
                }
                finalResponse.scale = responsePair.scale;
                accumulator.merge(responsePair);
                query.pairs.clear();
                query.clearResponse();
                count = BulkSignatures.readQueryPairs(parser, 20, query.pairs);
            }
            parser.end();
            finalResponse.fillOutStatistics(accumulator);
            finalResponse.saveXmlTail(writer);
            writer.append("</responsepair>\n");
        }
    }

    protected void printFunctions(QueryName query, PrintStream outStream) throws IOException, LSHException {
        this.establishQueryServerConnection(true);
        ResponseName resp = (ResponseName)query.execute(this.querydb);
        if (resp == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException(lastError.message);
        }
        resp.printRaw(outStream, this.querydb.getLSHVectorFactory(), 0);
    }

    public void dumpSigs(File resultFolder, String md5, String name) throws IOException, LSHException {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{md5}) && StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{name})) {
            throw new IOException("Must specify \"md5=\" or \"name=\"");
        }
        QueryName query = new QueryName();
        query.spec.exemd5 = md5;
        query.spec.exename = name;
        query.spec.arch = null;
        query.spec.execompname = null;
        this.doDumpSigs(resultFolder, query);
    }

    protected void doDumpSigs(File resultFolder, QueryName query) throws IOException, LSHException {
        if (!resultFolder.isDirectory()) {
            throw new IOException(resultFolder.getAbsolutePath() + " is not a valid directory");
        }
        DatabaseInformation info = this.establishQueryServerConnection(true);
        query.fillinCallgraph = info.trackcallgraph;
        ResponseName responseName = (ResponseName)query.execute(this.querydb);
        if (responseName == null) {
            FunctionDatabase.BSimError lastError = this.querydb.getLastError();
            throw new LSHException(lastError.message);
        }
        if (!responseName.uniqueexecutable) {
            throw new LSHException("Could not determine unique executable");
        }
        ExecutableRecord exe = !StringUtils.isAllBlank((CharSequence[])new CharSequence[]{query.spec.exemd5}) ? responseName.manage.findExecutable(query.spec.exemd5) : responseName.manage.findExecutable(query.spec.exename, query.spec.arch, query.spec.execompname);
        String basename = "sigs_" + exe.getMd5();
        File sigFile = new File(resultFolder, basename);
        try (FileWriter writer = new FileWriter(sigFile);){
            responseName.manage.saveXml(writer);
        }
    }

    protected File establishTemporaryDirectory(String xmldir) throws IOException {
        File dir;
        if (xmldir == null) {
            File tmpDir = Application.getUserTempDirectory();
            if (tmpDir == null) {
                throw new IOException("Could not find temporary directory");
            }
            dir = new File(tmpDir, "bulkinsert_xml");
            this.deleteTemporaryDirectory(dir);
        } else {
            dir = new File(xmldir);
        }
        if (!dir.exists()) {
            if (!dir.mkdir()) {
                throw new IOException("Unable to create temp directory: " + dir.getAbsolutePath());
            }
        } else if (!dir.isDirectory()) {
            throw new IOException(dir.getAbsolutePath() + ": is not a directory");
        }
        dir = dir.getCanonicalFile();
        return dir;
    }

    private void deleteTemporaryDirectory(File tempDir) throws IOException {
        if (!tempDir.exists()) {
            return;
        }
        File[] listFiles = tempDir.listFiles();
        if (listFiles == null) {
            throw new IOException("Could not list files in temp directory: " + tempDir.getAbsolutePath());
        }
        for (File listFile : listFiles) {
            if (listFile.delete()) continue;
            throw new IOException("Unable to delete temporary file: " + listFile.getAbsolutePath());
        }
        if (!tempDir.delete()) {
            throw new IOException("Unable to delete temp directory: " + tempDir.getAbsolutePath());
        }
    }

    private class SignatureRepository
    extends IterateRepository {
        private File outdirectory;
        private String repo;
        private boolean overwrite;
        private DatabaseInformation info;
        private LSHVectorFactory vectorFactory;

        public SignatureRepository(BulkSignatures bulkSignatures, File outdir, String rp, boolean owrite, DatabaseInformation i, LSHVectorFactory vFactory) {
            this.outdirectory = outdir;
            this.repo = rp;
            this.overwrite = owrite;
            this.info = i;
            this.vectorFactory = vFactory;
        }

        @Override
        protected void process(Program program, TaskMonitor monitor) throws IOException {
            String md5string = program.getExecutableMD5();
            if (md5string == null || md5string.length() < 10) {
                Msg.error((Object)this, (Object)("Could not get MD5 on file: " + program.getDomainFile().getName()));
                return;
            }
            String basename = "sigs_" + md5string;
            File file = new File(this.outdirectory, basename);
            if (!this.overwrite && file.exists()) {
                Msg.warn((Object)this, (Object)("Signature file already exists for: " + program.getDomainFile().getName()));
                return;
            }
            GenSignatures gensig = new GenSignatures(true);
            try {
                gensig.setVectorFactory(this.vectorFactory);
                gensig.addExecutableCategories(this.info.execats);
                gensig.addFunctionTags(this.info.functionTags);
                gensig.addDateColumnName(this.info.dateColumnName);
                Msg.info((Object)this, (Object)("Generating signatures for: " + program.getDomainFile().getName()));
                String path = GenSignatures.getPathFromDomainFile(program);
                gensig.openProgram(program, null, null, null, this.repo, path);
                FunctionManager fman = program.getFunctionManager();
                FunctionIterator iterator = fman.getFunctions(true);
                gensig.scanFunctions((Iterator<Function>)iterator, fman.getFunctionCount(), null);
                DescriptionManager manager = gensig.getDescriptionManager();
                if (manager.numFunctions() == 0) {
                    Msg.warn((Object)this, (Object)(program.getDomainFile().getName() + " contains no functions with signatures"));
                    return;
                }
                FileWriter fwrite = new FileWriter(file);
                manager.saveXml(fwrite);
                fwrite.close();
            }
            catch (DecompileException | LSHException e) {
                throw new IOException("Program signature generation failure: " + e.getMessage());
            }
        }
    }

    private class UpdateRepository
    extends IterateRepository {
        private File outdirectory;
        private String repo;
        private boolean overwrite;
        private DatabaseInformation info;
        private LSHVectorFactory vectorFactory;

        public UpdateRepository(BulkSignatures bulkSignatures, File outdir, String rp, boolean owrite, DatabaseInformation i, LSHVectorFactory vFactory) {
            this.outdirectory = outdir;
            this.repo = rp;
            this.overwrite = owrite;
            this.info = i;
            this.vectorFactory = vFactory;
        }

        @Override
        protected void process(Program program, TaskMonitor monitor) throws IOException {
            String md5string = program.getExecutableMD5();
            if (md5string == null || md5string.length() < 10) {
                Msg.error((Object)this, (Object)("Could not get MD5 on file: " + program.getDomainFile().getName()));
                return;
            }
            String basename = "update_" + md5string;
            File file = new File(this.outdirectory, basename);
            if (!this.overwrite && file.exists()) {
                Msg.warn((Object)this, (Object)("Update file already exists for: " + program.getDomainFile().getName()));
                return;
            }
            GenSignatures gensig = new GenSignatures(true);
            try {
                gensig.setVectorFactory(this.vectorFactory);
                gensig.addExecutableCategories(this.info.execats);
                gensig.addFunctionTags(this.info.functionTags);
                gensig.addDateColumnName(this.info.dateColumnName);
                Msg.info((Object)this, (Object)("Generating metadata for: " + program.getDomainFile().getName()));
                String path = GenSignatures.getPathFromDomainFile(program);
                gensig.openProgram(program, null, null, null, this.repo, path);
                gensig.scanFunctionsMetadata(null, null);
                DescriptionManager manager = gensig.getDescriptionManager();
                if (manager.numFunctions() == 0) {
                    Msg.warn((Object)this, (Object)(program.getDomainFile().getName() + " contains no functions with bodies"));
                }
                try (FileWriter fwrite = new FileWriter(file);){
                    manager.saveXml(fwrite);
                }
            }
            catch (LSHException e) {
                throw new IOException("Program signature generation failure: " + e.getMessage());
            }
        }
    }
}

