/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import ghidra.program.model.symbol.SourceType;

class RefListFlagsV0 {
    private static final int SOURCE_LOBIT = 1;
    private static final int IS_PRIMARY = 2;
    private static final int IS_OFFSET = 4;
    private static final int HAS_SYMBOL_ID = 8;
    private static final int IS_SHIFT = 16;
    private static final int SOURCE_HIBITS = 96;
    private static final int SOURCE_HIBIT = 32;
    private static final int SOURCE_LOBIT_SHIFT = 0;
    private static final int SOURCE_HIBITS_SHIFT = 5;
    private static final int MAX_SOURCE_VALUE = 7;
    private int flags;

    RefListFlagsV0(byte flags) {
        this.flags = flags;
    }

    public RefListFlagsV0(boolean isPrimary, boolean isOffsetRef, boolean hasSymbolID, boolean isShiftRef, SourceType source) {
        int sourceId;
        this.flags = 0;
        switch (source) {
            case DEFAULT: {
                int n = 0;
                break;
            }
            case ANALYSIS: {
                int n = 2;
                break;
            }
            default: {
                int n = sourceId = source.getStorageId();
            }
        }
        if (sourceId > 7) {
            throw new RuntimeException("Unsupported SourceType storage ID: " + sourceId);
        }
        int sourceTypeLoBit = (sourceId & 1) << 0;
        int sourceTypeHiBits = sourceId >>> 1 << 5;
        this.flags |= sourceTypeHiBits | sourceTypeLoBit;
        if (isPrimary) {
            this.flags |= 2;
        }
        if (isOffsetRef) {
            this.flags |= 4;
        }
        if (hasSymbolID) {
            this.flags |= 8;
        }
        if (isShiftRef) {
            this.flags |= 0x10;
        }
    }

    byte getValue() {
        return (byte)this.flags;
    }

    SourceType getSource() {
        int sourceTypeLoBit = (this.flags & 1) >>> 0;
        int sourceTypeHiBits = (this.flags & 0x60) >>> 4;
        int sourceTypeId = sourceTypeHiBits | sourceTypeLoBit;
        return switch (sourceTypeId) {
            case 0 -> SourceType.DEFAULT;
            case 2 -> SourceType.ANALYSIS;
            default -> SourceType.getSourceType(sourceTypeId);
        };
    }

    public boolean hasSymbolID() {
        return (this.flags & 8) != 0;
    }

    public boolean isShiftRef() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isOffsetRef() {
        return (this.flags & 4) != 0;
    }

    public boolean isPrimary() {
        return (this.flags & 2) != 0;
    }

    public void setPrimary(boolean isPrimary) {
        this.flags &= 0xFFFFFFFD;
        if (isPrimary) {
            this.flags |= 2;
        }
    }

    public void setHasSymbolID(boolean hasSymbolID) {
        this.flags &= 0xFFFFFFF7;
        if (hasSymbolID) {
            this.flags |= 8;
        }
    }
}

