/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbol;
import ghidra.trace.model.symbol.TraceSymbolManager;
import ghidra.trace.model.symbol.TraceSymbolView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.LockHold;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public interface TraceSymbolWithLocationView<T extends TraceSymbol>
extends TraceSymbolView<T> {
    public T getChildWithNameAt(String var1, long var2, Address var4, TraceNamespaceSymbol var5);

    default public T getChildWithNameAt(String name, TracePlatform platform, long snap, TraceThread thread, Register register, TraceNamespaceSymbol parent) {
        AddressSpace space = TraceRegisterUtils.getRegisterAddressSpace(thread, 0, false);
        if (space == null) {
            return null;
        }
        AddressRange range = platform.getConventionalRegisterRange(space, register);
        return this.getChildWithNameAt(name, snap, range.getMinAddress(), parent);
    }

    default public T getChildWithNameAt(String name, long snap, TraceThread thread, Register register, TraceNamespaceSymbol parent) {
        return this.getChildWithNameAt(name, this.getTrace().getPlatformManager().getHostPlatform(), snap, thread, register, parent);
    }

    default public T getGlobalWithNameAt(String name, long snap, Address address) {
        return this.getChildWithNameAt(name, snap, address, this.getManager().getGlobalNamespace());
    }

    public Collection<? extends T> getIntersecting(Lifespan var1, AddressRange var2, boolean var3, boolean var4);

    default public Collection<? extends T> getIntersecting(TracePlatform platform, Lifespan span, TraceThread thread, Register register, boolean includeDynamicSymbols, boolean forward) {
        AddressSpace space = TraceRegisterUtils.getRegisterAddressSpace(thread, 0, false);
        if (space == null) {
            return List.of();
        }
        AddressRange range = platform.getConventionalRegisterRange(space, register);
        return this.getIntersecting(span, range, includeDynamicSymbols, forward);
    }

    default public Collection<? extends T> getIntersecting(Lifespan span, TraceThread thread, Register register, boolean includeDynamicSymbols, boolean forward) {
        return this.getIntersecting(this.getTrace().getPlatformManager().getHostPlatform(), span, thread, register, includeDynamicSymbols, forward);
    }

    default public Collection<? extends T> getAt(long snap, Address address, boolean includeDynamicSymbols) {
        try (LockHold hold = this.getManager().getTrace().lockRead();){
            ArrayList<T> result = new ArrayList<T>(this.getIntersecting(Lifespan.at(snap), (AddressRange)new AddressRangeImpl(address, address), includeDynamicSymbols, true));
            result.sort(TraceSymbolManager.PRIMALITY_COMPARATOR);
            ArrayList<T> arrayList = result;
            return arrayList;
        }
    }

    default public Collection<? extends T> getAt(TracePlatform platform, long snap, TraceThread thread, Register register, boolean includeDynamicSymbols) {
        AddressSpace space = TraceRegisterUtils.getRegisterAddressSpace(thread, 0, false);
        if (space == null) {
            return List.of();
        }
        AddressRange range = platform.getConventionalRegisterRange(space, register);
        return this.getAt(snap, range.getMinAddress(), includeDynamicSymbols);
    }

    default public Collection<? extends T> getAt(long snap, TraceThread thread, Register register, boolean includeDynamicSymbols) {
        return this.getAt(this.getTrace().getPlatformManager().getHostPlatform(), snap, thread, register, includeDynamicSymbols);
    }

    default public boolean hasAt(long snap, Address address, boolean includeDynamicSymbols) {
        try (LockHold hold = this.getManager().getTrace().lockRead();){
            boolean bl = !this.getIntersecting(Lifespan.at(snap), (AddressRange)new AddressRangeImpl(address, address), includeDynamicSymbols, true).isEmpty();
            return bl;
        }
    }
}

