/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugin.importer;

import docking.DialogComponentProvider;
import docking.widgets.EmptyBorderButton;
import docking.widgets.button.BrowseButton;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.dialogs.MultiLineMessageDialog;
import docking.widgets.label.GLabel;
import docking.widgets.list.GComboBoxCellRenderer;
import generic.theme.GIcon;
import generic.theme.Gui;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.AddressFactoryService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionValidator;
import ghidra.app.util.OptionsDialog;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.app.util.opinion.LoaderMap;
import ghidra.app.util.opinion.LoaderService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.main.DataTreeDialog;
import ghidra.framework.main.DataTreeDialogType;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.plugin.importer.ImporterLanguageDialog;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.layout.HorizontalLayout;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import ghidra.util.task.TaskBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class ImporterDialog
extends DialogComponentProvider {
    protected PluginTool tool;
    private ProgramManager programManager;
    protected FSRL fsrl;
    protected List<Option> options;
    private LoaderMap loaderMap;
    protected LanguageCompilerSpecPair selectedLanguage;
    private DomainFolder destinationFolder;
    private boolean languageNeeded;
    private String suggestedDestinationPath;
    private String previousName;
    protected ByteProvider byteProvider;
    protected JTextField nameTextField;
    private boolean userHasChangedName;
    protected JButton folderButton;
    protected JButton languageButton;
    protected JTextField languageTextField;
    protected JCheckBox mirrorFsCheckBox;
    protected JButton optionsButton;
    protected JTextField folderNameTextField;
    protected GhidraComboBox<Loader> loaderComboBox;

    public ImporterDialog(PluginTool tool, ProgramManager programManager, LoaderMap loaderMap, ByteProvider byteProvider, String suggestedDestinationPath) {
        this("Import " + byteProvider.getFSRL().getPath(), tool, loaderMap, byteProvider, suggestedDestinationPath);
        this.programManager = programManager;
    }

    protected ImporterDialog(String title, PluginTool tool, LoaderMap loaderMap, ByteProvider byteProvider, String suggestedDestinationPath) {
        super(title);
        this.tool = tool;
        this.programManager = (ProgramManager)tool.getService(ProgramManager.class);
        this.fsrl = byteProvider.getFSRL();
        this.loaderMap = loaderMap;
        this.byteProvider = byteProvider;
        this.suggestedDestinationPath = suggestedDestinationPath;
        if (FileSystemService.getInstance().isLocal(this.fsrl)) {
            Preferences.setProperty((String)"LastImportFile", (String)this.fsrl.getPath());
        } else if (this.fsrl.getFS().getContainer() != null) {
            Preferences.setProperty((String)"LastImportFile", (String)this.fsrl.getFS().getContainer().getPath());
        }
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setOkEnabled(false);
        this.setDestinationFolder(this.getProjectRootFolder());
        this.selectedLoaderChanged();
        this.setMinimumSize(new Dimension(500, this.getPreferredSize().height));
        this.setRememberSize(false);
        this.setHelpLocation(new HelpLocation("ImporterPlugin", "Importer_Dialog"));
    }

    public void setDestinationFolder(DomainFolder folder) {
        this.destinationFolder = folder;
        this.folderNameTextField.setText(this.destinationFolder.getPathname());
        this.validateFormInput();
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.buildMainPanel());
        panel.add(this.buildButtonPanel());
        panel.getAccessibleContext().setAccessibleName("Importer");
        return panel;
    }

    private Component buildMainPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new GLabel("Format: ", 4));
        panel.add(this.buildLoaderChooser());
        panel.add((Component)new GLabel("Language: ", 4));
        panel.add(this.buildLanguagePanel());
        panel.add((Component)new GLabel("Destination Folder: ", 4));
        panel.add(this.buildFolderPanel());
        panel.add((Component)new GLabel("Program Name: ", 4));
        panel.add(this.buildNameTextField());
        panel.getAccessibleContext().setAccessibleName("Importer Details");
        return panel;
    }

    private Component buildNameTextField() {
        String initalSuggestedName = FSUtilities.appendPath(this.suggestedDestinationPath, this.getSuggestedName());
        int columns = initalSuggestedName.length() > 50 ? 50 : 0;
        this.nameTextField = new JTextField(initalSuggestedName, columns);
        this.nameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                ImporterDialog.this.userHasChangedName = true;
            }
        });
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ImporterDialog.this.validateFormInput();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ImporterDialog.this.validateFormInput();
            }
        });
        this.nameTextField.getAccessibleContext().setAccessibleName("Name");
        return this.nameTextField;
    }

    private String getSuggestedName() {
        Loader loader = this.getSelectedLoader();
        if (loader != null) {
            return loader.getPreferredFileName(this.byteProvider);
        }
        return this.fsrl.getName();
    }

    private Component buildFolderPanel() {
        this.folderNameTextField = new JTextField();
        this.folderNameTextField.setEditable(false);
        this.folderNameTextField.setFocusable(false);
        this.folderNameTextField.getAccessibleContext().setAccessibleName("Folder Name");
        this.folderButton = new BrowseButton();
        this.folderButton.addActionListener(e -> this.chooseProjectFolder());
        this.folderButton.getAccessibleContext().setAccessibleName("Folder");
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.folderNameTextField, "Center");
        panel.add((Component)this.folderButton, "East");
        panel.getAccessibleContext().setAccessibleName("Folder");
        return panel;
    }

    private JComponent buildLanguagePanel() {
        this.languageTextField = new JTextField();
        this.languageTextField.setEditable(false);
        this.languageTextField.setFocusable(false);
        this.languageTextField.getAccessibleContext().setAccessibleName("Language");
        this.languageButton = new BrowseButton();
        this.languageButton.getAccessibleContext().setAccessibleName("Language");
        this.languageButton.addActionListener(e -> {
            Object selectedItem = this.loaderComboBox.getSelectedItem();
            if (selectedItem instanceof Loader) {
                Loader loader = (Loader)selectedItem;
                ImporterLanguageDialog dialog = new ImporterLanguageDialog((Collection)this.loaderMap.get(loader), this.tool, this.selectedLanguage);
                dialog.show(this.getComponent());
                LanguageCompilerSpecPair dialogResult = dialog.getSelectedLanguage();
                if (dialogResult != null) {
                    this.setSelectedLanguage(dialogResult);
                }
            }
            this.validateFormInput();
        });
        Gui.registerFont((JComponent)this.languageButton, (int)1);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.languageTextField, "Center");
        panel.add((Component)this.languageButton, "East");
        panel.getAccessibleContext().setAccessibleName("Language");
        return panel;
    }

    private Component buildLoaderChooser() {
        JPanel panel = new JPanel(new BorderLayout());
        LinkedHashSet orderedLoaders = new LinkedHashSet(this.loaderMap.keySet());
        this.loaderComboBox = new GhidraComboBox(orderedLoaders);
        this.loaderComboBox.addItemListener(e -> this.selectedLoaderChanged());
        this.loaderComboBox.getAccessibleContext().setAccessibleName("Loader Choices");
        this.loaderComboBox.setRenderer((ListCellRenderer)GComboBoxCellRenderer.createDefaultTextRenderer(loader -> loader.getName()));
        if (!orderedLoaders.isEmpty()) {
            this.loaderComboBox.setSelectedIndex(0);
        }
        panel.add((Component)this.loaderComboBox, "Center");
        panel.add(this.buildLoaderInfoButton(), "East");
        panel.getAccessibleContext().setAccessibleName("Loader Choice");
        return panel;
    }

    private Component buildLoaderInfoButton() {
        JPanel panel = new JPanel(new BorderLayout());
        EmptyBorderButton helpButton = new EmptyBorderButton((Icon)new GIcon("icon.information"));
        helpButton.setToolTipText("Show list of supported format/loaders");
        helpButton.getAccessibleContext().setAccessibleName("Loader Info");
        helpButton.addActionListener(e -> this.showSupportedImportFormats());
        panel.add((Component)helpButton);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
        panel.getAccessibleContext().setAccessibleName("Loader Info");
        return panel;
    }

    private void showSupportedImportFormats() {
        String s = LoaderService.getAllLoaderNames().stream().collect(Collectors.joining("\n"));
        MultiLineMessageDialog.showModalMessageDialog(null, (String)"Supported Formats", null, (String)s, (int)-1);
    }

    protected void selectedLoaderChanged() {
        Loader loader = (Loader)this.loaderComboBox.getItemAt(this.loaderComboBox.getSelectedIndex());
        if (loader != null) {
            this.languageNeeded = this.isLanguageNeeded(loader);
            this.setSelectedLanguage(this.getPreferredLanguage(loader));
            String newSuggestedName = FSUtilities.appendPath(this.suggestedDestinationPath, this.getSuggestedName());
            this.setName(newSuggestedName);
        } else {
            this.languageNeeded = true;
            this.setSelectedLanguage(null);
        }
        this.options = null;
        this.validateFormInput();
    }

    private boolean isLanguageNeeded(Loader loader) {
        return ((Collection)this.loaderMap.get(loader)).stream().anyMatch(spec -> spec.requiresLanguageCompilerSpec());
    }

    private Component buildButtonPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel innerPanel = new JPanel((LayoutManager)new HorizontalLayout(5));
        innerPanel.add(this.buildMirrorFsCheckbox());
        innerPanel.add(this.buildOptionsButton());
        panel.add((Component)innerPanel, "East");
        panel.getAccessibleContext().setAccessibleName("Buttons");
        return panel;
    }

    private Component buildMirrorFsCheckbox() {
        this.mirrorFsCheckBox = new JCheckBox("Mirror Filesystem", false);
        this.mirrorFsCheckBox.addActionListener(e -> this.mirrorFs());
        this.mirrorFsCheckBox.getAccessibleContext().setAccessibleName("Mirror");
        return this.mirrorFsCheckBox;
    }

    private Component buildOptionsButton() {
        this.optionsButton = new JButton("Options...");
        this.optionsButton.addActionListener(e -> this.showOptions());
        this.optionsButton.getAccessibleContext().setAccessibleName("Options");
        return this.optionsButton;
    }

    protected void okCallback() {
        if (!this.validateFormInput()) {
            return;
        }
        Loader loader = this.getSelectedLoader();
        LoadSpec loadSpec = this.getSelectedLoadSpec(loader);
        this.options = this.getOptions(loadSpec, false);
        new TaskBuilder("Import File", monitor -> ImporterUtilities.importSingleFile(this.tool, this.programManager, this.fsrl, this.destinationFolder.getPathname(), this.mirrorFsCheckBox.isSelected(), loadSpec, this.removeTrailingSlashes(this.getName()), this.options, monitor)).setLaunchDelay(0).launchNonModal();
        this.close();
    }

    private String removeTrailingSlashes(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public void close() {
        super.close();
        try {
            this.byteProvider.close();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), null, (String)"Unexpected exception closing byte provider.", (Object)e);
        }
    }

    protected List<Option> getOptions(LoadSpec loadSpec, boolean forceRefresh) {
        if (this.options == null || forceRefresh) {
            this.options = loadSpec.getLoader().getDefaultOptions(this.byteProvider, loadSpec, null, false, this.mirrorFsCheckBox.isSelected());
        }
        return this.options;
    }

    private void mirrorFs() {
        this.nameTextField.setEnabled(!this.mirrorFsCheckBox.isSelected());
        if (this.mirrorFsCheckBox.isSelected()) {
            this.previousName = this.getName();
            String path = FSUtilities.mirroredProjectPath(this.fsrl.getPath());
            this.nameTextField.setText(path);
            this.nameTextField.setCaretPosition(path.length());
        } else if (this.previousName != null) {
            this.nameTextField.setText(this.previousName);
            this.nameTextField.setCaretPosition(this.previousName.length());
        }
    }

    private void showOptions() {
        try {
            Loader loader = this.getSelectedLoader();
            AddressFactory addressFactory = this.selectedLanguage.getLanguage().getAddressFactory();
            LoadSpec loadSpec = this.getSelectedLoadSpec(loader);
            OptionValidator validator = optionList -> loader.validateOptions(this.byteProvider, loadSpec, optionList, null);
            AddressFactoryService service = () -> addressFactory;
            List<Option> currentOptions = this.getOptions(loadSpec, true);
            if (currentOptions.isEmpty()) {
                Msg.showInfo((Object)((Object)this), null, (String)"Options", (Object)"There are no options for this importer!");
                return;
            }
            OptionsDialog optionsDialog = new OptionsDialog(currentOptions, validator, service);
            optionsDialog.setHelpLocation(new HelpLocation("ImporterPlugin", this.getAnchorForSelectedLoader(loader)));
            this.tool.showDialog((DialogComponentProvider)optionsDialog);
            if (!optionsDialog.wasCancelled()) {
                this.options = optionsDialog.getOptions();
            }
            this.validateFormInput();
        }
        catch (LanguageNotFoundException e) {
            Msg.showError((Object)((Object)this), null, (String)"Language Error", (Object)("Can't get the language for " + String.valueOf(this.selectedLanguage)));
        }
    }

    private String getAnchorForSelectedLoader(Loader loader) {
        return "Options_" + loader.getName();
    }

    protected LoadSpec getSelectedLoadSpec(Loader loader) {
        Collection loadSpecs = (Collection)this.loaderMap.get(loader);
        long imageBase = 0L;
        if (loadSpecs != null && !loadSpecs.isEmpty()) {
            imageBase = ((LoadSpec)loadSpecs.iterator().next()).getDesiredImageBase();
        }
        return new LoadSpec(loader, imageBase, this.selectedLanguage, false);
    }

    protected Loader getSelectedLoader() {
        return (Loader)this.loaderComboBox.getSelectedItem();
    }

    protected boolean validateFormInput() {
        this.setOkEnabled(false);
        this.languageButton.setEnabled(this.languageNeeded);
        this.optionsButton.setEnabled(false);
        if (this.loaderComboBox.getSelectedIndex() == -1) {
            this.setStatusText("Please select a format.");
            return false;
        }
        if (this.languageNeeded && this.selectedLanguage == null) {
            this.setStatusText("Please select a language.");
            return false;
        }
        this.optionsButton.setEnabled(this.selectedLanguage != null);
        if (!this.validateName()) {
            return false;
        }
        this.setStatusText("");
        this.setOkEnabled(true);
        return true;
    }

    private boolean validateName() {
        String destType;
        Loader loader = this.getSelectedLoader();
        boolean loadsIntoFolder = loader.loadsIntoNewFolder();
        String string = destType = loadsIntoFolder ? "folder" : "file name";
        if (this.getName().isEmpty()) {
            this.setStatusText("Please enter a destination " + destType + ".");
            return false;
        }
        if (this.warnedAboutInvalidNameChars()) {
            return false;
        }
        if (this.isMissingName()) {
            this.setStatusText("Destination path does not specify " + destType + ".");
            return false;
        }
        if (this.isDuplicateName(loadsIntoFolder)) {
            this.setStatusText("Destination " + destType + " already exists.");
            return false;
        }
        if (this.isNameTooLong()) {
            this.setStatusText("Destination " + destType + " is too long. ( >" + this.tool.getProject().getProjectData().getMaxNameLength() + ")");
            return false;
        }
        return true;
    }

    private boolean warnedAboutInvalidNameChars() {
        String name = this.getName();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (LocalFileSystem.isValidNameCharacter((char)ch) || ch == '/') continue;
            this.setStatusText("Invalid character " + ch + " in name.");
            return true;
        }
        return false;
    }

    private boolean isMissingName() {
        String name = FilenameUtils.getName((String)this.getName());
        return StringUtils.isBlank((CharSequence)name);
    }

    private boolean isDuplicateName(boolean isFolder) {
        DomainFolder localDestFolder;
        String pathName = this.getName();
        String parentPath = FilenameUtils.getFullPathNoEndSeparator((String)pathName);
        String fileOrFolderName = FilenameUtils.getName((String)pathName);
        DomainFolder domainFolder = localDestFolder = parentPath != null ? ProjectDataUtils.getDomainFolder((DomainFolder)this.destinationFolder, (String)parentPath) : this.destinationFolder;
        return localDestFolder != null && (isFolder && localDestFolder.getFolder(fileOrFolderName) != null || !isFolder && localDestFolder.getFile(fileOrFolderName) != null);
    }

    private boolean isNameTooLong() {
        int maxNameLen = this.tool.getProject().getProjectData().getMaxNameLength();
        for (String pathPart : this.getName().split("/")) {
            if (pathPart.length() < maxNameLen) continue;
            return true;
        }
        return false;
    }

    private String getName() {
        return this.nameTextField.getText().trim();
    }

    private void setName(String s) {
        if (this.userHasChangedName && this.validateName()) {
            return;
        }
        this.nameTextField.setText(s);
        this.nameTextField.setCaretPosition(s.length());
    }

    protected void setSelectedLanguage(LanguageCompilerSpecPair lcsPair) {
        this.selectedLanguage = lcsPair;
        if (this.selectedLanguage == null) {
            this.languageTextField.setText("");
        } else {
            this.languageTextField.setText(this.selectedLanguage.toString());
        }
    }

    private LanguageCompilerSpecPair getPreferredLanguage(Loader loader) {
        LanguageCompilerSpecPair preferredSpecPair = null;
        for (LoadSpec loadSpec : (Collection)this.loaderMap.get(loader)) {
            if (!loadSpec.isPreferred()) continue;
            if (preferredSpecPair != null) {
                return null;
            }
            preferredSpecPair = loadSpec.getLanguageCompilerSpec();
        }
        return preferredSpecPair;
    }

    private DomainFolder getProjectRootFolder() {
        Project project = AppInfo.getActiveProject();
        ProjectData projectData = project.getProjectData();
        return projectData.getRootFolder();
    }

    private void chooseProjectFolder() {
        DataTreeDialog dataTreeDialog = new DataTreeDialog(this.getComponent(), "Choose a project folder", DataTreeDialogType.CHOOSE_FOLDER);
        dataTreeDialog.setSelectedFolder(this.destinationFolder);
        dataTreeDialog.showComponent();
        DomainFolder folder = dataTreeDialog.getDomainFolder();
        if (folder != null) {
            this.setDestinationFolder(folder);
        }
    }

    JComboBox<Loader> getFormatComboBox() {
        return this.loaderComboBox;
    }

    JTextField getLanguageTextField() {
        return this.languageTextField;
    }

    JTextField getNameTextField() {
        return this.nameTextField;
    }
}

