/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import java.io.IOException;
import org.apache.commons.collections4.map.ReferenceMap;

public class FileCacheNameIndex {
    private ReferenceMap<String, String> parentMD5ObjNameToMD5Map = new ReferenceMap();

    public synchronized void clear() {
        this.parentMD5ObjNameToMD5Map.clear();
    }

    public synchronized void add(String parentMD5, String name, String fileMD5) throws IOException {
        if (parentMD5 == null || parentMD5.length() != 32) {
            throw new IOException("Bad MD5 for parent object: " + parentMD5 + ", " + name + ", " + fileMD5);
        }
        if (fileMD5 == null) {
            throw new IOException("Bad fileMD5 value for " + parentMD5 + ", " + name);
        }
        String key = parentMD5 + "_" + name;
        this.parentMD5ObjNameToMD5Map.put((Object)key, (Object)fileMD5);
    }

    public synchronized String get(String parentMD5, String name) throws IOException {
        if (parentMD5 == null || parentMD5.length() != 32) {
            throw new IOException("Bad MD5 for parent object: " + parentMD5 + ", " + name);
        }
        String key = parentMD5 + "_" + name;
        return (String)this.parentMD5ObjNameToMD5Map.get((Object)key);
    }
}

