/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.memsearch.matcher;

import ghidra.features.base.memsearch.bytesequence.ExtendedByteSequence;
import ghidra.features.base.memsearch.gui.SearchSettings;
import ghidra.features.base.memsearch.matcher.ByteMatcher;
import java.util.Iterator;
import java.util.List;

public class CombinedByteMatcher
extends ByteMatcher {
    private List<ByteMatcher> matchers;

    public CombinedByteMatcher(List<ByteMatcher> matchers, SearchSettings settings) {
        super("Multi-Pattern Matcher", null, settings);
        this.matchers = matchers;
    }

    @Override
    public Iterable<ByteMatcher.ByteMatch> match(ExtendedByteSequence bytes) {
        return new MultiMatcherIterator(this, bytes);
    }

    @Override
    public String getDescription() {
        return this.getName();
    }

    @Override
    public String getToolTip() {
        return null;
    }

    private class MultiMatcherIterator
    implements Iterable<ByteMatcher.ByteMatch>,
    Iterator<ByteMatcher.ByteMatch> {
        private Iterator<ByteMatcher> matcherIterator;
        private Iterator<ByteMatcher.ByteMatch> currentMatchIterator;
        private ExtendedByteSequence bytes;

        MultiMatcherIterator(CombinedByteMatcher combinedByteMatcher, ExtendedByteSequence bytes) {
            this.bytes = bytes;
            this.matcherIterator = combinedByteMatcher.matchers.iterator();
            this.currentMatchIterator = this.getNextMatchIterator();
        }

        @Override
        public boolean hasNext() {
            while (this.currentMatchIterator != null && !this.currentMatchIterator.hasNext()) {
                this.currentMatchIterator = this.getNextMatchIterator();
            }
            return this.currentMatchIterator != null;
        }

        private Iterator<ByteMatcher.ByteMatch> getNextMatchIterator() {
            if (this.matcherIterator.hasNext()) {
                ByteMatcher matcher = this.matcherIterator.next();
                return matcher.match(this.bytes).iterator();
            }
            return null;
        }

        @Override
        public ByteMatcher.ByteMatch next() {
            if (this.hasNext()) {
                return this.currentMatchIterator.next();
            }
            return null;
        }

        @Override
        public Iterator<ByteMatcher.ByteMatch> iterator() {
            return this;
        }
    }
}

