/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.util.HashMap;
import java.util.Map;

public class DataOpenCloseManager {
    private Map<Address, int[]> map = new HashMap<Address, int[]>();

    public void openData(Data data) {
        int[] path;
        if (data.getComponent(0) == null) {
            return;
        }
        Address addr = data.getMinAddress();
        if (!this.isDataOpen(addr, path = data.getComponentPath())) {
            this.openData(addr, path);
        }
    }

    public void closeData(Data data) {
        int[] path;
        if (data.getComponent(0) == null) {
            return;
        }
        Address addr = data.getMinAddress();
        if (!this.isDataOpen(addr, path = data.getComponentPath())) {
            return;
        }
        this.close(addr, path);
    }

    private void openData(Address address, int[] path) {
        int pathSize = path.length;
        int[] levels = this.map.get(address);
        if (levels == null || pathSize >= levels.length) {
            this.exactOpenData(address, path);
            return;
        }
        levels[0] = 0;
        for (int i = 0; i < pathSize; ++i) {
            if (levels[i + 1] == path[i]) continue;
            if (levels[i + 1] != -1) {
                this.exactOpenData(address, path);
                return;
            }
            levels[i + 1] = path[i];
        }
        this.map.put(address, levels);
    }

    private void exactOpenData(Address address, int[] path) {
        int pathSize = path.length;
        int[] newLevels = new int[pathSize + 1];
        newLevels[0] = 0;
        System.arraycopy(path, 0, newLevels, 1, pathSize);
        this.map.put(address, newLevels);
    }

    private void close(Address address, int[] path) {
        int[] levels = this.map.get(address);
        if (levels == null) {
            return;
        }
        int levelSize = levels.length;
        int pathSize = 0;
        if (path != null) {
            pathSize = path.length;
        }
        if (levelSize < pathSize + 1) {
            return;
        }
        for (int i = 0; i < pathSize; ++i) {
            if (levels[i + 1] == -1 || levels[i + 1] == path[i]) continue;
            return;
        }
        levels[pathSize] = -1;
        int actualLength = this.computeActualLength(levels);
        if (actualLength == 0) {
            this.map.remove(address);
            return;
        }
        int[] newLevels = levels;
        if (actualLength < levelSize) {
            newLevels = new int[actualLength];
            System.arraycopy(levels, 0, newLevels, 0, actualLength);
        }
        this.map.put(address, newLevels);
    }

    private int computeActualLength(int[] levels) {
        int size = levels.length;
        for (int i = size - 1; i >= 0; --i) {
            if (levels[i] == -1) continue;
            return i + 1;
        }
        return 0;
    }

    public boolean isDataOpen(Address address, int[] path) {
        int[] levels = this.map.get(address);
        if (levels == null) {
            return false;
        }
        if (path == null || path.length == 0) {
            return levels.length > 0 && levels[0] != -1;
        }
        int pathSize = path.length;
        int levelSize = levels.length;
        if (pathSize >= levelSize) {
            return false;
        }
        for (int i = 0; i < pathSize; ++i) {
            if (levels[i + 1] == -1) {
                return false;
            }
            if (levels[i + 1] == path[i]) continue;
            return false;
        }
        return true;
    }

    public int getOpenDataIndex(Address address, int[] path) {
        int[] levels = this.map.get(address);
        if (levels == null || levels.length == 0) {
            return -1;
        }
        int levelsSize = levels.length;
        int pathSize = 0;
        if (path != null) {
            pathSize = path.length;
        }
        if (pathSize + 2 <= levelsSize) {
            return levels[pathSize + 1];
        }
        return -1;
    }

    public void toggleOpen(Data data) {
        this.toggleTopLevelData(data);
    }

    private void toggleTopLevelData(Data data) {
        int[] path;
        if (data.getComponent(0) == null) {
            return;
        }
        Address addr = data.getMinAddress();
        if (this.isDataOpen(addr, path = data.getComponentPath())) {
            this.close(addr, path);
        } else {
            this.openData(addr, path);
        }
    }

    public void openAllData(Program program, AddressSetView addresses, TaskMonitor monitor) {
        this.toggleAllDataInAddresses(true, program, addresses, monitor);
    }

    private void toggleAllDataInAddresses(boolean open, Program program, AddressSetView addresses, TaskMonitor monitor) {
        AddressSet unprocessed = new AddressSet(addresses);
        monitor.initialize(addresses.getNumAddresses());
        Listing listing = program.getListing();
        DataIterator iterator = listing.getDefinedData(addresses, true);
        while (iterator.hasNext()) {
            if (monitor.isCancelled()) {
                return;
            }
            Data data = iterator.next();
            this.toggleDataRecursively(data, open, monitor);
            Address min = data.getMinAddress();
            unprocessed.deleteFromMin(min);
            long progress = addresses.getNumAddresses() - unprocessed.getNumAddresses();
            monitor.setProgress(progress);
        }
    }

    public void closeAllData(Program program, AddressSetView addresses, TaskMonitor monitor) {
        this.toggleAllDataInAddresses(false, program, addresses, monitor);
    }

    public boolean isDataOpen(Data data) {
        return this.isDataOpen(data.getMinAddress(), data.getComponentPath());
    }

    public void toggleDataRecursively(Data data, boolean openState, TaskMonitor monitor) {
        Data component;
        int componentCount;
        if (data == null && !monitor.isCancelled()) {
            return;
        }
        if (this.isDataOpen(data) != openState) {
            this.toggleTopLevelData(data);
        }
        if ((componentCount = data.getNumComponents()) > 0 && data.isArray() && (component = data.getComponent(0)).getNumComponents() == 0) {
            return;
        }
        NoProgressMonitor noProgressMonitor = new NoProgressMonitor(this, monitor);
        for (int i = 0; i < componentCount && !monitor.isCancelled(); ++i) {
            monitor.incrementProgress(1L);
            this.toggleDataRecursivlyUsingSubMonitor(data.getComponent(i), openState, (TaskMonitor)noProgressMonitor);
        }
    }

    private void toggleDataRecursivlyUsingSubMonitor(Data data, boolean openState, TaskMonitor monitor) {
        if (data == null && !monitor.isCancelled()) {
            return;
        }
        if (this.isDataOpen(data) != openState) {
            this.toggleTopLevelData(data);
        }
        int componentCount = data.getNumComponents();
        for (int i = 0; i < componentCount && !monitor.isCancelled(); ++i) {
            this.toggleDataRecursivlyUsingSubMonitor(data.getComponent(i), openState, monitor);
        }
    }

    private class NoProgressMonitor
    extends TaskMonitorAdapter {
        private final TaskMonitor realMonitor;

        NoProgressMonitor(DataOpenCloseManager dataOpenCloseManager, TaskMonitor realMonitor) {
            this.realMonitor = realMonitor;
        }

        public void incrementProgress(long incrementAmount) {
        }

        public void cancel() {
            super.cancel();
            this.realMonitor.cancel();
        }
    }
}

