/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.app.plugin.core.symtable.SymbolTableDragProvider;
import ghidra.app.plugin.core.symtable.dnd.SymbolDataFlavor;
import ghidra.app.plugin.core.symtable.dnd.SymbolTransferData;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.List;

public abstract class SymbolTableDnDAdapter
extends SymbolTableDragProvider
implements DropTargetListener {
    public SymbolTableDnDAdapter(GhidraTable table, RowObjectTableModel<SymbolRowObject> model) {
        super(table, model);
        int actions = 1;
        new DropTarget((Component)((Object)table), actions, this, true);
        Container parent = table.getParent();
        new DropTarget(parent, actions, this, true);
    }

    protected abstract void addSymbols(List<Symbol> var1);

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.dragOver(dtde);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Transferable transferable = dtde.getTransferable();
        if (!transferable.isDataFlavorSupported(SymbolDataFlavor.DATA_FLAVOR)) {
            return;
        }
        try {
            SymbolTransferData symbolData = (SymbolTransferData)transferable.getTransferData(SymbolDataFlavor.DATA_FLAVOR);
            Component source = symbolData.getSource();
            if (source == this.table) {
                dtde.rejectDrag();
                return;
            }
            if (!this.hasSameProgram(symbolData)) {
                dtde.rejectDrag();
                return;
            }
        }
        catch (UnsupportedFlavorException | IOException e) {
            Msg.error((Object)this, (Object)"Unable to perform drop operation", (Throwable)e);
        }
        DataFlavor[] dropFlavors = dtde.getCurrentDataFlavors();
        if (!this.supportsDropFlavor(dropFlavors)) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(dtde.getDropAction());
    }

    private boolean hasSameProgram(SymbolTransferData symbolData) {
        GhidraTable ghidraTable;
        Program myProgram;
        List<Symbol> symbols = symbolData.getSymbols();
        Symbol s = symbols.get(0);
        Program p = s.getProgram();
        return p == (myProgram = (ghidraTable = (GhidraTable)this.table).getProgram());
    }

    private boolean supportsDropFlavor(DataFlavor[] dropFlavors) {
        for (DataFlavor f : dropFlavors) {
            if (!f.equals(SymbolDataFlavor.DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(dtde.getDropAction());
        Transferable transferable = dtde.getTransferable();
        try {
            SymbolTransferData symbolData = (SymbolTransferData)transferable.getTransferData(SymbolDataFlavor.DATA_FLAVOR);
            List<Symbol> symbols = symbolData.getSymbols();
            this.addSymbols(symbols);
        }
        catch (UnsupportedFlavorException | IOException e) {
            Msg.error((Object)this, (Object)"Unable to perform drop operation", (Throwable)e);
        }
        dtde.dropComplete(true);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

