/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import ghidra.app.cmd.label.CreateNamespacesCmd;
import ghidra.app.plugin.core.symboltree.nodes.ClassSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.CodeSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.FunctionSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.LibrarySymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.LocalVariableSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.NamespaceSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.ParameterSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SearchKeySymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import ghidra.app.util.SymbolPath;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class SymbolNode
extends SymbolTreeNode {
    protected final Program program;
    protected final Symbol symbol;
    private String cachedName;
    private boolean isCut;

    SymbolNode(Program program, Symbol symbol) {
        this.program = program;
        this.symbol = symbol;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) {
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        if (this.program.isClosed()) {
            return list;
        }
        SymbolTable symbolTable = this.program.getSymbolTable();
        SymbolIterator iter = symbolTable.getChildren(this.symbol);
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                return Collections.emptyList();
            }
            list.add((GTreeNode)SymbolNode.createNode(iter.next(), this.program));
        }
        this.sort(list);
        return list;
    }

    protected void sort(List<GTreeNode> list) {
        Collections.sort(list, this.getChildrenComparator());
    }

    @Override
    public boolean canCut() {
        return false;
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return false;
    }

    @Override
    public boolean isCut() {
        return this.isCut;
    }

    public boolean isEditable() {
        return true;
    }

    @Override
    public void setNodeCut(boolean isCut) {
        this.isCut = isCut;
        this.fireNodeChanged();
    }

    @Override
    public Symbol getSymbol() {
        return this.symbol;
    }

    public long getSymbolID() {
        return this.symbol.getID();
    }

    public Icon getIcon(boolean expanded) {
        return null;
    }

    public String getName() {
        if (this.cachedName == null) {
            String baseName = this.symbol.getName();
            this.cachedName = this.getNameFromBaseName(baseName);
        }
        return this.cachedName;
    }

    protected String getNameFromBaseName(String baseName) {
        String originalImportedName;
        ExternalLocation external;
        if (this.symbol.isExternal() && (external = this.symbol.getProgram().getExternalManager().getExternalLocation(this.symbol)) != null && (originalImportedName = external.getOriginalImportedName()) != null) {
            return baseName + " / " + originalImportedName;
        }
        return baseName;
    }

    public String toString() {
        return this.getName();
    }

    public String getToolTip() {
        return "<html>" + HTMLUtilities.escapeHTML((String)this.symbol.getName(true));
    }

    public boolean isLeaf() {
        return false;
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        return null;
    }

    @Override
    public boolean supportsDataFlavors(DataFlavor[] dataFlavors) {
        return false;
    }

    @Override
    public Namespace getNamespace() {
        return null;
    }

    @Override
    public GTreeNode findSymbolTreeNode(SymbolNode key, boolean loadChildren, TaskMonitor taskMonitor) {
        Symbol searchSymbol = key.getSymbol();
        if (this.symbol == searchSymbol) {
            return this;
        }
        return super.findSymbolTreeNode(key, loadChildren, taskMonitor);
    }

    public static SymbolNode createKeyNode(Symbol symbol, String searchSymbolName, Program program) {
        SearchKeySymbolNode newNode = new SearchKeySymbolNode(program, symbol, searchSymbolName);
        return newNode;
    }

    public static SymbolNode createNode(Symbol symbol, Program program) {
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType.equals((Object)SymbolType.CLASS)) {
            return new ClassSymbolNode(program, symbol);
        }
        if (symbolType.equals((Object)SymbolType.LABEL)) {
            return new CodeSymbolNode(program, symbol);
        }
        if (symbolType.equals((Object)SymbolType.FUNCTION)) {
            return new FunctionSymbolNode(program, symbol);
        }
        if (symbolType.equals((Object)SymbolType.LIBRARY)) {
            return new LibrarySymbolNode(program, symbol);
        }
        if (symbolType.equals((Object)SymbolType.LOCAL_VAR)) {
            return new LocalVariableSymbolNode(program, symbol);
        }
        if (symbolType.equals((Object)SymbolType.NAMESPACE)) {
            return new NamespaceSymbolNode(program, symbol);
        }
        if (symbolType.equals((Object)SymbolType.PARAMETER)) {
            return new ParameterSymbolNode(program, symbol);
        }
        return new SymbolNode(program, symbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(Object newValue) {
        if (this.symbol.getName().equals(newValue) || this.symbol.getName(true).equals(newValue)) {
            return;
        }
        SymbolPath symbolPath = new SymbolPath((String)newValue);
        String namespacePath = symbolPath.getParentPath();
        if (namespacePath == null) {
            namespacePath = "Global";
        }
        int transactionID = this.program.startTransaction("Rename Symbol");
        try {
            Namespace namespace = this.createNewNamespace(symbolPath.getParent());
            if (!namespace.isGlobal()) {
                this.symbol.setNameAndNamespace(symbolPath.getName(), namespace, SourceType.USER_DEFINED);
            } else {
                this.symbol.setName(symbolPath.getName(), SourceType.USER_DEFINED);
            }
        }
        catch (DuplicateNameException exc) {
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Rename Failed", (Object)("Symbol by the name " + symbolPath.getName() + " already exists in namespace: " + namespacePath + "."));
        }
        catch (InvalidInputException exc) {
            Object msg = exc.getMessage();
            if (msg == null) {
                msg = "Invalid name specified: " + String.valueOf(newValue);
            }
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Invalid Name Specified", (Object)exc.getMessage());
        }
        catch (CircularDependencyException e) {
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Rename Failed", (Object)("Unable to create the symbol \"" + symbolPath.getName() + "\" under namespace " + namespacePath));
        }
        finally {
            this.program.endTransaction(transactionID, true);
        }
    }

    private Namespace createNewNamespace(SymbolPath namespacePath) throws InvalidInputException {
        if (namespacePath == null) {
            return this.program.getGlobalNamespace();
        }
        CreateNamespacesCmd cmd = new CreateNamespacesCmd(namespacePath.getPath(), SourceType.USER_DEFINED);
        if (!cmd.applyTo(this.program)) {
            throw new InvalidInputException(cmd.getStatusMsg());
        }
        return cmd.getNamespace();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SymbolNode node = (SymbolNode)((Object)o);
        if (this.symbol != null) {
            boolean symbolEquals = this.symbol.equals((Object)node.symbol);
            return symbolEquals;
        }
        boolean nameEquals = this.getName().equals(node.getName());
        return nameEquals;
    }

    public int compareTo(GTreeNode node) {
        int nameCompare = this.getName().compareToIgnoreCase(node.getName());
        if (!(node instanceof SymbolNode)) {
            return nameCompare;
        }
        if (nameCompare != 0) {
            return nameCompare;
        }
        nameCompare = this.getName().compareTo(node.getName());
        if (nameCompare != 0) {
            return -nameCompare;
        }
        SymbolNode other = (SymbolNode)node;
        int result = SYMBOL_COMPARATOR.compare(this.symbol, other.symbol);
        return result;
    }
}

