/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.processors;

import docking.ComponentProvider;
import docking.action.ToggleDockingAction;
import docking.action.builder.ToggleActionBuilder;
import generic.theme.Gui;
import ghidra.app.plugin.core.processors.ShowInstructionInfoPlugin;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.OperandType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.util.InstructionUtils;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;
import resources.Icons;

class InstructionInfoProvider
extends ComponentProviderAdapter
implements DomainObjectListener {
    private static final String FONT_ID = "font.plugin.instruction.info";
    private JPanel mainPanel;
    private JSplitPane pane;
    private ShowInstructionInfoPlugin plugin;
    private Program program;
    private JTextArea instructionText;
    private JTable opTable;
    private ToggleDockingAction dynamicUpdateAction;
    private OperandModel operandModel;
    private Address myAddr;

    InstructionInfoProvider(ShowInstructionInfoPlugin plugin, boolean isDynamic) {
        super(plugin.getTool(), "Instruction Info", plugin.getName());
        this.plugin = plugin;
        this.buildMainPanel();
        this.setTransient();
        this.setWindowMenuGroup("Instruction Info");
        this.addToTool();
        this.createActions(isDynamic);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public HelpLocation getHelpLocation() {
        return new HelpLocation(this.plugin.getName(), "Show_Instruction_Info_Window");
    }

    private void createActions(boolean isDynamic) {
        this.dynamicUpdateAction = (ToggleDockingAction)((ToggleActionBuilder)((ToggleActionBuilder)((ToggleActionBuilder)new ToggleActionBuilder("Dynamic Update", this.plugin.getName()).toolBarIcon(Icons.NAVIGATE_ON_INCOMING_EVENT_ICON)).description("Update this panel with navigation")).onAction(ctx -> this.dynamicStateChanged())).selected(isDynamic).buildAndInstallLocal((ComponentProvider)this);
        this.dynamicStateChanged();
    }

    boolean dynamicUpdateSelected() {
        return this.dynamicUpdateAction.isSelected();
    }

    void setStatusText(String msg) {
        this.tool.setStatusInfo(msg);
    }

    void dispose() {
        this.setProgram(null);
        this.removeFromTool();
        this.plugin = null;
        this.tool = null;
    }

    public void componentHidden() {
        this.setProgram(null);
    }

    protected JPanel buildMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.instructionText = new JTextArea();
        Gui.registerFont((Component)this.instructionText, (String)FONT_ID);
        this.instructionText.setEditable(false);
        this.operandModel = new OperandModel();
        this.opTable = new GhidraTable(this.operandModel);
        Gui.registerFont((Component)this.opTable, (String)FONT_ID);
        this.opTable.setPreferredScrollableViewportSize(new Dimension(425, 105));
        this.pane = new JSplitPane(1, new JScrollPane(this.instructionText), new JScrollPane(this.opTable));
        this.pane.setResizeWeight(0.25);
        this.mainPanel.add((Component)this.pane, "Center");
        this.mainPanel.validate();
        return this.mainPanel;
    }

    protected void dynamicStateChanged() {
        this.plugin.dynamicStateChanged(this, this.dynamicUpdateSelected());
    }

    void setAddress(Address address) {
        if (this.program == null) {
            return;
        }
        Instruction instruction = this.getInstruction(address);
        this.myAddr = instruction != null ? instruction.getMinAddress() : address;
        SleighDebugLogger debug = null;
        if (instruction != null) {
            debug = new SleighDebugLogger(instruction.getProgram(), this.myAddr, SleighDebugLogger.SleighDebugMode.MASKS_ONLY);
        }
        this.updateTitle(instruction);
        this.updateInstructionText(instruction, debug);
        this.operandModel.setInstruction(instruction, debug);
    }

    public Instruction getInstruction() {
        return this.operandModel.instruction;
    }

    private Instruction getInstruction(Address address) {
        if (address == null) {
            return null;
        }
        return this.program.getListing().getInstructionContaining(address);
    }

    private void updateTitle(Instruction instruction) {
        String title = this.myAddr != null && instruction != null ? this.getName() + ": Address " + String.valueOf(this.myAddr) : this.getName();
        this.setTitle(title);
    }

    void setProgram(Program program) {
        this.operandModel.setInstruction(null, null);
        if (this.program != null) {
            this.program.removeListener((DomainObjectListener)this);
        }
        this.program = program;
        if (this.program != null) {
            this.program.addListener((DomainObjectListener)this);
        }
        this.setSubTitle((String)(program == null ? "" : "(" + program.getDomainFile().getName() + ")"));
    }

    void show() {
        this.pane.setDividerLocation(0.2);
        this.setVisible(true);
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        this.setAddress(this.myAddr);
    }

    public void setDynamic(boolean dynamic) {
        this.dynamicUpdateAction.setSelected(dynamic);
        this.dynamicStateChanged();
    }

    public Program getProgram() {
        return this.program;
    }

    private void updateInstructionText(Instruction instruction, SleighDebugLogger debug) {
        if (instruction == null) {
            this.instructionText.setText("-- No Instruction --");
            return;
        }
        String details = InstructionUtils.getFormattedInstructionDetails((Instruction)instruction, (SleighDebugLogger)debug);
        this.instructionText.setText(details);
        this.instructionText.setCaretPosition(0);
    }

    private String getString(String[] strs) {
        if (strs == null) {
            return "-none-";
        }
        StringBuffer outStr = new StringBuffer();
        for (String str : strs) {
            if (outStr.length() != 0) {
                outStr.append(", ");
            }
            outStr.append(str.toString());
        }
        return outStr.toString();
    }

    class OperandModel
    extends DefaultTableModel {
        private Instruction instruction;
        private SleighDebugLogger debug;

        OperandModel() {
        }

        public void setInstruction(Instruction instruction, SleighDebugLogger debug) {
            this.instruction = instruction;
            this.debug = debug;
            this.fireTableChanged(null);
        }

        @Override
        public int getColumnCount() {
            return this.instruction != null ? this.instruction.getNumOperands() + 1 : 0;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return "";
            }
            return "Operand-" + (column - 1);
        }

        @Override
        public int getRowCount() {
            return 9;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.instruction == null) {
                return null;
            }
            if (column == 0) {
                return switch (row) {
                    case 0 -> "Operand";
                    case 1 -> "Labeled";
                    case 2 -> "Type";
                    case 3 -> "Scalar";
                    case 4 -> "Address";
                    case 5 -> "Register";
                    case 6 -> "Op-Objects";
                    case 7 -> "Operand Mask";
                    case 8 -> "Masked Value";
                    default -> "";
                };
            }
            int opIndex = column - 1;
            if (opIndex >= this.instruction.getNumOperands()) {
                return "";
            }
            return switch (row) {
                case 0 -> this.instruction.getDefaultOperandRepresentation(opIndex);
                case 1 -> CodeUnitFormat.DEFAULT.getOperandRepresentationList((CodeUnit)this.instruction, opIndex);
                case 2 -> OperandType.toString((int)this.instruction.getOperandType(opIndex));
                case 3 -> this.instruction.getScalar(opIndex);
                case 4 -> {
                    Address addr = this.instruction.getAddress(opIndex);
                    if (addr != null) {
                        yield addr.toString(true);
                    }
                    yield "";
                }
                case 5 -> this.instruction.getRegister(opIndex);
                case 6 -> InstructionInfoProvider.this.getString(InstructionUtils.getFormatedOperandObjects((Instruction)this.instruction, (int)opIndex));
                case 7 -> {
                    if (this.debug != null) {
                        yield this.debug.getFormattedInstructionMask(opIndex);
                    }
                    yield null;
                }
                case 8 -> {
                    if (this.debug != null) {
                        yield this.debug.getFormattedMaskedValue(opIndex);
                    }
                    yield null;
                }
                default -> "";
            };
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }
}

