/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import ghidra.util.LockHold;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;

public class DBSynchronizedIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final ReadWriteLock lock;

    public DBSynchronizedIterator(Iterator<T> iterator, ReadWriteLock lock) {
        this.iterator = iterator;
        this.lock = lock;
    }

    @Override
    public boolean hasNext() {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            boolean bl = this.iterator.hasNext();
            return bl;
        }
    }

    @Override
    public T next() {
        try (LockHold hold = LockHold.lock(this.lock.readLock());){
            T t = this.iterator.next();
            return t;
        }
    }

    @Override
    public void remove() {
        try (LockHold hold = LockHold.lock(this.lock.writeLock());){
            this.iterator.remove();
        }
    }
}

