/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import ghidra.graph.job.AbstractGraphTransitionJob;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.LayoutPositions;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RelayoutFunctionGraphJob<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphTransitionJob<V, E> {
    public RelayoutFunctionGraphJob(GraphViewer<V, E> viewer, boolean useAnimation) {
        super(viewer, useAnimation);
    }

    @Override
    protected void finished() {
        super.finished();
    }

    @Override
    protected void initializeVertexLocations() {
        LayoutPositions futurePositions = this.calculateDefaultLayoutLocations();
        Map destinationLocations = futurePositions.getVertexLocations();
        this.finalEdgeArticulations = futurePositions.getEdgeArticulations();
        Collection vertices = this.graph.getVertices();
        for (VisualVertex vertex : vertices) {
            Point2D currentPoint = this.toLocation(vertex);
            Point2D startPoint = (Point2D)currentPoint.clone();
            Point2D vertexPoint = destinationLocations.get(vertex);
            Point2D destinationPoint = (Point2D)vertexPoint.clone();
            AbstractGraphTransitionJob.TransitionPoints transitionPoints = new AbstractGraphTransitionJob.TransitionPoints(this, startPoint, destinationPoint);
            this.vertexLocations.put(vertex, transitionPoints);
        }
        Map edgeArticulations = futurePositions.getEdgeArticulations();
        Set entrySet = edgeArticulations.entrySet();
        for (Map.Entry entry : entrySet) {
            VisualEdge edge = (VisualEdge)entry.getKey();
            List<Point2D> currentArticulations = edge.getArticulationPoints();
            List<Point2D> newArticulations = entry.getValue();
            List<AbstractGraphTransitionJob.ArticulationTransitionPoints> transitionPoints = this.getArticulationTransitionPoints(currentArticulations, newArticulations, destinationLocations, edge);
            this.edgeArticulationLocations.put(edge, transitionPoints);
        }
    }

    private List<AbstractGraphTransitionJob.ArticulationTransitionPoints> getArticulationTransitionPoints(List<Point2D> currentArticulations, List<Point2D> newArticulations, Map<V, Point2D> destinationLocations, E edge) {
        if (currentArticulations.size() > newArticulations.size()) {
            return this.getArticulationTransitionPointsWhenStartingWithMorePoints(currentArticulations, newArticulations, destinationLocations, edge);
        }
        return this.getArticulationTransitionPointsWhenStartingWithLessPoints(currentArticulations, newArticulations, destinationLocations, edge);
    }

    private List<AbstractGraphTransitionJob.ArticulationTransitionPoints> getArticulationTransitionPointsWhenStartingWithLessPoints(List<Point2D> currentArticulations, List<Point2D> newArticulations, Map<V, Point2D> destinationLocations, E edge) {
        ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints> transitionPoints = new ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints>();
        ArrayList<Point2D> newStartArticulationsPoints = new ArrayList<Point2D>();
        Point2D lastValidStartPoint = this.toLocation((VisualVertex)edge.getStart());
        for (int i = 0; i < newArticulations.size(); ++i) {
            Point2D endPoint = newArticulations.get(i);
            Point2D startPoint = (Point2D)lastValidStartPoint.clone();
            if (i < currentArticulations.size()) {
                lastValidStartPoint = startPoint = currentArticulations.get(i);
            }
            transitionPoints.add(new AbstractGraphTransitionJob.ArticulationTransitionPoints(this, startPoint, endPoint));
            newStartArticulationsPoints.add(startPoint);
        }
        edge.setArticulationPoints(newStartArticulationsPoints);
        return transitionPoints;
    }

    private List<AbstractGraphTransitionJob.ArticulationTransitionPoints> getArticulationTransitionPointsWhenStartingWithMorePoints(List<Point2D> currentArticulations, List<Point2D> newArticulations, Map<V, Point2D> destinationLocations, E edge) {
        ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints> transitionPoints = new ArrayList<AbstractGraphTransitionJob.ArticulationTransitionPoints>();
        for (int i = 0; i < currentArticulations.size(); ++i) {
            Point2D startPoint = currentArticulations.get(i);
            Point2D endPoint = (Point2D)startPoint.clone();
            if (i < newArticulations.size()) {
                endPoint = newArticulations.get(i);
            }
            transitionPoints.add(new AbstractGraphTransitionJob.ArticulationTransitionPoints(this, startPoint, endPoint));
        }
        return transitionPoints;
    }
}

