/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dmg;

import ghidra.file.formats.ios.dmg.DmgConstants;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import java.util.Arrays;

public final class DmgUtil {
    public static final boolean isDMG(Program program) {
        Address address;
        if (program != null && (address = program.getMinAddress()) != null) {
            byte[] bytes = new byte[8];
            try {
                program.getMemory().getBytes(address, bytes);
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
            return Arrays.equals(bytes, DmgConstants.DMG_MAGIC_BYTES_v1) || Arrays.equals(bytes, DmgConstants.DMG_MAGIC_BYTES_v2);
        }
        return false;
    }
}

