/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.util.concurrent.CompletableFuture;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.EiglspergerLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.EiglspergerRunnable;
import org.jungrapht.visualization.layout.algorithms.eiglsperger.ExtendedEiglspergerRunnable;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedEiglspergerLayoutAlgorithm<V, E>
extends EiglspergerLayoutAlgorithm<V, E>
implements LayoutAlgorithm<V> {
    private static final Logger log = LoggerFactory.getLogger(ExtendedEiglspergerLayoutAlgorithm.class);
    private static final Shape IDENTITY_SHAPE = new Ellipse2D.Double();
    boolean doUpLeft;
    boolean doDownLeft;
    boolean doUpRight;
    boolean doDownRight;

    public static <V, E> Builder<V, E, ?, ?> edgeAwareBuilder() {
        return new Builder();
    }

    public ExtendedEiglspergerLayoutAlgorithm() {
        this(ExtendedEiglspergerLayoutAlgorithm.edgeAwareBuilder());
    }

    protected ExtendedEiglspergerLayoutAlgorithm(Builder builder) {
        super(builder);
        this.doUpLeft = builder.doUpLeft;
        this.doUpRight = builder.doUpRight;
        this.doDownLeft = builder.doDownLeft;
        this.doDownRight = builder.doDownRight;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        EiglspergerRunnable runnable = ((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)((ExtendedEiglspergerRunnable.Builder)ExtendedEiglspergerRunnable.builder().layoutModel(layoutModel)).vertexShapeFunction(this.vertexBoundsFunction)).straightenEdges(this.straightenEdges)).transpose(this.transpose)).postStraighten(this.postStraighten)).maxLevelCross(this.maxLevelCross)).layering(this.layering)).edgeComparator(this.edgeComparator)).doUpLeft(this.doUpLeft)).doUpRight(this.doUpRight)).doDownLeft(this.doDownLeft)).doDownRight(this.doDownRight)).build();
        if (this.threaded) {
            CompletableFuture.runAsync(runnable).thenRun(() -> this.lambda$visit$0((ExtendedEiglspergerRunnable)runnable, layoutModel));
        } else {
            ((ExtendedEiglspergerRunnable)runnable).run();
            this.edgePointMap.putAll(runnable.getEdgePointMap());
            this.after.run();
            layoutModel.getViewChangeSupport().fireViewChanged();
            layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, false);
        }
    }

    private /* synthetic */ void lambda$visit$0(ExtendedEiglspergerRunnable runnable, LayoutModel layoutModel) {
        log.trace("Eiglsperger layout done");
        this.edgePointMap.putAll(runnable.getEdgePointMap());
        this.runAfter();
        layoutModel.getViewChangeSupport().fireViewChanged();
        layoutModel.getLayoutStateChangeSupport().fireLayoutStateChanged(layoutModel, false);
    }

    public static class Builder<V, E, T extends ExtendedEiglspergerLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    extends EiglspergerLayoutAlgorithm.Builder<V, E, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        boolean doUpLeft = false;
        boolean doDownLeft = false;
        boolean doUpRight = false;
        boolean doDownRight = false;

        public B doUpLeft(boolean doUpLeft) {
            this.doUpLeft = doUpLeft;
            return (B)((Builder)this.self());
        }

        public B doUpRight(boolean doUpRight) {
            this.doUpRight = doUpRight;
            return (B)((Builder)this.self());
        }

        public B doDownLeft(boolean doDownLeft) {
            this.doDownLeft = doDownLeft;
            return (B)((Builder)this.self());
        }

        public B doDownRight(boolean doDownRight) {
            this.doDownRight = doDownRight;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new ExtendedEiglspergerLayoutAlgorithm(this);
        }
    }
}

