/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.fileset;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupsCommand;
import ghidra.app.util.bin.format.macho.commands.FileSetEntryCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.file.formats.ios.ExtractedMacho;
import ghidra.file.formats.ios.fileset.MachoFileSetEntry;
import ghidra.file.formats.ios.fileset.MachoFileSetExtractor;
import ghidra.file.formats.ios.fileset.MachoFileSetFileSystemFactory;
import ghidra.formats.gfilesystem.AbstractFileSystem;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.fileinfo.FileAttributeType;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="machofileset", description="Mach-O file set", factory=MachoFileSetFileSystemFactory.class)
public class MachoFileSetFileSystem
extends AbstractFileSystem<MachoFileSetEntry> {
    public static final String MACHO_FILESET_FSTYPE = "machofileset";
    private ByteProvider provider;
    private ByteProvider fixedUpProvider;
    private MachHeader header;
    private Map<MachoFileSetEntry, List<SegmentCommand>> entrySegmentMap;

    public MachoFileSetFileSystem(FSRLRoot fsFSRL, ByteProvider provider) {
        super(fsFSRL, FileSystemService.getInstance());
        this.provider = provider;
        this.entrySegmentMap = new HashMap<MachoFileSetEntry, List<SegmentCommand>>();
    }

    public void mount(TaskMonitor monitor) throws IOException, CancelledException {
        MessageLog log = new MessageLog();
        try {
            SegmentCommand branchGots;
            MachoFileSetEntry entry;
            monitor.setMessage("Opening Mach-O file set...");
            this.header = new MachHeader(this.provider).parse();
            SegmentCommand textSegment = this.header.getSegment("__TEXT");
            if (textSegment == null) {
                throw new MachException("__TEXT not found!");
            }
            for (FileSetEntryCommand cmd : this.header.getLoadCommands(FileSetEntryCommand.class)) {
                entry = new MachoFileSetEntry(cmd.getFileSetEntryId().getString(), cmd.getFileOffset(), false);
                this.fsIndex.storeFile(entry.id(), (long)this.fsIndex.getFileCount(), false, -1L, (Object)entry);
                this.entrySegmentMap.put(entry, new MachHeader(this.provider, entry.offset()).parseSegments());
            }
            SegmentCommand branchStubs = this.header.getSegment("__BRANCH_STUBS");
            if (branchStubs != null) {
                MachoFileSetEntry entry2 = new MachoFileSetEntry("__BRANCH_STUBS".substring(2), 0L, true);
                this.fsIndex.storeFile(entry2.id(), (long)this.fsIndex.getFileCount(), false, -1L, (Object)entry2);
                this.entrySegmentMap.put(entry2, List.of(branchStubs));
            }
            if ((branchGots = this.header.getSegment("__BRANCH_GOTS")) != null) {
                entry = new MachoFileSetEntry("__BRANCH_GOTS".substring(2), 0L, true);
                this.fsIndex.storeFile(entry.id(), (long)this.fsIndex.getFileCount(), false, -1L, (Object)entry);
                this.entrySegmentMap.put(entry, List.of(branchGots));
            }
            monitor.setMessage("Getting chained pointers...");
            BinaryReader reader = new BinaryReader(this.provider, this.header.isLittleEndian());
            ArrayList fixups = new ArrayList();
            long imagebase = textSegment.getVMaddress();
            for (DyldChainedFixupsCommand loadCommand : this.header.getLoadCommands(DyldChainedFixupsCommand.class)) {
                fixups.addAll(loadCommand.getChainedFixups(reader, imagebase, null, log, monitor));
            }
            monitor.initialize((long)fixups.size(), "Fixing chained pointers...");
            byte[] bytes = this.provider.readBytes(0L, this.provider.length());
            for (DyldFixup fixup : fixups) {
                byte[] newBytes = ExtractedMacho.toBytes(fixup.value(), fixup.size());
                System.arraycopy(newBytes, 0, bytes, (int)fixup.offset(), newBytes.length);
            }
            this.fixedUpProvider = new ByteArrayProvider(bytes);
        }
        catch (MachException e) {
            throw new IOException(e);
        }
    }

    public ByteProvider getByteProvider(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        MachoFileSetEntry entry = (MachoFileSetEntry)this.fsIndex.getMetadata(file);
        if (entry == null) {
            return null;
        }
        try {
            if (entry.isBranchSegment()) {
                return MachoFileSetExtractor.extractSegment(this.fixedUpProvider, this.header.getSegment("__" + entry.id()), file.getFSRL(), monitor);
            }
            return MachoFileSetExtractor.extractFileSetEntry(this.fixedUpProvider, entry.offset(), file.getFSRL(), monitor);
        }
        catch (MachException e) {
            throw new IOException("Invalid Mach-O header detected at 0x%x".formatted(entry.offset()));
        }
    }

    public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        FileAttributes result = new FileAttributes();
        MachoFileSetEntry entry = (MachoFileSetEntry)this.fsIndex.getMetadata(file);
        if (entry != null) {
            result.add(FileAttributeType.NAME_ATTR, (Object)entry.id());
            result.add(FileAttributeType.PATH_ATTR, (Object)entry.id());
        }
        return result;
    }

    public ByteProvider getMachoFileSetProvider() {
        return this.provider;
    }

    public Map<MachoFileSetEntry, List<SegmentCommand>> getEntrySegmentMap() {
        return this.entrySegmentMap;
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        if (this.fixedUpProvider != null) {
            this.fixedUpProvider.close();
            this.fixedUpProvider = null;
        }
        if (this.header != null) {
            this.header = null;
        }
        this.fsIndex.clear();
        this.entrySegmentMap.clear();
    }
}

