/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import docking.widgets.OptionDialog;
import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb.ApplyDataTypes;
import ghidra.app.util.bin.format.pdb.ApplyEnums;
import ghidra.app.util.bin.format.pdb.ApplyFunctions;
import ghidra.app.util.bin.format.pdb.ApplyTables;
import ghidra.app.util.bin.format.pdb.ApplyTypeDefs;
import ghidra.app.util.bin.format.pdb.DefaultPdbMember;
import ghidra.app.util.bin.format.pdb.PdbDataTypeParser;
import ghidra.app.util.bin.format.pdb.PdbErrorHandler;
import ghidra.app.util.bin.format.pdb.PdbErrorReaderThread;
import ghidra.app.util.bin.format.pdb.PdbException;
import ghidra.app.util.bin.format.pdb.PdbKind;
import ghidra.app.util.bin.format.pdb.PdbMember;
import ghidra.app.util.bin.format.pdb.WrappedDataType;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.pdb.PdbProgramAttributes;
import ghidra.framework.Application;
import ghidra.framework.OSFileNotFoundException;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import ghidra.xml.XmlTreeNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class PdbParser {
    private static final String PDB_EXE = "pdb.exe";
    private static final String README_FILENAME = String.valueOf(Application.getInstallationDirectory()) + "\\docs\\README_PDB.html";
    static final String STRUCTURE_KIND = "Structure";
    static final String UNION_KIND = "Union";
    public static final boolean onWindows = Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS;
    private TaskMonitor monitor;
    private final boolean forceAnalysis;
    private final File pdbFile;
    private final boolean isXML;
    private final Program program;
    private DataTypeManager dataMgr;
    private final DataTypeManagerService service;
    private final PdbProgramAttributes programAttributes;
    private Process process;
    private XmlPullParser parser;
    private PdbErrorHandler errHandler;
    private PdbErrorReaderThread thread;
    private boolean parsed = false;
    private boolean allowNonExactMatch;
    private CategoryPath pdbCategory;
    private PdbDataTypeParser dataTypeParser;
    private Map<SymbolPath, Boolean> namespaceMap = new TreeMap<SymbolPath, Boolean>();

    public PdbParser(File pdbFile, Program program, DataTypeManagerService service, boolean forceAnalysis, boolean allowNonExactMatch, TaskMonitor monitor) {
        this(pdbFile, program, service, PdbParser.getPdbAttributes(program), forceAnalysis, allowNonExactMatch, monitor);
    }

    public PdbParser(File pdbFile, Program program, DataTypeManagerService service, PdbProgramAttributes programAttributes, boolean forceAnalysis, boolean allowNonExactMatch, TaskMonitor monitor) {
        this.pdbFile = pdbFile;
        this.pdbCategory = new CategoryPath(CategoryPath.ROOT, new String[]{pdbFile.getName()});
        this.program = program;
        this.dataMgr = program.getDataTypeManager();
        this.service = service;
        this.forceAnalysis = forceAnalysis;
        this.monitor = monitor != null ? monitor : TaskMonitor.DUMMY;
        this.isXML = pdbFile.getName().toLowerCase().endsWith(PdbFileType.XML.toString());
        this.programAttributes = programAttributes;
        this.allowNonExactMatch = allowNonExactMatch;
    }

    DataTypeManager getProgramDataTypeManager() {
        return this.dataMgr;
    }

    Program getProgram() {
        return this.program;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse() throws IOException, PdbException {
        this.checkPdbLoaded();
        this.checkFileType();
        this.checkOSCompatibility();
        if (!this.forceAnalysis && !this.programAttributes.isProgramAnalyzed()) {
            throw new PdbException("Before loading a PDB, you must first analyze the program.");
        }
        this.processPdbContents(false);
        if (!this.isXML) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.hasErrors()) {
                throw new PdbException(this.getErrorAndWarningMessages());
            }
            if (this.hasWarnings()) {
                if (SystemUtilities.isInHeadlessMode()) {
                    throw new PdbException(this.getErrorAndWarningMessages() + "..  Skipping PDB processing.");
                }
                int option = OptionDialog.showYesNoDialog(null, (String)"Continue Loading PDB?", (String)(this.getErrorAndWarningMessages() + "\n \nContinue anyway?\n \nPlease note: Invalid disassembly may be produced!"));
                if (option != 1) throw new PdbException(this.getErrorAndWarningMessages());
                this.cleanup();
                this.processPdbContents(true);
            }
        } else {
            this.verifyPdbSignature();
        }
        this.parsed = true;
    }

    private void checkFileType() throws PdbException {
        String pdbFilename = this.pdbFile.getName().toLowerCase();
        if (!pdbFilename.endsWith(PdbFileType.PDB.toString()) && !pdbFilename.endsWith(PdbFileType.XML.toString())) {
            throw new PdbException("\nInvalid file type (expecting .pdb or .pdb.xml): '" + this.pdbFile.getName() + "'");
        }
    }

    private void checkOSCompatibility() throws PdbException {
        if (!this.isXML && !onWindows) {
            throw new PdbException("\n.pdb files may only be loaded when running Windows. To load PDBs\non other platforms, use Windows to pre-dump the .pdb file to .pdb.xml\nusing 'CreatePdbXmlFilesScript.java' or 'createPdbXmlFiles.bat'.");
        }
        if (onWindows && this.isXML) {
            Msg.warn((Object)this, (Object)("Could not find .pdb file in the classpath or the given Symbol Repository Directory. Using " + this.pdbFile.getAbsolutePath() + ", instead."));
        }
    }

    private void checkPdbLoaded() throws PdbException {
        if (this.isPdbLoaded()) {
            throw new PdbException("PDB file has already been loaded.");
        }
    }

    private boolean hasErrors() {
        return this.thread != null && this.thread.hasErrors();
    }

    private boolean hasWarnings() {
        return this.thread != null && this.thread.hasWarnings();
    }

    private String getErrorAndWarningMessages() {
        return this.thread == null ? "" : this.thread.getErrorAndWarningMessages();
    }

    public void openDataTypeArchives() throws IOException, DuplicateIdException {
        if (this.program != null) {
            List archiveList = DataTypeArchiveUtility.getArchiveList((Program)this.program);
            for (String string : archiveList) {
                this.service.openDataTypeArchive(string);
            }
        }
    }

    private String[] getCommandLineArray(boolean noValidation) throws PdbException {
        String pdbExe = null;
        try {
            File pdbExeFile = Application.getOSFile((String)PDB_EXE);
            pdbExe = pdbExeFile.getAbsolutePath();
        }
        catch (OSFileNotFoundException e) {
            throw new PdbException(e.getMessage());
        }
        if (noValidation) {
            return new String[]{pdbExe, this.pdbFile.getAbsolutePath()};
        }
        String pdbAge = this.programAttributes.getPdbAge();
        String pdbGuid = this.programAttributes.getPdbGuid();
        String pdbSignature = this.programAttributes.getPdbSignature();
        if (pdbAge != null && pdbGuid != null) {
            return new String[]{pdbExe, this.pdbFile.getAbsolutePath(), pdbGuid, pdbAge};
        }
        if (pdbAge != null && pdbSignature != null) {
            return new String[]{pdbExe, this.pdbFile.getAbsolutePath(), pdbSignature, pdbAge};
        }
        throw new PdbException("Unable to determine PDB GUID/Signature or Age. Please re-import the executable and try again.");
    }

    private void completeDefferedTypeParsing(ApplyDataTypes applyDataTypes, ApplyTypeDefs applyTypeDefs, MessageLog log) throws CancelledException {
        this.defineClasses(log);
        if (applyDataTypes != null) {
            applyDataTypes.buildDataTypes(this.monitor);
        }
        if (applyTypeDefs != null) {
            applyTypeDefs.buildTypeDefs(this.monitor);
        }
        if (this.dataTypeParser != null) {
            this.dataTypeParser.flushDataTypeCache();
        }
    }

    public void applyTo(MessageLog log) throws IOException, PdbException, CancelledException {
        if (!this.parsed) {
            throw new IOException("PDB: parse() must be called before applyTo()");
        }
        this.checkPdbLoaded();
        this.errHandler.setMessageLog(log);
        Msg.debug((Object)this, (Object)("Found PDB for " + this.program.getName() + ": " + String.valueOf(this.pdbFile)));
        try {
            ApplyDataTypes applyDataTypes = null;
            ApplyTypeDefs applyTypeDefs = null;
            boolean typesFlushed = false;
            while (this.parser.hasNext()) {
                if (this.hasErrors()) {
                    throw new IOException(this.getErrorAndWarningMessages());
                }
                this.monitor.checkCancelled();
                XmlElement element = this.parser.next();
                if (!element.isStart() || element.getName().equals("pdb")) continue;
                if (element.getName().equals("enums")) {
                    ApplyEnums.applyTo(this.parser, this, this.monitor, log);
                    continue;
                }
                if (element.getName().equals("datatypes")) {
                    if (applyDataTypes == null) {
                        applyDataTypes = new ApplyDataTypes(this, log);
                    }
                    applyDataTypes.preProcessDataTypeList(this.parser, false, this.monitor);
                    continue;
                }
                if (element.getName().equals("classes")) {
                    if (applyDataTypes == null) {
                        applyDataTypes = new ApplyDataTypes(this, log);
                    }
                    applyDataTypes.preProcessDataTypeList(this.parser, true, this.monitor);
                    continue;
                }
                if (element.getName().equals("typedefs")) {
                    applyTypeDefs = new ApplyTypeDefs(this, this.parser, this.monitor, log);
                    continue;
                }
                if (element.getName().equals("functions")) {
                    if (!typesFlushed) {
                        this.completeDefferedTypeParsing(applyDataTypes, applyTypeDefs, log);
                        typesFlushed = true;
                    }
                    ApplyFunctions.applyTo(this, this.parser, this.monitor, log);
                    continue;
                }
                if (!element.getName().equals("tables")) continue;
                if (!typesFlushed) {
                    this.completeDefferedTypeParsing(applyDataTypes, applyTypeDefs, log);
                    typesFlushed = true;
                }
                ApplyTables.applyTo(this, this.parser, this.monitor, log);
            }
            if (!typesFlushed) {
                this.completeDefferedTypeParsing(applyDataTypes, applyTypeDefs, log);
            }
            Options options = this.program.getOptions("Program Information");
            options.setBoolean("PDB Loaded", true);
            if (this.dataTypeParser != null && this.dataTypeParser.hasMissingBitOffsetError()) {
                log.appendMsg("PDB", "One or more bitfields were specified without bit-offset data.\nThe use of old pdb.xml data could be the cause.");
            }
        }
        catch (CancelledException e) {
            throw e;
        }
        catch (Exception e) {
            Object message = e.getMessage();
            if (message == null) {
                message = e.getClass().getSimpleName();
            }
            message = "Problem parsing or applying PDB information: " + (String)message;
            Msg.error((Object)this, (Object)message, (Throwable)e);
            throw new IOException((String)message, e);
        }
        finally {
            this.cleanup();
        }
        if (this.hasErrors()) {
            throw new IOException(this.getErrorAndWarningMessages());
        }
    }

    void predefineClass(String classname) {
        SymbolPath classPath = new SymbolPath(classname);
        this.namespaceMap.put(classPath, true);
        for (SymbolPath path = classPath.getParent(); path != null; path = path.getParent()) {
            if (this.namespaceMap.containsKey(path)) continue;
            this.namespaceMap.put(path, false);
        }
    }

    private void defineClasses(MessageLog log) throws CancelledException {
        this.monitor.setMessage("Define classes...");
        this.monitor.initialize((long)this.namespaceMap.size());
        for (SymbolPath path : this.namespaceMap.keySet()) {
            this.monitor.checkCancelled();
            boolean isClass = this.namespaceMap.get(path);
            Namespace parentNamespace = NamespaceUtils.getNonFunctionNamespace((Program)this.program, (SymbolPath)path.getParent());
            if (parentNamespace == null) {
                String type = isClass ? "class" : "namespace";
                log.appendMsg("PDB", "Failed to define " + type + ": " + String.valueOf(path));
                continue;
            }
            this.defineNamespace(parentNamespace, path.getName(), isClass, log);
            this.monitor.incrementProgress(1L);
        }
        this.monitor.initialize(100L);
    }

    private void defineNamespace(Namespace parentNamespace, String name, boolean isClass, MessageLog log) {
        try {
            SymbolTable symbolTable = this.program.getSymbolTable();
            Namespace namespace = symbolTable.getNamespace(name, parentNamespace);
            if (namespace != null) {
                if (isClass) {
                    if (namespace instanceof GhidraClass) {
                        return;
                    }
                    if (this.isSimpleNamespaceSymbol(namespace)) {
                        NamespaceUtils.convertNamespaceToClass((Namespace)namespace);
                        return;
                    }
                } else if (namespace.getSymbol().getSymbolType() == SymbolType.NAMESPACE) {
                    return;
                }
                log.appendMsg("PDB", "Unable to create class namespace due to conflicting symbol: " + namespace.getName(true));
            } else if (isClass) {
                symbolTable.createClass(parentNamespace, name, SourceType.IMPORTED);
            } else {
                symbolTable.createNameSpace(parentNamespace, name, SourceType.IMPORTED);
            }
        }
        catch (Exception e) {
            log.appendMsg("PDB", "Unable to create class namespace: " + parentNamespace.getName(true) + "::" + name);
        }
    }

    private boolean isSimpleNamespaceSymbol(Namespace namespace) {
        Symbol s = namespace.getSymbol();
        if (s.getSymbolType() != SymbolType.NAMESPACE) {
            return false;
        }
        for (Namespace n = namespace; n != null; n = n.getParentNamespace()) {
            if (!(n instanceof Function)) continue;
            return false;
        }
        return true;
    }

    private void processPdbContents(boolean skipValidation) throws PdbException, IOException {
        InputStream in = null;
        if (!this.isXML) {
            String[] cmd = this.getCommandLineArray(skipValidation);
            Runtime runtime = Runtime.getRuntime();
            try {
                this.process = runtime.exec(cmd);
            }
            catch (IOException e) {
                if (e.getMessage().endsWith("14001")) {
                    throw new PdbException("Missing runtime libraries. Please refer to " + README_FILENAME + " and follow instructions.");
                }
                throw e;
            }
            in = this.process.getInputStream();
            InputStream err = this.process.getErrorStream();
            this.thread = new PdbErrorReaderThread(err);
            this.thread.start();
        } else {
            in = new FileInputStream(this.pdbFile);
        }
        this.errHandler = new PdbErrorHandler();
        try {
            this.parser = XmlPullParserFactory.create((InputStream)in, (String)this.pdbFile.getName(), (ErrorHandler)this.errHandler, (boolean)false);
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void verifyPdbSignature() throws IOException, PdbException {
        String pdbSignature;
        XmlElement xmlelem;
        try {
            xmlelem = this.parser.peek();
        }
        catch (Exception e) {
            if (!this.isXML) {
                if (this.hasErrors()) {
                    throw new PdbException(this.getErrorAndWarningMessages());
                }
                throw new PdbException("PDB Execution failure of pdb.exe.\nThis was likely caused by severe execution failure which can occur if executed\non an unsupported platform. It may be necessary to rebuild the PDB executable\nfor your platform (see Ghidra/Features/PDB/src).");
            }
            throw new PdbException("PDB parsing problem: " + e.getMessage());
        }
        if (!"pdb".equals(xmlelem.getName())) {
            throw new PdbException("Unexpected PDB XML element: " + xmlelem.getName());
        }
        String xmlGuid = xmlelem.getAttribute("guid");
        String xmlAge = xmlelem.getAttribute("age");
        Object warning = "";
        Object pdbGuid = this.programAttributes.getPdbGuid();
        if (pdbGuid == null && (pdbSignature = this.programAttributes.getPdbSignature()) != null) {
            pdbGuid = this.reformatSignatureToGuidForm(pdbSignature);
        }
        String pdbAge = this.programAttributes.getPdbAge();
        if (xmlGuid == null || pdbGuid == null) {
            if (xmlGuid == null) {
                warning = (String)warning + "No GUID was listed in the XML file.";
            }
            if (pdbGuid == null) {
                warning = (String)warning + " Could not find a PDB GUID for the binary.";
            }
            warning = (String)warning + " Could not complete verification of matching PDB signatures.";
        } else {
            pdbGuid = ((String)pdbGuid).toUpperCase();
            pdbGuid = "{" + (String)pdbGuid + "}";
            if (!this.allowNonExactMatch) {
                if (!xmlGuid.equals(pdbGuid)) {
                    warning = "PDB signature does not match.\nProgram GUID: " + (String)pdbGuid + "\nXML GUID: " + xmlGuid;
                } else if (xmlAge != null && pdbAge != null) {
                    int pdbAgeDecimal = Integer.parseInt(pdbAge, 16);
                    int xmlAgeDecimal = Integer.parseInt(xmlAge);
                    if (xmlAgeDecimal != pdbAgeDecimal) {
                        warning = "PDB ages do not match.";
                    }
                }
            }
        }
        if (((String)warning).length() > 0) {
            if (SystemUtilities.isInHeadlessMode()) {
                throw new PdbException((String)warning + ".. Skipping PDB processing.");
            }
            int option = OptionDialog.showYesNoDialog(null, (String)"Continue Loading PDB?", (String)((String)warning + "\n \nContinue anyway?\n \nPlease note: Invalid disassembly may be produced!"));
            if (option != 1) {
                throw new PdbException((String)warning);
            }
        }
    }

    private String reformatSignatureToGuidForm(String pdbSignature) {
        if (pdbSignature.length() > 32) {
            pdbSignature = pdbSignature.substring(0, 32);
        }
        StringBuilder builder = new StringBuilder(pdbSignature);
        for (int i = pdbSignature.length(); i < 32; ++i) {
            builder = builder.append('0');
        }
        builder = builder.insert(8, '-').insert(13, '-').insert(18, '-').insert(23, '-');
        return builder.toString();
    }

    public boolean isPdbLoaded() {
        return this.programAttributes.isPdbLoaded();
    }

    private void cleanup() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        if (this.parser != null) {
            this.parser.dispose();
            this.parser = null;
        }
        if (this.dataTypeParser != null) {
            this.dataTypeParser.clear();
        }
    }

    boolean isCorrectKind(DataType dt, PdbKind kind) {
        if (kind == PdbKind.STRUCTURE) {
            return dt instanceof Structure;
        }
        if (kind == PdbKind.UNION) {
            return dt instanceof Union;
        }
        return false;
    }

    Composite createComposite(PdbKind kind, String name) {
        if (kind == PdbKind.STRUCTURE) {
            return this.createStructure(name, 0);
        }
        if (kind == PdbKind.UNION) {
            return this.createUnion(name);
        }
        throw new IllegalArgumentException("unsupported kind: " + String.valueOf((Object)kind));
    }

    Structure createStructure(String name, int length) {
        SymbolPath path = new SymbolPath(name);
        return new StructureDataType(this.getCategory(path.getParent(), true), path.getName(), length, this.dataMgr);
    }

    Union createUnion(String name) {
        SymbolPath path = new SymbolPath(name);
        return new UnionDataType(this.getCategory(path.getParent(), true), path.getName(), this.dataMgr);
    }

    TypedefDataType createTypeDef(String name, DataType baseDataType) {
        SymbolPath path = new SymbolPath(name);
        return new TypedefDataType(this.getCategory(path.getParent(), true), path.getName(), baseDataType, this.dataMgr);
    }

    EnumDataType createEnum(String name, int length) {
        SymbolPath path = new SymbolPath(name);
        length = Integer.max(length, 1);
        return new EnumDataType(this.getCategory(path.getParent(), true), path.getName(), length, this.dataMgr);
    }

    void createString(boolean isUnicode, Address address, MessageLog log) {
        UnicodeDataType dataType = isUnicode ? new UnicodeDataType() : new StringDataType();
        this.createData(address, (DataType)dataType, log);
    }

    void createData(Address address, String datatype, MessageLog log) throws CancelledException {
        WrappedDataType wrappedDt = this.getDataTypeParser().findDataType(datatype);
        if (wrappedDt == null) {
            log.appendMsg("PDB", "Failed to resolve datatype " + datatype + " at " + String.valueOf(address));
        } else if (wrappedDt.isZeroLengthArray()) {
            Msg.debug((Object)this, (Object)("Did not apply zero length array data " + datatype + " at " + String.valueOf(address)));
        } else {
            this.createData(address, wrappedDt.getDataType(), log);
        }
    }

    void createData(Address address, DataType dataType, MessageLog log) {
        DumbMemBufferImpl memBuffer = new DumbMemBufferImpl(this.program.getMemory(), address);
        DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)dataType, (MemBuffer)memBuffer, (boolean)false);
        if (dti == null) {
            log.appendMsg("PDB", "Failed to apply datatype " + dataType.getName() + " at " + String.valueOf(address));
        } else {
            this.createData(address, dti.getDataType(), dti.getLength(), log);
        }
    }

    private void createData(Address address, DataType dataType, int dataTypeLength, MessageLog log) {
        block18: {
            Data existingData = null;
            CodeUnit cu = this.program.getListing().getCodeUnitContaining(address);
            if (cu != null) {
                if (cu instanceof Instruction || !address.equals((Object)cu.getAddress())) {
                    log.appendMsg("PDB", "Did not create data type \"" + dataType.getDisplayName() + "\" at address " + String.valueOf(address) + " due to conflict");
                    return;
                }
                Data d = (Data)cu;
                if (d.isDefined()) {
                    existingData = d;
                }
            }
            if (dataType == null) {
                return;
            }
            if (dataType.getLength() <= 0 && dataTypeLength <= 0) {
                log.appendMsg("PDB", "Unknown dataTypeLength specified at address " + String.valueOf(address) + " for " + dataType.getName());
                return;
            }
            if (existingData != null) {
                DataType existingDataType = existingData.getDataType();
                if (this.isEquivalent(existingData, existingData.getLength(), dataType)) {
                    return;
                }
                if (this.isEquivalent2(existingDataType, dataType)) {
                    return;
                }
                if (existingDataType.isEquivalent(dataType)) {
                    return;
                }
            }
            Listing listing = this.program.getListing();
            if (existingData == null) {
                try {
                    listing.clearCodeUnits(address, address.add((long)(dataTypeLength - 1)), false);
                    if (dataType.getLength() == -1) {
                        listing.createData(address, dataType, dataTypeLength);
                        break block18;
                    }
                    listing.createData(address, dataType);
                }
                catch (Exception e) {
                    log.appendMsg("PDB", "Unable to create " + dataType.getDisplayName() + " at 0x" + String.valueOf(address) + ": " + e.getMessage());
                }
            } else if (this.isDataReplaceable(existingData)) {
                try {
                    listing.clearCodeUnits(address, address.add((long)(dataTypeLength - 1)), false);
                    listing.createData(address, dataType, dataTypeLength);
                }
                catch (Exception e) {
                    log.appendMsg("PDB", "Unable to replace " + dataType.getDisplayName() + " at 0x" + String.valueOf(address) + ": " + e.getMessage());
                }
            } else {
                DataType existingDataType = existingData.getDataType();
                String existingDataTypeString = existingDataType == null ? "null" : existingDataType.getDisplayName();
                log.appendMsg("PDB", "Did not create data type \"" + dataType.getDisplayName() + "\" at address " + String.valueOf(address) + ".  Preferring existing datatype \"" + existingDataTypeString + "\"");
            }
        }
    }

    private boolean isDataReplaceable(Data data) {
        Array array;
        DataType arrayDataType;
        Pointer pointer;
        DataType pointerDataType;
        DataType dataType = data.getDataType();
        if (dataType instanceof Pointer ? (pointerDataType = (pointer = (Pointer)dataType).getDataType()) == null || pointerDataType.isEquivalent(DataType.DEFAULT) : dataType instanceof Array && ((arrayDataType = (array = (Array)dataType).getDataType()) == null || arrayDataType.isEquivalent(DataType.DEFAULT))) {
            return true;
        }
        return Undefined.isUndefined((DataType)dataType);
    }

    private boolean isEquivalent(Data existingData, int existingDataTypeLength, DataType newDataType) {
        Array array;
        DataType arrayDataType;
        return existingData.hasStringValue() && newDataType instanceof ArrayDataType && (arrayDataType = (array = (Array)newDataType).getDataType()) instanceof ArrayStringable && array.getLength() == existingDataTypeLength;
    }

    private boolean isEquivalent2(DataType datatype1, DataType datatype2) {
        if (datatype1 == datatype2) {
            return true;
        }
        if (datatype1 == null || datatype2 == null) {
            return false;
        }
        if (datatype1 instanceof Array) {
            Array array1 = (Array)datatype1;
            if (datatype2 instanceof Array) {
                Array array2 = (Array)datatype2;
                return this.isEquivalent2(array1.getDataType(), array2.getDataType());
            }
        } else if (datatype1 instanceof Pointer) {
            Pointer pointer1 = (Pointer)datatype1;
            if (datatype2 instanceof Array) {
                Array array2 = (Array)datatype2;
                return this.isEquivalent2(pointer1.getDataType(), array2.getDataType());
            }
        }
        return datatype1.isEquivalent(datatype2);
    }

    boolean createSymbol(Address address, String symbolPathString, boolean forcePrimary, MessageLog log) {
        try {
            Symbol s;
            Namespace namespace = this.program.getGlobalNamespace();
            SymbolPath symbolPath = new SymbolPath(symbolPathString);
            symbolPath = symbolPath.replaceInvalidChars();
            String name = symbolPath.getName();
            String namespacePath = symbolPath.getParentPath();
            if (namespacePath != null) {
                namespace = NamespaceUtils.createNamespaceHierarchy((String)namespacePath, (Namespace)namespace, (Program)this.program, (Address)address, (SourceType)SourceType.IMPORTED);
            }
            if ((s = SymbolUtilities.createPreferredLabelOrFunctionSymbol((Program)this.program, (Address)address, (Namespace)namespace, (String)name, (SourceType)SourceType.IMPORTED)) != null && forcePrimary) {
                SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(address, s.getName(), s.getParentNamespace());
                cmd.applyTo(this.program);
            }
            return true;
        }
        catch (InvalidInputException e) {
            log.appendMsg("PDB", "Unable to create symbol at " + String.valueOf(address) + ": " + e.getMessage());
            return false;
        }
    }

    CategoryPath getCategory() {
        return this.pdbCategory;
    }

    String stripNamespace(String name) {
        int index = name.lastIndexOf("::");
        if (index <= 0) {
            return name;
        }
        return name.substring(index + "::".length());
    }

    CategoryPath getCategory(String namespaceQualifiedDataTypeName, boolean addPdbRoot) {
        CategoryPath category;
        String[] names = namespaceQualifiedDataTypeName.split("::");
        CategoryPath categoryPath = category = addPdbRoot ? this.pdbCategory : CategoryPath.ROOT;
        if (names.length > 1) {
            String[] categoryNames = new String[names.length - 1];
            System.arraycopy(names, 0, categoryNames, 0, categoryNames.length);
            for (String c : categoryNames) {
                category = new CategoryPath(category, new String[]{c});
            }
        }
        return category;
    }

    CategoryPath getCategory(SymbolPath symbolPath, boolean addPdbRoot) {
        CategoryPath category;
        CategoryPath categoryPath = category = addPdbRoot ? this.pdbCategory : CategoryPath.ROOT;
        if (symbolPath != null) {
            List names = symbolPath.asList();
            for (String name : names) {
                category = new CategoryPath(category, new String[]{name});
            }
        }
        return category;
    }

    public static PdbProgramAttributes getPdbAttributes(Program program) {
        return new PdbProgramAttributes(program);
    }

    public static boolean isAlreadyLoaded(Program program) {
        return PdbParser.getPdbAttributes(program).isPdbLoaded();
    }

    PdbDataTypeParser getDataTypeParser() {
        if (this.program == null) {
            throw new AssertException("Parser was not constructed with program");
        }
        if (this.dataTypeParser == null) {
            this.dataTypeParser = new PdbDataTypeParser((DataTypeManager)this.program.getDataTypeManager(), this.service, this.monitor);
        }
        return this.dataTypeParser;
    }

    void cacheDataType(String name, DataType dataType) {
        this.getDataTypeParser().cacheDataType(name, dataType);
    }

    DataType getCachedDataType(String name) {
        return this.getDataTypeParser().getCachedDataType(name);
    }

    WrappedDataType findDataType(String dataTypeName) throws CancelledException {
        return this.getDataTypeParser().findDataType(dataTypeName);
    }

    public PdbMember getPdbXmlMember(XmlTreeNode node) {
        return new PdbXmlMember(this, node);
    }

    public PdbXmlMember getPdbXmlMember(XmlElement element) {
        return new PdbXmlMember(this, element);
    }

    public static enum PdbFileType {
        PDB,
        XML;


        public String toString() {
            return "." + this.name().toLowerCase();
        }
    }

    class PdbXmlMember
    extends DefaultPdbMember {
        PdbXmlMember(PdbParser this$0, XmlTreeNode node) {
            this(this$0, node.getStartElement());
        }

        PdbXmlMember(PdbParser this$0, XmlElement element) {
            super(SymbolUtilities.replaceInvalidChars((String)element.getAttribute("name"), (boolean)false), SymbolUtilities.replaceInvalidChars((String)element.getAttribute("datatype"), (boolean)false), XmlUtilities.parseInt((String)element.getAttribute("offset")), PdbKind.parse(element.getAttribute("kind")), this$0.getDataTypeParser());
        }
    }
}

