/*
 * Decompiled with CFR 0.152.
 */
package generic.util.action;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.JPasswordField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class DeleteToStartOfWordAction
extends TextAction {
    public static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(8, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
    private static final String ACTION_NAME = "delete-to-start-of-word";

    public DeleteToStartOfWordAction() {
        super(ACTION_NAME);
    }

    private void error(Component component) {
        UIManager.getLookAndFeel().provideErrorFeedback(component);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JTextComponent textComponent = this.getTextComponent(e);
        if (textComponent == null || !textComponent.isEditable()) {
            this.error(textComponent);
            return;
        }
        try {
            Document document = textComponent.getDocument();
            Caret caret = textComponent.getCaret();
            int caretIndex = caret.getDot();
            int markIndex = caret.getMark();
            int selectionStartIndex = Math.min(caretIndex, markIndex);
            int selectionEndIndex = Math.max(caretIndex, markIndex);
            int wordStartIndex = this.getStartOfWordIndex(textComponent, selectionStartIndex);
            if (wordStartIndex != selectionEndIndex) {
                document.remove(wordStartIndex, selectionEndIndex - wordStartIndex);
            } else if (caretIndex > 0) {
                this.error(textComponent);
            }
        }
        catch (BadLocationException ble) {
            this.error(textComponent);
        }
    }

    private int getStartOfWordIndex(JTextComponent textComponent, int offset) throws BadLocationException {
        boolean isInPreviousParagraph;
        if (textComponent instanceof JPasswordField) {
            return 0;
        }
        Element currentParagraph = Utilities.getParagraphElement(textComponent, offset);
        int previousWordOffset = Utilities.getPreviousWord(textComponent, offset);
        boolean bl = isInPreviousParagraph = previousWordOffset < currentParagraph.getStartOffset();
        if (isInPreviousParagraph) {
            Element previousParagraphElement = Utilities.getParagraphElement(textComponent, previousWordOffset);
            return previousParagraphElement.getEndOffset() - 1;
        }
        return previousWordOffset;
    }
}

