/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.tasks;

import generic.stl.Pair;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.Option;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadResults;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loaded;
import ghidra.app.util.opinion.Loader;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectDataUtils;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.plugins.importer.batch.BatchGroup;
import ghidra.plugins.importer.batch.BatchGroupLoadSpec;
import ghidra.plugins.importer.batch.BatchInfo;
import ghidra.program.model.listing.Program;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

public class ImportBatchTask
extends Task {
    public static final int MAX_PROGRAMS_TO_OPEN = 50;
    private BatchInfo batchInfo;
    private DomainFolder destFolder;
    private boolean stripLeadingPath = true;
    private boolean stripAllContainerPath = false;
    private boolean mirrorFs = false;
    private ProgramManager programManager;
    private int totalObjsImported;
    private int totalAppsImported;
    private int totalEnabledApps;

    public ImportBatchTask(BatchInfo batchInfo, DomainFolder destFolder, ProgramManager programManager, boolean stripLeading, boolean stripAllContainerPath, boolean mirrorFs) {
        super("Batch Import Task", true, true, false, false);
        this.batchInfo = batchInfo;
        this.destFolder = destFolder;
        this.totalEnabledApps = batchInfo.getEnabledCount();
        this.programManager = programManager;
        this.stripLeadingPath = stripLeading;
        this.stripAllContainerPath = stripAllContainerPath;
        this.mirrorFs = mirrorFs;
    }

    public void run(TaskMonitor monitor) {
        try {
            this.doBatchImport(monitor);
        }
        catch (CancelledException e) {
            Msg.debug((Object)((Object)this), (Object)"Batch import cancelled");
        }
        catch (IOException ce) {
            Msg.error((Object)((Object)this), (Object)"Error during batch import: ", (Throwable)ce);
        }
        finally {
            Msg.showInfo((Object)((Object)this), null, (String)"Batch Import Summary", (Object)("Batch Import finished.\nImported " + this.totalObjsImported + " files."));
        }
    }

    private void doBatchImport(TaskMonitor monitor) throws CancelledException, IOException {
        Msg.info((Object)((Object)this), (Object)("Starting batch import of " + this.totalEnabledApps + " programs into " + String.valueOf(this.destFolder)));
        for (BatchGroup batchGroup : this.batchInfo.getGroups()) {
            if (!batchGroup.isEnabled()) continue;
            if (monitor.isCancelled()) {
                Msg.info((Object)((Object)this), (Object)"Stopping batch import due to cancel");
                break;
            }
            this.doImportBatchGroup(batchGroup, monitor);
        }
    }

    private void doImportBatchGroup(BatchGroup batchGroup, TaskMonitor monitor) throws CancelledException, IOException {
        BatchGroupLoadSpec selectedBatchGroupLoadSpec = batchGroup.getSelectedBatchGroupLoadSpec();
        for (BatchGroup.BatchLoadConfig loadConfig : batchGroup.getBatchLoadConfig()) {
            if (monitor.isCancelled()) {
                return;
            }
            this.doImportApp(loadConfig, selectedBatchGroupLoadSpec, monitor);
        }
    }

    private void doImportApp(BatchGroup.BatchLoadConfig batchLoadConfig, BatchGroupLoadSpec selectedBatchGroupLoadSpec, TaskMonitor monitor) throws CancelledException, IOException {
        Msg.info((Object)((Object)this), (Object)("Importing " + String.valueOf(batchLoadConfig.getFSRL())));
        try (ByteProvider byteProvider = FileSystemService.getInstance().getByteProvider(batchLoadConfig.getFSRL(), true, monitor);){
            LoadSpec loadSpec = batchLoadConfig.getLoadSpec(selectedBatchGroupLoadSpec);
            if (loadSpec == null) {
                Msg.error((Object)((Object)this), (Object)("Failed to get load spec from application that matches chosen batch load spec " + String.valueOf(selectedBatchGroupLoadSpec)));
                return;
            }
            Pair<DomainFolder, String> destInfo = this.getDestinationInfo(batchLoadConfig, this.destFolder);
            try {
                MessageLog messageLog = new MessageLog();
                Project project = AppInfo.getActiveProject();
                Loader.ImporterSettings settings = new Loader.ImporterSettings(byteProvider, this.fixupProjectFilename((String)destInfo.second), project, ((DomainFolder)destInfo.first).getPathname(), this.mirrorFs, loadSpec, this.getOptionsFor(batchLoadConfig, loadSpec, byteProvider), (Object)this, messageLog, monitor);
                try (LoadResults<? extends DomainObject> loadResults = loadSpec.getLoader().load(settings);){
                    if (loadResults != null) {
                        loadResults.save(monitor);
                        this.processImportResults(loadResults, batchLoadConfig, monitor);
                    }
                }
                ++this.totalAppsImported;
                Msg.info((Object)((Object)this), (Object)("Imported " + String.valueOf(destInfo.first) + "/ " + (String)destInfo.second + ", " + this.totalAppsImported + " of " + this.totalEnabledApps));
                if (!Loader.loggingDisabled && messageLog.hasMessages()) {
                    Msg.info((Object)((Object)this), (Object)("Additional info:\n" + messageLog.toString()));
                }
            }
            catch (CancelledException e) {
                Msg.debug((Object)((Object)this), (Object)"Batch Import cancelled");
            }
            catch (InvalidNameException | VersionException | IOException | IllegalArgumentException e) {
                Msg.error((Object)((Object)this), (Object)("Import failed for " + batchLoadConfig.getPreferredFileName()), (Throwable)e);
            }
        }
    }

    private String fixupProjectFilename(String filename) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filename.length(); ++i) {
            char ch = filename.charAt(i);
            sb.append(LocalFileSystem.isValidNameCharacter((char)ch) ? ch : (char)'_');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processImportResults(LoadResults<? extends DomainObject> loadResults, BatchGroup.BatchLoadConfig appInfo, TaskMonitor monitor) {
        for (Loaded<? extends DomainObject> loaded : loadResults) {
            DomainObject obj = loaded.getDomainObject((Object)this);
            try {
                if (obj instanceof Program) {
                    Program program = (Program)obj;
                    if (this.programManager != null && this.totalObjsImported < 50) {
                        this.programManager.openProgram(program, this.totalObjsImported == 0 ? 1 : 2);
                    }
                }
            }
            finally {
                obj.release((Object)this);
            }
            ++this.totalObjsImported;
        }
    }

    static String fsrlToPath(FSRL fsrl, FSRL userSrc, boolean stripLeadingPath, boolean stripInteriorContainerPath) {
        String fullPath = fsrl.toPrettyFullpathString().replace('|', '/');
        String userSrcPath = userSrc.toPrettyFullpathString().replace('|', '/');
        int filename = fullPath.lastIndexOf(47) + 1;
        int uas = userSrcPath.length();
        int leadStart = !stripLeadingPath ? 0 : userSrcPath.lastIndexOf(47) + 1;
        int leadEnd = Math.min(filename, userSrcPath.length());
        String leading = leadStart < filename ? fullPath.substring(leadStart, leadEnd) : "";
        String containerPath = uas < filename && !stripInteriorContainerPath ? fullPath.substring(uas, filename) : "";
        String filenameStr = fullPath.substring(filename);
        String result = FSUtilities.appendPath(leading, containerPath, filenameStr);
        return result;
    }

    private Pair<DomainFolder, String> getDestinationInfo(BatchGroup.BatchLoadConfig batchLoadConfig, DomainFolder rootDestinationFolder) {
        String parentDir;
        FSRL fsrl = batchLoadConfig.getFSRL();
        if (this.mirrorFs) {
            FSRL containerFSRL = fsrl.getFS().getContainer();
            String path = containerFSRL != null ? containerFSRL.toPrettyFullpathString() : "/";
            path = path.replace('|', '/');
            try {
                DomainFolder batchDestFolder = ProjectDataUtils.createDomainFolderPath((DomainFolder)rootDestinationFolder, (String)(this.stripLeadingPath ? "" : path));
                return new Pair((Object)batchDestFolder, (Object)fsrl.getName());
            }
            catch (InvalidNameException | IOException e) {
                Msg.error((Object)((Object)this), (Object)("Problem creating project folder root: " + rootDestinationFolder.getPathname() + ", subpath: " + path), (Throwable)e);
                return new Pair((Object)rootDestinationFolder, (Object)fsrl.getName());
            }
        }
        String pathStr = ImportBatchTask.fsrlToPath(fsrl, batchLoadConfig.getUasi().getFSRL(), this.stripLeadingPath, this.stripAllContainerPath);
        String preferredName = batchLoadConfig.getPreferredFileName();
        String fsrlFilename = fsrl.getName();
        if (!fsrlFilename.equals(preferredName)) {
            pathStr = FSUtilities.appendPath(pathStr, preferredName);
        }
        if ((parentDir = FilenameUtils.getFullPathNoEndSeparator((String)(pathStr = pathStr.replaceAll("[\\\\:|]+", "/")))) == null) {
            parentDir = "";
        }
        String destFilename = FilenameUtils.getName((String)pathStr);
        try {
            DomainFolder batchDestFolder = ProjectDataUtils.createDomainFolderPath((DomainFolder)rootDestinationFolder, (String)parentDir);
            return new Pair((Object)batchDestFolder, (Object)destFilename);
        }
        catch (InvalidNameException | IOException e) {
            Msg.error((Object)((Object)this), (Object)("Problem creating project folder root: " + rootDestinationFolder.getPathname() + ", subpath: " + parentDir), (Throwable)e);
            return new Pair((Object)rootDestinationFolder, (Object)fsrlFilename);
        }
    }

    private List<Option> getOptionsFor(BatchGroup.BatchLoadConfig batchLoadConfig, LoadSpec loadSpec, ByteProvider byteProvider) {
        List<Option> options = batchLoadConfig.getLoader().getDefaultOptions(byteProvider, loadSpec, null, false, false);
        return options;
    }
}

