/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.som;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class SomPltEntry
implements StructConverter {
    public static final int SIZE = 8;
    private int procAddr;
    private int ltptrValue;

    public SomPltEntry(BinaryReader reader) throws IOException {
        this.procAddr = reader.readNextInt();
        this.ltptrValue = reader.readNextInt();
    }

    public int getProcAddr() {
        return this.procAddr;
    }

    public int getLtptrValue() {
        return this.ltptrValue;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("PLT_entry", 8);
        struct.setPackingEnabled(true);
        struct.add(POINTER, "poc_addr", "address of procedure");
        struct.add(DWORD, "ltptr_value", "value of r19 required for this procedure");
        struct.setCategoryPath(new CategoryPath("/SOM"));
        return struct;
    }
}

