/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.attribs;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFForm;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;

public class DWARFAttributeDef<E extends Enum<E>> {
    protected final E attributeId;
    protected final DWARFForm attributeForm;
    protected final int rawAttributeId;
    protected final long implicitValue;

    public static <E extends Enum<E>> DWARFAttributeDef<E> read(BinaryReader reader, Function<Integer, E> mapper) throws IOException {
        int attributeId = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        int formId = reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        if (attributeId == 0 && formId == 0) {
            return null;
        }
        DWARFForm form = DWARFForm.of(formId);
        if (form == null) {
            throw new IOException("Unknown DWARFForm %d (0x%x)".formatted(formId, formId));
        }
        Enum e = (Enum)mapper.apply(attributeId);
        long implicitValue = form == DWARFForm.DW_FORM_implicit_const ? reader.readNext(LEB128::signed) : 0L;
        return new DWARFAttributeDef<Enum>(e, attributeId, form, implicitValue);
    }

    public DWARFAttributeDef(E attributeId, int rawAttributeId, DWARFForm attributeForm, long implicitValue) {
        this.attributeId = attributeId;
        this.rawAttributeId = rawAttributeId;
        this.attributeForm = attributeForm;
        this.implicitValue = implicitValue;
    }

    public E getAttributeId() {
        return this.attributeId;
    }

    public int getRawAttributeId() {
        return this.rawAttributeId;
    }

    public String getAttributeName() {
        return this.attributeId != null ? ((Enum)this.attributeId).name() : this.getRawAttributeIdDescription();
    }

    protected String getRawAttributeIdDescription() {
        return "unknown attribute id %d (0x%x)".formatted(this.rawAttributeId, this.rawAttributeId);
    }

    public DWARFForm getAttributeForm() {
        return this.attributeForm;
    }

    public boolean isImplicit() {
        return this.attributeForm == DWARFForm.DW_FORM_implicit_const;
    }

    public long getImplicitValue() {
        return this.implicitValue;
    }

    public DWARFAttributeDef<E> withForm(DWARFForm newForm) {
        return new DWARFAttributeDef<E>(this.attributeId, this.rawAttributeId, newForm, this.implicitValue);
    }

    public String toString() {
        return this.getAttributeName() + "->" + String.valueOf((Object)this.getAttributeForm());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.attributeForm, this.attributeId, this.implicitValue, this.rawAttributeId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DWARFAttributeDef)) {
            return false;
        }
        DWARFAttributeDef other = (DWARFAttributeDef)obj;
        return this.attributeForm == other.attributeForm && Objects.equals(this.attributeId, other.attributeId) && this.implicitValue == other.implicitValue && this.rawAttributeId == other.rawAttributeId;
    }
}

