/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.ImportsCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeRootNode;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class CreateLibraryAction
extends SymbolTreeContextAction {
    public CreateLibraryAction(SymbolTreePlugin plugin) {
        super("Create Library", plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"Create Library"}, "0External"));
        this.setEnabled(false);
    }

    @Override
    public boolean isEnabledForContext(SymbolTreeActionContext context) {
        Object object;
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        return selectionPaths.length == 1 && ((object = selectionPaths[0].getLastPathComponent()) instanceof ImportsCategoryNode || object instanceof SymbolTreeRootNode);
    }

    @Override
    public void actionPerformed(SymbolTreeActionContext context) {
        GTree tree = (GTree)context.getContextObject();
        if (tree.isFiltered()) {
            Msg.showWarn(((Object)((Object)this)).getClass(), (Component)tree, (String)"Create Library Not Allowed", (Object)"Cannot create library name while the tree is filtered!");
            return;
        }
        this.createExternalLibrary(context);
    }

    private void createExternalLibrary(SymbolTreeActionContext context) {
        String newExternalLibraryName;
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        Program program = context.getProgram();
        Namespace parent = program.getGlobalNamespace();
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (node instanceof SymbolTreeRootNode) {
            node = node.getChild("Imports");
        }
        if ((newExternalLibraryName = this.createExternalLibrary(program, parent)) == null) {
            return;
        }
        program.flushEvents();
        context.getSymbolTree().startEditing(node, newExternalLibraryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String createExternalLibrary(Program program, Namespace parent) {
        Object importName = "NewLibrary";
        int transactionID = program.startTransaction("Create Library");
        try {
            SymbolTable symbolTable = program.getSymbolTable();
            int oneUp = 0;
            importName = "NewLibrary";
            Library namespace = null;
            while (namespace == null) {
                try {
                    namespace = symbolTable.createExternalLibrary((String)importName, SourceType.USER_DEFINED);
                }
                catch (DuplicateNameException e) {
                    importName = "NewLibrary(" + ++oneUp + ")";
                }
                catch (InvalidInputException e) {
                    Msg.debug((Object)((Object)this), (Object)("Failed to create library name: " + e.getMessage()));
                    String string = null;
                    program.endTransaction(transactionID, true);
                    return string;
                    return importName;
                }
            }
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }
}

