/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.decompile;

import docking.action.MenuData;
import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.features.codecompare.decompile.AbstractMatchedTokensAction;
import ghidra.features.codecompare.decompile.DecompilerCodeComparisonView;
import ghidra.features.codecompare.decompile.DualDecompilerActionContext;
import ghidra.features.codecompare.decompile.TokenPair;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.symbol.CodeSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighCodeSymbol;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.datastruct.Duo;
import java.awt.Component;

public class ApplyGlobalNameFromMatchedTokensAction
extends AbstractMatchedTokensAction {
    private PluginTool tool;
    public static final String ACTION_NAME = "Function Comparison Apply Global Variable Name";
    private static final String MENU_GROUP = "A1_ApplyVariable";

    public ApplyGlobalNameFromMatchedTokensAction(DecompilerCodeComparisonView comparisonProvider, PluginTool tool) {
        super(ACTION_NAME, tool.getName(), comparisonProvider, true);
        this.tool = tool;
        MenuData menuData = new MenuData(new String[]{"Apply From Other Function", "Variable Name"}, null, MENU_GROUP);
        this.setPopupMenuData(menuData);
        this.setHelpLocation(new HelpLocation("FunctionComparison", this.getName()));
    }

    @Override
    protected boolean isEnabledForDualDecompilerContext(DualDecompilerActionContext context) {
        ClangVariableToken leftVar;
        ClangToken clangToken;
        block7: {
            block6: {
                TokenPair tokenPair = context.getTokenPair();
                if (tokenPair == null) {
                    return false;
                }
                if (tokenPair.leftToken() == null || tokenPair.rightToken() == null) {
                    return false;
                }
                clangToken = tokenPair.leftToken();
                if (!(clangToken instanceof ClangVariableToken)) break block6;
                leftVar = (ClangVariableToken)clangToken;
                clangToken = tokenPair.rightToken();
                if (clangToken instanceof ClangVariableToken) break block7;
            }
            return false;
        }
        ClangVariableToken rightVar = (ClangVariableToken)clangToken;
        HighSymbol leftSymbol = leftVar.getHighSymbol(context.getHighFunction(Duo.Side.LEFT));
        HighSymbol rightSymbol = rightVar.getHighSymbol(context.getHighFunction(Duo.Side.RIGHT));
        if (leftSymbol == null || rightSymbol == null) {
            return false;
        }
        return leftSymbol.isGlobal() && rightSymbol.isGlobal();
    }

    @Override
    public void dualDecompilerActionPerformed(DualDecompilerActionContext context) {
        HighCodeSymbol activeCodeSymbol;
        TokenPair currentPair = context.getTokenPair();
        Duo.Side activeSide = this.comparisonProvider.getActiveSide();
        ClangVariableToken activeToken = activeSide == Duo.Side.LEFT ? (ClangVariableToken)currentPair.leftToken() : (ClangVariableToken)currentPair.rightToken();
        ClangVariableToken otherToken = activeSide == Duo.Side.LEFT ? (ClangVariableToken)currentPair.rightToken() : (ClangVariableToken)currentPair.leftToken();
        HighSymbol activeHighSymbol = activeToken.getHighSymbol(context.getHighFunction(activeSide));
        HighSymbol otherHighSymbol = otherToken.getHighSymbol(context.getHighFunction(activeSide.otherSide()));
        Program activeProgram = context.getCodeComparisonView().getProgram(activeSide);
        CodeSymbol activeSymbol = null;
        if (activeHighSymbol instanceof HighCodeSymbol && (activeSymbol = (activeCodeSymbol = (HighCodeSymbol)activeHighSymbol).getCodeSymbol()) == null) {
            Address addr = activeCodeSymbol.getStorage().getMinAddress();
            SymbolTable symbolTable = activeProgram.getSymbolTable();
            activeSymbol = symbolTable.getPrimarySymbol(addr);
        }
        if (activeSymbol == null) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Name transfer failed", (Object)"Failed to find memory storage for target global");
            return;
        }
        RenameLabelCmd cmd = new RenameLabelCmd((Symbol)activeSymbol, otherHighSymbol.getName(), otherHighSymbol.getNamespace(), SourceType.IMPORTED);
        activeProgram.withTransaction("Code Comparison Apply Global Variable Name", () -> cmd.applyTo(activeProgram));
        if (!cmd.getStatusMsg().isEmpty()) {
            Msg.showError((Object)((Object)this), (Component)this.tool.getToolFrame(), (String)"Name transfer failed", (Object)cmd.getStatusMsg());
        }
    }
}

