/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.db;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.feature.fid.db.StringRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.util.UniversalIdGenerator;
import java.io.IOException;

public class StringsTable {
    static final String STRINGS_TABLE = "Strings Table";
    static final int STRING_VALUE_COL = 0;
    static final int CACHE_SIZE = 10000;
    static final Schema SCHEMA = new Schema(6, "String ID", new Field[]{StringField.INSTANCE}, new String[]{"String Value"});
    static int[] INDEXED_COLUMNS = new int[]{0};
    Table table;
    DBObjectCache<StringRecord> stringCache;

    public StringsTable(DBHandle handle) throws IOException {
        this.table = handle.getTable(STRINGS_TABLE);
        this.stringCache = new DBObjectCache(10000);
    }

    public static void createTable(DBHandle handle) throws IOException {
        handle.createTable(STRINGS_TABLE, SCHEMA, INDEXED_COLUMNS);
    }

    long obtainStringID(String value) throws IOException {
        Field[] records = this.table.findRecords((Field)new StringField(value), 0);
        if (records == null || records.length == 0) {
            long key = UniversalIdGenerator.nextID().getValue();
            DBRecord record = SCHEMA.createRecord(key);
            record.setString(0, value);
            this.table.putRecord(record);
            return key;
        }
        return records[0].getLongValue();
    }

    Long lookupStringID(String value) throws IOException {
        Field[] records = this.table.findRecords((Field)new StringField(value), 0);
        if (records == null || records.length == 0) {
            return null;
        }
        return records[0].getLongValue();
    }

    StringRecord lookupString(long stringID) {
        StringRecord stringRecord = (StringRecord)this.stringCache.get(stringID);
        if (stringRecord == null) {
            try {
                DBRecord record = this.table.getRecord(stringID);
                if (record != null) {
                    stringRecord = new StringRecord(this.stringCache, stringID, record.getString(0));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("serious delayed database access error", e);
            }
        }
        return stringRecord;
    }
}

