/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.sort;

import docking.widgets.table.DynamicColumnTableModel;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableComparators;
import ghidra.docking.settings.Settings;
import ghidra.util.table.column.GColumnRenderer;
import java.util.Comparator;

public class ColumnRenderedValueBackupComparator<T>
implements Comparator<Object> {
    protected int sortColumn;
    protected DynamicColumnTableModel<T> model;
    private boolean supportsColumnSorting = true;

    public ColumnRenderedValueBackupComparator(DynamicColumnTableModel<T> model, int sortColumn) {
        this.model = model;
        this.sortColumn = sortColumn;
        DynamicTableColumn<T, ?, ?> column = model.getColumn(sortColumn);
        GColumnRenderer<?> renderer = column.getColumnRenderer();
        if (renderer != null && renderer.getColumnConstraintFilterMode() == GColumnRenderer.ColumnConstraintFilterMode.ALLOW_CONSTRAINTS_FILTER_ONLY) {
            this.supportsColumnSorting = false;
        }
    }

    @Override
    public int compare(Object c1, Object c2) {
        if (c1 == c2) {
            return 0;
        }
        String s1 = this.getRenderedColumnStringValue(c1);
        String s2 = this.getRenderedColumnStringValue(c2);
        if (s1 == null || s2 == null) {
            return TableComparators.compareWithNullValues(s1, s2);
        }
        return s1.compareToIgnoreCase(s2);
    }

    private String getRenderedColumnStringValue(Object columnValue) {
        if (!this.supportsColumnSorting) {
            return null;
        }
        DynamicTableColumn<T, ?, ?> column = this.model.getColumn(this.sortColumn);
        GColumnRenderer<?> renderer = column.getColumnRenderer();
        if (renderer == null) {
            return columnValue == null ? null : columnValue.toString();
        }
        Settings settings = this.model.getColumnSettings(this.sortColumn);
        return renderer.getFilterString(columnValue, settings);
    }

    protected Object getColumnValue(T t) {
        return this.model.getColumnValueForRow(t, this.sortColumn);
    }
}

