/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import docking.DockingUtils;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import ghidra.graph.viewer.options.VisualGraphOptions;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class VisualGraphScrollWheelPanningPlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphMousePlugin
implements MouseWheelListener,
VisualGraphMousePlugin<V, E> {
    public VisualGraphScrollWheelPanningPlugin() {
        super(0);
    }

    public boolean checkModifiers(MouseEvent e) {
        return e.getModifiersEx() == this.modifiers;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.isScrollModifiers(e)) {
            return;
        }
        this.pan(e);
    }

    private void pan(MouseWheelEvent e) {
        GraphViewer viewer = this.getGraphViewer(e);
        int scrollAmount = 1;
        if (e.getScrollType() == 0) {
            scrollAmount = e.getScrollAmount();
        }
        int wheelRotation = -e.getWheelRotation();
        int arbitraryAcceleration = 10;
        Double scale = GraphViewerUtils.getGraphScale(viewer);
        int unscaledOffset = wheelRotation * scrollAmount * arbitraryAcceleration;
        int offset = (int)((double)unscaledOffset * (1.0 / scale));
        Point newPoint = new Point(0, offset);
        if (e.isAltDown()) {
            newPoint.setLocation(offset, 0);
        }
        VisualGraphViewUpdater updater = viewer.getViewUpdater();
        updater.moveViewerLocationWithoutAnimation(newPoint);
    }

    private boolean isScrollModifiers(MouseWheelEvent e) {
        GraphViewer viewer = this.getGraphViewer(e);
        VisualGraphOptions options = viewer.getOptions();
        boolean scrollWheelPans = options.getScrollWheelPans();
        int scrollWheelModifierToggle = DockingUtils.CONTROL_KEY_MODIFIER_MASK;
        int eventModifiers = e.getModifiersEx();
        if (scrollWheelPans) {
            return (scrollWheelModifierToggle & eventModifiers) != scrollWheelModifierToggle;
        }
        return (scrollWheelModifierToggle & eventModifiers) == scrollWheelModifierToggle;
    }
}

