/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.editors;

import docking.widgets.combobox.GhidraComboBox;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.task.SetMatchTagTask;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;

public class MatchTagComboBox
extends GhidraComboBox {
    private final VTSession session;
    private final List<VTMatch> matches;
    private final VTMatchTag initialTag;
    private final JComponent parentComponent;

    public MatchTagComboBox(VTSession session, List<VTMatch> matches, JComponent parentComponent, VTMatchTag startTag) {
        this.session = session;
        this.matches = matches;
        this.parentComponent = parentComponent;
        this.loadTags();
        this.initialTag = startTag != null ? startTag : (matches != null && matches.size() > 0 ? matches.get(0).getTag() : null);
        VTMatchTag currentTag = this.initialTag;
        if (currentTag != null) {
            this.setSelectedItem(currentTag);
        }
        this.setEditable(false);
    }

    private void loadTags() {
        Set<VTMatchTag> matchTags = this.session.getMatchTags();
        ArrayList<VTMatchTag> tagList = new ArrayList<VTMatchTag>(matchTags);
        Collections.sort(tagList);
        for (VTMatchTag tag : tagList) {
            this.addItem(tag);
        }
    }

    public boolean apply() {
        VTMatchTag tag = (VTMatchTag)this.getSelectedItem();
        SetMatchTagTask task = new SetMatchTagTask(this.session, this.matches, tag);
        new TaskLauncher((Task)task, (Component)this.parentComponent);
        return true;
    }
}

