/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial;

import ghidra.util.database.spatial.BoundedShape;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public interface SpatialMap<DS extends BoundedShape<?>, T, Q> {
    public static final SpatialMap<?, ?, ?> EMPTY_MAP = new EmptySpatialMap();

    public static <DS extends BoundedShape<?>, T, Q> SpatialMap<DS, T, Q> emptyMap() {
        return EMPTY_MAP;
    }

    public T put(DS var1, T var2);

    public boolean remove(DS var1, T var2);

    public boolean remove(Map.Entry<DS, T> var1);

    public int size();

    public boolean isEmpty();

    public Collection<Map.Entry<DS, T>> entries();

    public Collection<Map.Entry<DS, T>> orderedEntries();

    public Collection<DS> keys();

    public Collection<DS> orderedKeys();

    public Collection<T> values();

    public Collection<T> orderedValues();

    public SpatialMap<DS, T, Q> reduce(Q var1);

    public Map.Entry<DS, T> firstEntry();

    public DS firstKey();

    public T firstValue();

    public void clear();

    public static class EmptySpatialMap<DS extends BoundedShape<?>, T, Q>
    implements SpatialMap<DS, T, Q> {
        @Override
        public T put(DS shape, T value) {
            throw new IllegalArgumentException();
        }

        @Override
        public boolean remove(DS shape, T value) {
            throw new IllegalArgumentException();
        }

        @Override
        public boolean remove(Map.Entry<DS, T> entry) {
            throw new IllegalArgumentException();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Collection<Map.Entry<DS, T>> entries() {
            return Collections.emptyList();
        }

        @Override
        public Collection<Map.Entry<DS, T>> orderedEntries() {
            return Collections.emptyList();
        }

        @Override
        public Collection<DS> keys() {
            return Collections.emptyList();
        }

        @Override
        public Collection<DS> orderedKeys() {
            return Collections.emptyList();
        }

        @Override
        public Collection<T> values() {
            return Collections.emptyList();
        }

        @Override
        public Collection<T> orderedValues() {
            return Collections.emptyList();
        }

        @Override
        public SpatialMap<DS, T, Q> reduce(Q query) {
            return this;
        }

        @Override
        public Map.Entry<DS, T> firstEntry() {
            return null;
        }

        @Override
        public DS firstKey() {
            return null;
        }

        @Override
        public T firstValue() {
            return null;
        }

        @Override
        public void clear() {
        }
    }
}

