/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockCache;
import ghidra.program.model.block.CodeBlockImpl;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.block.MultEntSubModel;
import ghidra.program.model.block.SingleEntSubIterator;
import ghidra.program.model.block.SubroutineBlockModel;
import ghidra.program.model.block.SubroutineDestReferenceIterator;
import ghidra.program.model.block.SubroutineSourceReferenceIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.LinkedList;

public class OverlapCodeSubModel
implements SubroutineBlockModel {
    public static final String OVERLAP_MODEL_NAME = "Overlapped Code";
    protected Program program;
    protected Listing listing;
    protected CodeBlockCache foundOSubs;
    protected MultEntSubModel modelM;

    public OverlapCodeSubModel(Program program) {
        this(program, false);
    }

    public OverlapCodeSubModel(Program program, boolean includeExternals) {
        this.program = program;
        this.listing = program.getListing();
        this.foundOSubs = new CodeBlockCache();
        this.modelM = new MultEntSubModel(program, includeExternals);
    }

    protected CodeBlock getSubroutine(Address mStartAddr, TaskMonitor monitor) throws CancelledException {
        AddressSet addrSet = new AddressSet();
        LinkedList<Address> todoList = new LinkedList<Address>();
        todoList.addFirst(mStartAddr);
        CodeBlockModel bbModel = this.modelM.getBasicBlockModel();
        while (!todoList.isEmpty()) {
            CodeBlock bblock;
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            Address a = (Address)todoList.removeLast();
            if (addrSet.contains(a) || (bblock = bbModel.getFirstCodeBlockContaining(a, monitor)) == null || this.listing.getInstructionAt(a) == null) continue;
            addrSet.add(bblock);
            CodeBlockReferenceIterator destIter = bblock.getDestinations(monitor);
            while (destIter.hasNext()) {
                CodeBlockReference destRef = destIter.next();
                FlowType refFlowType = destRef.getFlowType();
                if (!refFlowType.isJump() && !refFlowType.isFallthrough()) continue;
                todoList.add(destRef.getDestinationAddress());
            }
        }
        return this.createSub(addrSet, mStartAddr);
    }

    @Override
    public CodeBlock getCodeBlockAt(Address addr, TaskMonitor monitor) throws CancelledException {
        CodeBlock block = this.foundOSubs.getBlockAt(addr);
        if (block != null) {
            return block;
        }
        CodeBlock modelMSub = this.modelM.getCodeBlockAt(addr, monitor);
        if (modelMSub != null) {
            Address[] entPts = modelMSub.getStartAddresses();
            if (entPts.length == 1) {
                return this.createSub(modelMSub, addr);
            }
            return this.getSubroutine(addr, monitor);
        }
        return null;
    }

    @Override
    public CodeBlock[] getCodeBlocksContaining(Address addr, TaskMonitor monitor) throws CancelledException {
        CodeBlock[] blocks = this.foundOSubs.getBlocksContaining(addr);
        if (blocks != null && blocks[0] != null) {
            return blocks;
        }
        CodeBlock modelMSub = this.modelM.getFirstCodeBlockContaining(addr, monitor);
        if (modelMSub == null) {
            return emptyBlockArray;
        }
        Address[] entPts = modelMSub.getStartAddresses();
        int cnt = entPts.length;
        if (cnt == 1) {
            blocks = new CodeBlock[]{this.createSub(modelMSub, entPts[0])};
            return blocks;
        }
        ArrayList<CodeBlock> blockList = new ArrayList<CodeBlock>();
        for (int i = 0; i < cnt; ++i) {
            CodeBlock block = this.getSubroutine(entPts[i], monitor);
            if (!block.contains(addr)) continue;
            blockList.add(block);
        }
        return blockList.toArray(new CodeBlock[blockList.size()]);
    }

    @Override
    public CodeBlock getFirstCodeBlockContaining(Address addr, TaskMonitor monitor) throws CancelledException {
        CodeBlock block = this.foundOSubs.getFirstBlockContaining(addr);
        if (block != null) {
            return block;
        }
        CodeBlock modelMSub = this.modelM.getFirstCodeBlockContaining(addr, monitor);
        if (modelMSub == null) {
            return null;
        }
        Address[] entPts = modelMSub.getStartAddresses();
        int cnt = entPts.length;
        if (cnt == 1) {
            return this.createSub(modelMSub, entPts[0]);
        }
        for (int i = 0; i < cnt; ++i) {
            block = this.getSubroutine(entPts[i], monitor);
            if (block == null || !block.contains(addr)) continue;
            return block;
        }
        return null;
    }

    @Override
    public CodeBlockIterator getCodeBlocks(TaskMonitor monitor) throws CancelledException {
        return new SingleEntSubIterator(this, monitor);
    }

    @Override
    public CodeBlockIterator getCodeBlocksContaining(AddressSetView addrSet, TaskMonitor monitor) throws CancelledException {
        return new SingleEntSubIterator(this, addrSet, monitor);
    }

    protected MultEntSubModel getModelM() {
        return this.modelM;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    public Listing getListing() {
        return this.listing;
    }

    @Override
    public String getName(CodeBlock block) {
        if (!(block.getModel() instanceof OverlapCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        Address start = block.getFirstStartAddress();
        Symbol symbol = this.program.getSymbolTable().getPrimarySymbol(start);
        if (symbol != null) {
            return symbol.getName();
        }
        return "SOURCE_SUB" + start.toString();
    }

    @Override
    public FlowType getFlowType(CodeBlock block) {
        if (!(block.getModel() instanceof OverlapCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        return RefType.FLOW;
    }

    @Override
    public CodeBlockReferenceIterator getSources(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof OverlapCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        return new SubroutineSourceReferenceIterator(block, monitor);
    }

    @Override
    public int getNumSources(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof OverlapCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        return SubroutineSourceReferenceIterator.getNumSources(block, monitor);
    }

    @Override
    public CodeBlockReferenceIterator getDestinations(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof OverlapCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        return new SubroutineDestReferenceIterator(block, monitor);
    }

    @Override
    public int getNumDestinations(CodeBlock block, TaskMonitor monitor) throws CancelledException {
        if (!(block.getModel() instanceof OverlapCodeSubModel)) {
            throw new IllegalArgumentException();
        }
        return SubroutineDestReferenceIterator.getNumDestinations(block, monitor);
    }

    protected CodeBlock createSub(AddressSetView addrSet, Address entryPt) {
        if (addrSet.isEmpty()) {
            return null;
        }
        Address[] entryPts = new Address[]{entryPt};
        CodeBlockImpl block = new CodeBlockImpl(this, entryPts, addrSet);
        this.foundOSubs.addObject(block, addrSet);
        return block;
    }

    @Override
    public CodeBlockModel getBasicBlockModel() {
        return this.modelM.getBasicBlockModel();
    }

    @Override
    public String getName() {
        return OVERLAP_MODEL_NAME;
    }

    @Override
    public SubroutineBlockModel getBaseSubroutineModel() {
        return this.modelM;
    }

    @Override
    public boolean allowsBlockOverlap() {
        return true;
    }

    @Override
    public boolean externalsIncluded() {
        return this.modelM.externalsIncluded();
    }
}

