/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.symbol;

import db.DBRecord;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.symbol.SymbolDB;
import ghidra.program.database.symbol.SymbolManager;
import ghidra.program.database.symbol.VariableStorageManagerDB;
import ghidra.program.database.symbol.VariableSymbolDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.AssertException;

public class GlobalVariableSymbolDB
extends VariableSymbolDB {
    public GlobalVariableSymbolDB(SymbolManager symbolMgr, DBObjectCache<SymbolDB> cache, VariableStorageManagerDB variableMgr, Address address, DBRecord record) {
        super(symbolMgr, cache, SymbolType.GLOBAL_VAR, variableMgr, address, record);
        if (record.getLongValue(2) != 0L) {
            throw new AssertException();
        }
    }

    @Override
    public SymbolType getSymbolType() {
        return SymbolType.GLOBAL_VAR;
    }

    @Override
    public boolean isValidParent(Namespace parent) {
        return this.symbolMgr.getProgram().getGlobalNamespace() == parent;
    }

    @Override
    public Variable getObject() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String doGetName() {
        if (!this.checkIsValid()) {
            return "[Invalid Global Variable Symbol - Deleted!]";
        }
        VariableStorage storage = this.getVariableStorage();
        if (storage == null || storage.isBadStorage()) {
            return "local__!BAD!";
        }
        if (this.getSource() == SourceType.DEFAULT) {
            return GlobalVariableSymbolDB.getDefaultLocalName(this.getProgram(), storage);
        }
        return super.doGetName();
    }

    private static String getDefaultLocalName(Program program, VariableStorage storage) {
        StringBuilder buffy = new StringBuilder("global");
        for (Varnode v : storage.getVarnodes()) {
            buffy.append('_');
            Register reg = program.getRegister(v);
            if (reg != null) {
                buffy.append(reg.getName());
                continue;
            }
            Address addr = v.getAddress();
            buffy.append(addr.getAddressSpace().getName() + Long.toHexString(addr.getOffset()));
        }
        return buffy.toString();
    }
}

