/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.map;

import db.DBHandle;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressMapDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.KeyRange;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class AddressMapDBAdapterNoTable
extends AddressMapDBAdapter {
    private Address[] addresses;
    private AddressFactory factory;

    AddressMapDBAdapterNoTable(DBHandle handle, AddressFactory factory) {
        this.factory = factory;
        AddressSpace[] spaces = factory.getAddressSpaces();
        this.addresses = new Address[spaces.length];
        for (int i = 0; i < spaces.length; ++i) {
            this.addresses[i] = spaces[i].getAddress(0L);
        }
        Arrays.sort(this.addresses);
        this.oldAddrMap = new FactoryBasedAddressMap();
    }

    @Override
    Address[] getBaseAddresses(boolean forceRead) {
        return this.addresses;
    }

    @Override
    Address[] addBaseAddress(Address addr, long normalizedOffset) {
        throw new UnsupportedOperationException();
    }

    @Override
    List<AddressMapDBAdapter.AddressMapEntry> getEntries() throws IOException {
        ArrayList<AddressMapDBAdapter.AddressMapEntry> list = new ArrayList<AddressMapDBAdapter.AddressMapEntry>();
        for (int i = 0; i < this.addresses.length; ++i) {
            list.add(new AddressMapDBAdapter.AddressMapEntry(i, this.addresses[i].getAddressSpace().getName(), 0, false));
        }
        return list;
    }

    @Override
    void setEntries(List<AddressMapDBAdapter.AddressMapEntry> entries) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void clearAll() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void setAddressFactory(AddressFactory addrFactory) {
        this.factory = addrFactory;
    }

    @Override
    void renameOverlaySpace(String oldName, String newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteOverlaySpace(String name) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void deleteTable() {
    }

    private class FactoryBasedAddressMap
    implements AddressMap {
        private Comparator<Object> addressInsertionKeyRangeComparator = new Comparator<Object>(){

            @Override
            public int compare(Object keyRangeObj, Object addrObj) {
                KeyRange range = (KeyRange)keyRangeObj;
                Address addr = (Address)addrObj;
                Address min = FactoryBasedAddressMap.this.decodeAddress(range.minKey);
                if (min.compareTo(addr) > 0) {
                    return 1;
                }
                Address max = FactoryBasedAddressMap.this.decodeAddress(range.maxKey);
                if (max.compareTo(addr) < 0) {
                    return -1;
                }
                return 0;
            }
        };

        private FactoryBasedAddressMap() {
        }

        @Override
        public long getKey(Address addr, boolean create) {
            if (create) {
                throw new IllegalArgumentException("Old address map does not support key creation");
            }
            return AddressMapDBAdapterNoTable.this.factory.getIndex(addr);
        }

        @Override
        public long getAbsoluteEncoding(Address addr, boolean create) {
            if (create) {
                throw new IllegalArgumentException("Old address map does not support key creation");
            }
            return AddressMapDBAdapterNoTable.this.factory.getIndex(addr);
        }

        @Override
        public Address decodeAddress(long value) {
            return AddressMapDBAdapterNoTable.this.factory.oldGetAddressFromLong(value);
        }

        @Override
        public AddressFactory getAddressFactory() {
            return AddressMapDBAdapterNoTable.this.factory;
        }

        @Override
        public List<KeyRange> getKeyRanges(Address start, Address end, boolean create) {
            return this.getKeyRanges(start, end, false, create);
        }

        @Override
        public List<KeyRange> getKeyRanges(AddressSetView set, boolean create) {
            return this.getKeyRanges(set, false, create);
        }

        @Override
        public List<KeyRange> getKeyRanges(AddressSetView set, boolean absolute, boolean create) {
            ArrayList<KeyRange> keyRangeList = new ArrayList<KeyRange>();
            if (absolute) {
                return keyRangeList;
            }
            if (set == null) {
                keyRangeList.add(new KeyRange(Long.MIN_VALUE, Long.MAX_VALUE));
            } else {
                AddressRangeIterator it = set.getAddressRanges();
                while (it.hasNext()) {
                    AddressRange range = (AddressRange)it.next();
                    Address start = range.getMinAddress();
                    Address end = range.getMaxAddress();
                    keyRangeList.add(new KeyRange(AddressMapDBAdapterNoTable.this.factory.getIndex(start), AddressMapDBAdapterNoTable.this.factory.getIndex(end)));
                }
            }
            return keyRangeList;
        }

        @Override
        public int findKeyRange(List<KeyRange> keyRangeList, Address addr) {
            if (addr == null) {
                return -1;
            }
            return Collections.binarySearch(keyRangeList, addr, this.addressInsertionKeyRangeComparator);
        }

        @Override
        public List<KeyRange> getKeyRanges(Address start, Address end, boolean absolute, boolean create) {
            return this.getKeyRanges(AddressMapDBAdapterNoTable.this.factory.getAddressSet(start, end), absolute, create);
        }

        @Override
        public Address getImageBase() {
            return AddressMapDBAdapterNoTable.this.factory.getDefaultAddressSpace().getAddress(0L);
        }

        @Override
        public AddressMap getOldAddressMap() {
            return this;
        }

        @Override
        public boolean isUpgraded() {
            return false;
        }
    }
}

