/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeComponentImpl;
import ghidra.program.model.lang.DataTypeProviderContext;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import java.util.ArrayList;

public class ProgramProviderContext
implements DataTypeProviderContext {
    Program program;
    Address addr;

    public ProgramProviderContext(Program program, Address addr) {
        this.program = program;
        this.addr = addr;
    }

    @Override
    public DataTypeComponent[] getDataTypeComponents(int start, int end) {
        DataTypeComponent dtc;
        ArrayList<DataTypeComponent> list = new ArrayList<DataTypeComponent>();
        for (int offset = start; offset <= end && (dtc = this.getDataTypeComponent(offset)) != null; offset += dtc.getLength()) {
            list.add(dtc);
        }
        return list.toArray(new DataTypeComponent[list.size()]);
    }

    @Override
    public DataTypeComponent getDataTypeComponent(int offset) {
        Data data = this.getData(offset);
        if (data == null) {
            return null;
        }
        DataType dt = data.getDataType();
        int length = DataTypeComponentImpl.getPreferredComponentLength(dt, Math.max(data.getLength(), dt.getLength()));
        String label = null;
        Symbol symbol = data.getPrimarySymbol();
        if (symbol != null && !symbol.isDynamic()) {
            label = symbol.getName();
        }
        String comment = data.getComment(CommentType.EOL);
        return new DataTypeComponentImpl(dt, null, length, 0, offset, label, comment);
    }

    private Data getData(int offset) {
        Address offAddr = this.addr.addWrap(offset);
        return this.program.getListing().getDataAt(offAddr);
    }

    @Override
    public String getUniqueName(String baseName) {
        return this.program.getListing().getDataTypeManager().getUniqueName(CategoryPath.ROOT, baseName);
    }
}

