/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "GeographicLib", "index.html", [
    [ "GeographicLib library", "index.html", "index" ],
    [ "Introduction", "intro.html", null ],
    [ "Installing GeographicLib", "install.html", [
      [ "Installation with cmake", "install.html#cmake", null ],
      [ "Installation using the autoconfigure tools", "install.html#autoconf", null ],
      [ "Using a binary installer", "install.html#binaryinst", [
        [ "Windows", "install.html#binaryinstwin", null ],
        [ "MacOSX", "install.html#binaryinstosx", null ],
        [ "Linux", "install.html#binaryinstlin", null ]
      ] ],
      [ "Maintainer tasks", "install.html#maintainer", null ]
    ] ],
    [ "Getting started", "start.html", null ],
    [ "Utility programs", "utilities.html", null ],
    [ "Code organization", "organization.html", null ],
    [ "GeographicLib in other languages", "other.html", [
      [ "Implementations in other languages", "other.html#implement", null ],
      [ "Using wrappers to invoke GeographicLib", "other.html#wrappers", null ],
      [ "Maxima routines", "other.html#maxima", null ]
    ] ],
    [ "Geoid height", "geoid.html", [
      [ "Installing the geoid datasets", "geoid.html#geoidinst", null ],
      [ "The format of the geoid data files", "geoid.html#geoidformat", null ],
      [ "Interpolating the geoid data", "geoid.html#geoidinterp", null ],
      [ "Caching the geoid data", "geoid.html#geoidcache", null ],
      [ "Test data for geoids", "geoid.html#testgeoid", null ]
    ] ],
    [ "Gravity models", "gravity.html", [
      [ "Installing the gravity models", "gravity.html#gravityinst", null ],
      [ "The format of the gravity model files", "gravity.html#gravityformat", null ],
      [ "Comments on the NGA harmonic synthesis code", "gravity.html#gravitynga", null ],
      [ "Details of the geoid height and anomaly calculations", "gravity.html#gravitygeoid", null ],
      [ "The effect of the mass of the atmosphere", "gravity.html#gravityatmos", null ],
      [ "Geoid heights on a multi-processor system", "gravity.html#gravityparallel", null ]
    ] ],
    [ "Normal gravity", "normalgravity.html", [
      [ "Ellipsoidal coordinates", "normalgravity.html#normalgravcoords", null ],
      [ "The normal potential", "normalgravity.html#normalgravpot", null ],
      [ "The mass distribution", "normalgravity.html#normalgravmass", null ],
      [ "The surface gravity", "normalgravity.html#normalgravsurf", null ],
      [ "The mean gravity", "normalgravity.html#normalgravmean", null ],
      [ "Possible values of the dynamical form factor", "normalgravity.html#normalgravj2", null ]
    ] ],
    [ "Magnetic models", "magnetic.html", [
      [ "Installing the magnetic field models", "magnetic.html#magneticinst", null ],
      [ "The format of the magnetic model files", "magnetic.html#magneticformat", null ]
    ] ],
    [ "Geodesics on an ellipsoid of revolution", "geodesic.html", [
      [ "Test data for geodesics", "geodesic.html#testgeod", null ],
      [ "Expansions for geodesics", "geodesic.html#geodseries", null ],
      [ "Geodesics in terms of elliptic integrals", "geodesic.html#geodellip", null ],
      [ "Parameters for the meridian", "geodesic.html#meridian", null ],
      [ "Short geodesics", "geodesic.html#geodshort", [
        [ "Bowring's method", "geodesic.html#bowring", null ],
        [ "Bessel's auxiliary sphere", "geodesic.html#auxsphere", null ],
        [ "Estimating the accuracy", "geodesic.html#shorterr", null ]
      ] ]
    ] ],
    [ "Finding nearest neighbors", "nearest.html", null ],
    [ "Geodesics on a triaxial ellipsoid", "triaxial.html", [
      [ "Triaxial coordinate systems", "triaxial.html#triaxial-coords", null ],
      [ "Jacobi's solution", "triaxial.html#triaxial-jacobi", null ],
      [ "Survey of triaxial geodesics", "triaxial.html#triaxial-survey", null ],
      [ "The stability of closed geodesics", "triaxial.html#triaxial-stab", null ],
      [ "The inverse problem", "triaxial.html#triaxial-inverse", null ],
      [ "Jacobi's conformal projection", "triaxial.html#triaxial-conformal", null ]
    ] ],
    [ "Jacobi's conformal projection", "jacobi.html", [
      [ "Conformal projection", "jacobi.html#jacobi-conformal", null ],
      [ "The projection in terms of elliptic integrals", "jacobi.html#jacobi-elliptic", null ],
      [ "Properties of the projection", "jacobi.html#jacobi-properties", null ],
      [ "Limiting cases", "jacobi.html#jacobi-limiting", null ],
      [ "Conformal mapping of an ellipsoid to a sphere", "jacobi.html#jacobi-sphere", null ],
      [ "An implementation of the projection", "jacobi.html#jacobi-implementation", null ]
    ] ],
    [ "Rhumb lines", "rhumb.html", [
      [ "Formulation of the rhumb line problem", "rhumb.html#rhumbform", null ],
      [ "Determining the auxiliary latitudes", "rhumb.html#rhumblat", null ],
      [ "The area under a rhumb line", "rhumb.html#rhumbarea", null ],
      [ "Use of divided differences", "rhumb.html#divideddiffs", null ],
      [ "Clenshaw evaluation of differenced sums", "rhumb.html#dividedclenshaw", null ],
      [ "Plate carrée areas", "rhumb.html#platecarreearea", null ]
    ] ],
    [ "Great Ellipses", "greatellipse.html", [
      [ "Solution of great ellipse problems", "greatellipse.html#geformulation", null ],
      [ "The area under a great ellipse", "greatellipse.html#gearea", null ],
      [ "Great ellipses vs geodesics", "greatellipse.html#gevsgeodesic", null ]
    ] ],
    [ "Transverse Mercator projection", "transversemercator.html", [
      [ "Test data for the transverse Mercator projection", "transversemercator.html#testmerc", null ],
      [ "Series approximation for transverse Mercator", "transversemercator.html#tmseries", null ],
      [ "Figures from paper on transverse Mercator projection", "transversemercator.html#tmfigures", null ]
    ] ],
    [ "Geocentric coordinates", "geocentric.html", null ],
    [ "Auxiliary latitudes", "auxlat.html", [
      [ "Series approximations for conversions", "auxlat.html#auxlatformula", null ],
      [ "Series approximations in tabular form", "auxlat.html#auxlattable", null ],
      [ "Truncation errors", "auxlat.html#auxlaterror", null ]
    ] ],
    [ "Support for high precision arithmetic", "highprec.html", null ],
    [ "Change log", "changes.html", null ],
    [ "Deprecated List", "deprecated.html", null ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", null ],
        [ "Functions", "namespacemembers_func.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", null ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", null ],
        [ "Related Symbols", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", null ],
        [ "Functions", "globals_func.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Macros", "globals_defs.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"Accumulator_8cpp.html",
"auxlat.html#auxlattable",
"classGeographicLib_1_1Constants.html#a49cb7b828f7c85c36761d47b8db6518c",
"classGeographicLib_1_1EllipticFunction.html#a9faaff12ef51d4130ae33fe84fe8c186",
"classGeographicLib_1_1Geodesic.html#ad1cece51e3315c10a0eb94676ed2de81",
"classGeographicLib_1_1GeodesicLineExact.html#a7df73cee6e5e59f0e3f7a9ccff8c4c3c",
"classGeographicLib_1_1GravityModel.html#aa333ec20d1ddbd9ddf28a1b46e87b31a",
"classGeographicLib_1_1Math.html#a84eda61c6698a96cc8498f7e6a30090f",
"classGeographicLib_1_1Rhumb.html#ae69e0f6f93b317025c1d60ddc409831f",
"classGeographicLib_1_1UTMUPS.html#aaf417ae6bed6da324aa03fc96ee0dda4"
];

var SYNCONMSG = 'click to disable panel synchronisation';
var SYNCOFFMSG = 'click to enable panel synchronisation';