import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { useState } from 'react';
import { Box, useIsScreenReaderEnabled } from 'ink';
import { LoadingIndicator } from './LoadingIndicator.js';
import { StatusDisplay } from './StatusDisplay.js';
import { ToastDisplay, shouldShowToast } from './ToastDisplay.js';
import { ApprovalModeIndicator } from './ApprovalModeIndicator.js';
import { ShellModeIndicator } from './ShellModeIndicator.js';
import { DetailedMessagesDisplay } from './DetailedMessagesDisplay.js';
import { RawMarkdownIndicator } from './RawMarkdownIndicator.js';
import { ShortcutsHint } from './ShortcutsHint.js';
import { ShortcutsHelp } from './ShortcutsHelp.js';
import { InputPrompt } from './InputPrompt.js';
import { Footer } from './Footer.js';
import { ShowMoreLines } from './ShowMoreLines.js';
import { QueuedMessageDisplay } from './QueuedMessageDisplay.js';
import { HorizontalLine } from './shared/HorizontalLine.js';
import { OverflowProvider } from '../contexts/OverflowContext.js';
import { isNarrowWidth } from '../utils/isNarrowWidth.js';
import { useUIState } from '../contexts/UIStateContext.js';
import { useUIActions } from '../contexts/UIActionsContext.js';
import { useVimMode } from '../contexts/VimModeContext.js';
import { useConfig } from '../contexts/ConfigContext.js';
import { useSettings } from '../contexts/SettingsContext.js';
import { useAlternateBuffer } from '../hooks/useAlternateBuffer.js';
import { StreamingState, ToolCallStatus } from '../types.js';
import { ConfigInitDisplay } from '../components/ConfigInitDisplay.js';
import { TodoTray } from './messages/Todo.js';
import { getInlineThinkingMode } from '../utils/inlineThinkingMode.js';
export const Composer = ({ isFocused = true }) => {
    const config = useConfig();
    const settings = useSettings();
    const isScreenReaderEnabled = useIsScreenReaderEnabled();
    const uiState = useUIState();
    const uiActions = useUIActions();
    const { vimEnabled, vimMode } = useVimMode();
    const inlineThinkingMode = getInlineThinkingMode(settings);
    const terminalWidth = uiState.terminalWidth;
    const isNarrow = isNarrowWidth(terminalWidth);
    const debugConsoleMaxHeight = Math.floor(Math.max(terminalWidth * 0.2, 5));
    const [suggestionsVisible, setSuggestionsVisible] = useState(false);
    const isAlternateBuffer = useAlternateBuffer();
    const { showApprovalModeIndicator } = uiState;
    const suggestionsPosition = isAlternateBuffer ? 'above' : 'below';
    const hideContextSummary = suggestionsVisible && suggestionsPosition === 'above';
    const hasPendingToolConfirmation = (uiState.pendingHistoryItems ?? []).some((item) => item.type === 'tool_group' &&
        item.tools.some((tool) => tool.status === ToolCallStatus.Confirming));
    const hasPendingActionRequired = hasPendingToolConfirmation ||
        Boolean(uiState.commandConfirmationRequest) ||
        Boolean(uiState.authConsentRequest) ||
        (uiState.confirmUpdateExtensionRequests?.length ?? 0) > 0 ||
        Boolean(uiState.loopDetectionConfirmationRequest) ||
        Boolean(uiState.quota.proQuotaRequest) ||
        Boolean(uiState.quota.validationRequest) ||
        Boolean(uiState.customDialog);
    const hasToast = shouldShowToast(uiState);
    const showLoadingIndicator = (!uiState.embeddedShellFocused || uiState.isBackgroundShellVisible) &&
        uiState.streamingState === StreamingState.Responding &&
        !hasPendingActionRequired;
    const showApprovalIndicator = !uiState.shellModeActive;
    const showRawMarkdownIndicator = !uiState.renderMarkdown;
    return (_jsxs(Box, { flexDirection: "column", width: uiState.terminalWidth, flexGrow: 0, flexShrink: 0, children: [(!uiState.slashCommands ||
                !uiState.isConfigInitialized ||
                uiState.isResuming) && (_jsx(ConfigInitDisplay, { message: uiState.isResuming ? 'Resuming session...' : undefined })), _jsx(QueuedMessageDisplay, { messageQueue: uiState.messageQueue }), _jsx(TodoTray, {}), _jsxs(Box, { marginTop: 1, width: "100%", flexDirection: "column", children: [_jsxs(Box, { width: "100%", flexDirection: isNarrow ? 'column' : 'row', alignItems: isNarrow ? 'flex-start' : 'center', justifyContent: isNarrow ? 'flex-start' : 'space-between', children: [_jsx(Box, { marginLeft: 1, marginRight: isNarrow ? 0 : 1, flexDirection: "row", alignItems: "center", flexGrow: 1, children: showLoadingIndicator && (_jsx(LoadingIndicator, { inline: true, thought: uiState.streamingState ===
                                        StreamingState.WaitingForConfirmation ||
                                        config.getAccessibility()?.enableLoadingPhrases === false
                                        ? undefined
                                        : uiState.thought, currentLoadingPhrase: config.getAccessibility()?.enableLoadingPhrases === false
                                        ? undefined
                                        : uiState.currentLoadingPhrase, thoughtLabel: inlineThinkingMode === 'full' ? 'Thinking ...' : undefined, elapsedTime: uiState.elapsedTime })) }), _jsx(Box, { marginTop: isNarrow ? 1 : 0, flexDirection: "column", alignItems: isNarrow ? 'flex-start' : 'flex-end', children: !hasPendingActionRequired && _jsx(ShortcutsHint, {}) })] }), uiState.shortcutsHelpVisible && _jsx(ShortcutsHelp, {}), _jsx(HorizontalLine, {}), _jsxs(Box, { justifyContent: settings.merged.ui.hideContextSummary
                            ? 'flex-start'
                            : 'space-between', width: "100%", flexDirection: isNarrow ? 'column' : 'row', alignItems: isNarrow ? 'flex-start' : 'center', children: [_jsx(Box, { marginLeft: 1, marginRight: isNarrow ? 0 : 1, flexDirection: "row", alignItems: "center", flexGrow: 1, children: hasToast ? (_jsx(ToastDisplay, {})) : (!showLoadingIndicator && (_jsxs(Box, { flexDirection: isNarrow ? 'column' : 'row', alignItems: isNarrow ? 'flex-start' : 'center', children: [showApprovalIndicator && (_jsx(ApprovalModeIndicator, { approvalMode: showApprovalModeIndicator, isPlanEnabled: config.isPlanEnabled() })), uiState.shellModeActive && (_jsx(Box, { marginLeft: showApprovalIndicator && !isNarrow ? 1 : 0, marginTop: showApprovalIndicator && isNarrow ? 1 : 0, children: _jsx(ShellModeIndicator, {}) })), showRawMarkdownIndicator && (_jsx(Box, { marginLeft: (showApprovalIndicator || uiState.shellModeActive) &&
                                                !isNarrow
                                                ? 1
                                                : 0, marginTop: (showApprovalIndicator || uiState.shellModeActive) &&
                                                isNarrow
                                                ? 1
                                                : 0, children: _jsx(RawMarkdownIndicator, {}) }))] }))) }), _jsx(Box, { marginTop: isNarrow ? 1 : 0, flexDirection: "column", alignItems: isNarrow ? 'flex-start' : 'flex-end', children: !showLoadingIndicator && (_jsx(StatusDisplay, { hideContextSummary: hideContextSummary })) })] })] }), uiState.showErrorDetails && (_jsx(OverflowProvider, { children: _jsxs(Box, { flexDirection: "column", children: [_jsx(DetailedMessagesDisplay, { messages: uiState.filteredConsoleMessages, maxHeight: uiState.constrainHeight ? debugConsoleMaxHeight : undefined, width: uiState.terminalWidth, hasFocus: uiState.showErrorDetails }), _jsx(ShowMoreLines, { constrainHeight: uiState.constrainHeight })] }) })), uiState.isInputActive && (_jsx(InputPrompt, { buffer: uiState.buffer, inputWidth: uiState.inputWidth, suggestionsWidth: uiState.suggestionsWidth, onSubmit: uiActions.handleFinalSubmit, userMessages: uiState.userMessages, setBannerVisible: uiActions.setBannerVisible, onClearScreen: uiActions.handleClearScreen, config: config, slashCommands: uiState.slashCommands || [], commandContext: uiState.commandContext, shellModeActive: uiState.shellModeActive, setShellModeActive: uiActions.setShellModeActive, approvalMode: showApprovalModeIndicator, onEscapePromptChange: uiActions.onEscapePromptChange, focus: isFocused, vimHandleInput: uiActions.vimHandleInput, isEmbeddedShellFocused: uiState.embeddedShellFocused, popAllMessages: uiActions.popAllMessages, placeholder: vimEnabled
                    ? vimMode === 'INSERT'
                        ? "  Press 'Esc' for NORMAL mode."
                        : "  Press 'i' for INSERT mode."
                    : uiState.shellModeActive
                        ? '  Type your shell command'
                        : '  Type your message or @path/to/file', setQueueErrorMessage: uiActions.setQueueErrorMessage, streamingState: uiState.streamingState, suggestionsPosition: suggestionsPosition, onSuggestionsVisibilityChange: setSuggestionsVisible })), !settings.merged.ui.hideFooter && !isScreenReaderEnabled && _jsx(Footer, {})] }));
};
//# sourceMappingURL=Composer.js.map