/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { GLOB_TOOL_NAME, GREP_TOOL_NAME, LS_TOOL_NAME, READ_FILE_TOOL_NAME, SHELL_TOOL_NAME, WRITE_FILE_TOOL_NAME } from './definitions/coreTools.js';
export { GLOB_TOOL_NAME, GREP_TOOL_NAME, LS_TOOL_NAME, READ_FILE_TOOL_NAME, SHELL_TOOL_NAME, WRITE_FILE_TOOL_NAME, };
export declare const WRITE_TODOS_TOOL_NAME = "write_todos";
export declare const WEB_SEARCH_TOOL_NAME = "google_web_search";
export declare const WEB_FETCH_TOOL_NAME = "web_fetch";
export declare const EDIT_TOOL_NAME = "replace";
export declare const READ_MANY_FILES_TOOL_NAME = "read_many_files";
export declare const LS_TOOL_NAME_LEGACY = "list_directory";
export declare const MEMORY_TOOL_NAME = "save_memory";
export declare const GET_INTERNAL_DOCS_TOOL_NAME = "get_internal_docs";
export declare const ACTIVATE_SKILL_TOOL_NAME = "activate_skill";
export declare const EDIT_TOOL_NAMES: Set<string>;
export declare const ASK_USER_TOOL_NAME = "ask_user";
export declare const ASK_USER_DISPLAY_NAME = "Ask User";
export declare const EXIT_PLAN_MODE_TOOL_NAME = "exit_plan_mode";
export declare const ENTER_PLAN_MODE_TOOL_NAME = "enter_plan_mode";
/**
 * Mapping of legacy tool names to their current names.
 * This ensures backward compatibility for user-defined policies, skills, and hooks.
 */
export declare const TOOL_LEGACY_ALIASES: Record<string, string>;
/**
 * Returns all associated names for a tool (including legacy aliases and current name).
 * This ensures that if multiple legacy names point to the same tool, we consider all of them
 * for policy application.
 */
export declare function getToolAliases(name: string): string[];
/** Prefix used for tools discovered via the tool DiscoveryCommand. */
export declare const DISCOVERED_TOOL_PREFIX = "discovered_tool_";
/**
 * List of all built-in tool names.
 */
export declare const ALL_BUILTIN_TOOL_NAMES: readonly ["glob", "write_todos", "write_file", "google_web_search", "web_fetch", "replace", "run_shell_command", "grep_search", "read_many_files", "read_file", "list_directory", "save_memory", "activate_skill", "ask_user"];
/**
 * Read-only tools available in Plan Mode.
 * This list is used to dynamically generate the Plan Mode prompt,
 * filtered by what tools are actually enabled in the current configuration.
 */
export declare const PLAN_MODE_TOOLS: readonly ["glob", "grep_search", "read_file", "list_directory", "google_web_search", "ask_user", "exit_plan_mode"];
/**
 * Validates if a tool name is syntactically valid.
 * Checks against built-in tools, discovered tools, and MCP naming conventions.
 */
export declare function isValidToolName(name: string, options?: {
    allowWildcards?: boolean;
}): boolean;
