/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Options for headless mode detection.
 */
export interface HeadlessModeOptions {
    /** Explicit prompt string or flag. */
    prompt?: string | boolean;
    /** Initial query positional argument. */
    query?: string | boolean;
}
/**
 * Detects if the CLI is running in a "headless" (non-interactive) mode.
 *
 * Headless mode is triggered by:
 * 1. process.env.CI being set to 'true'.
 * 2. process.stdout not being a TTY.
 * 3. Presence of an explicit prompt flag.
 *
 * @param options - Optional flags and arguments from the CLI.
 * @returns true if the environment is considered headless.
 */
export declare function isHeadlessMode(options?: HeadlessModeOptions): boolean;
