/**
 * @license
 * Copyright 2026 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Abstract base class for A2A authentication providers.
 */
export class BaseA2AAuthProvider {
    static MAX_AUTH_RETRIES = 2;
    authRetryCount = 0;
    /**
     * Default: retry on 401/403 with fresh headers.
     * Subclasses with cached tokens must override to force-refresh to avoid infinite retries.
     */
    async shouldRetryWithHeaders(_req, res) {
        if (res.status === 401 || res.status === 403) {
            if (this.authRetryCount >= BaseA2AAuthProvider.MAX_AUTH_RETRIES) {
                return undefined; // Max retries exceeded
            }
            this.authRetryCount++;
            return this.headers();
        }
        // Reset on success
        this.authRetryCount = 0;
        return undefined;
    }
    async initialize() { }
}
//# sourceMappingURL=base-provider.js.map