searchData={"items":[{"type":"module","title":"odbc","doc":"Erlang ODBC application\n\nThis application provides an Erlang interface to communicate with relational\nSQL-databases. It is built on top of Microsofts ODBC interface and therefore\nrequires that you have an ODBC driver to the database that you want to connect\nto.\n\n> #### Note {: .info }\n>\n> The functions `first/[1,2]`, `last/[1,2]`, `next/[1,2]`, `prev[1,2]` and\n> `select/[3,4]` assumes there is a result set associated with the connection to\n> work on. Calling the function `select_count/[2,3]` associates such a result\n> set with the connection. Calling select_count again will remove the current\n> result set association and create a new one. Calling a function which dose not\n> operate on an associated result sets, such as `sql_query/[2,3]`, will remove\n> the current result set association.\n>\n> Alas some drivers only support sequential traversal of the result set, e.i.\n> they do not support what in the ODBC world is known as scrollable cursors.\n> This will have the effect that functions such as `first/[1,2]`, `last/[1,2]`,\n> `prev[1,2]`, etc will return `{error, driver_does_not_support_function}`","ref":"odbc.html"},{"type":"module","title":"Error Handling - odbc","doc":"The error handling strategy and possible errors sources are described in the\nErlang ODBC [User's Guide.](error_handling.md)","ref":"odbc.html#module-error-handling"},{"type":"module","title":"References - odbc","doc":"\\[1]: Microsoft ODBC 3.0, Programmer's Reference and SDK Guide  \nSee also http://msdn.microsoft.com/","ref":"odbc.html#module-references"},{"type":"type","title":"odbc.col_name/0","doc":"Name of column in the result set.","ref":"odbc.html#t:col_name/0"},{"type":"function","title":"odbc.commit/2","doc":"Equivalent to  commit/3 .","ref":"odbc.html#commit/2"},{"type":"function","title":"odbc.commit/3","doc":"Commits or rollbacks a transaction. Needed on connections where automatic commit\nis turned off.","ref":"odbc.html#commit/3"},{"type":"type","title":"odbc.common_reason/0","doc":"An explanation of what went wrong. For common errors there will be atom\ndecriptions.","ref":"odbc.html#t:common_reason/0"},{"type":"function","title":"odbc.connect/2","doc":"Opens a connection to the database. The connection is associated with the\nprocess that created it and can only be accessed through it. This function may\nspawn new processes to handle the connection. These processes will terminate if\nthe process that created the connection dies or if you call disconnect/1.\n\nIf automatic commit mode is turned on, each query will be considered as an\nindividual transaction and will be automatically committed after it has been\nexecuted. If you want more than one query to be part of the same transaction the\nautomatic commit mode should be turned off. Then you will have to call commit/3\nexplicitly to end a transaction.\n\nThe default timeout is infinity\n\nIf the option binary_strings is turned on all strings will be returned as\nbinaries and strings inputted to param_query will be expected to be binaries.\nThe user needs to ensure that the binary is in an encoding that the database\nexpects. By default this option is turned off.\n\nAs default result sets are returned as a lists of tuples. The `TupleMode` option\nstill exists to keep some degree of backwards compatibility. If the option is\nset to off, result sets will be returned as a lists of lists instead of a lists\nof tuples.\n\nScrollable cursors are nice but causes some overhead. For some connections speed\nmight be more important than flexible data access and then you can disable\nscrollable cursor for a connection, limiting the API but gaining speed.\n\n> #### Note {: .info }\n>\n> Turning the scrollable_cursors option off is noted to make old odbc-drivers\n> able to connect that will otherwise fail.\n\nIf trace mode is turned on this tells the ODBC driver to write a trace log to\nthe file SQL.LOG that is placed in the current directory of the erlang emulator.\nThis information may be useful if you suspect there might be a bug in the erlang\nODBC application, and it might be relevant for you to send this file to our\nsupport. Otherwise you will probably not have much use of this.\n\n> #### Note {: .info }\n>\n> For more information about the `ConnectStr` see description of the function\n> SQLDriverConnect in \\[1].\n\nThe `extended_errors` option enables extended ODBC error information when an\noperation fails. Rather than returning `{error, Reason}`, the failing function\nwill return `{error, {ODBCErrorCode, NativeErrorCode, Reason}}`. Note that this\ninformation is probably of little use when writing database-independent code,\nbut can be of assistance in providing more sophisticated error handling when\ndealing with a known underlying database.\n\n- `ODBCErrorCode` is the ODBC error string returned by the ODBC driver.\n- `NativeErrorCode` is the numeric error code returned by the underlying\n  database. The possible values and their meanings are dependent on the database\n  being used.\n- `Reason` is as per the `Reason` field when extended errors are not enabled.\n\n> #### Note {: .info }\n>\n> The current implementation spawns a port program written in C that utilizes\n> the actual ODBC driver. There is a default timeout of 5000 msec for this port\n> program to connect to the Erlang ODBC application. This timeout can be changed\n> by setting an application specific environment variable 'port_timeout' with\n> the number of milliseconds for the ODBC application. E.g.: \\[\\{odbc,\n> [\\{port_timeout, 60000\\}]\\}] to set it to 60 seconds.","ref":"odbc.html#connect/2"},{"type":"opaque","title":"odbc.connection_reference/0","doc":"Opaque reference to an ODBC connection as returnded by connect/2.","ref":"odbc.html#t:connection_reference/0"},{"type":"function","title":"odbc.describe_table/2","doc":"Equivalent to  describe_table/3 .","ref":"odbc.html#describe_table/2"},{"type":"function","title":"odbc.describe_table/3","doc":"Queries the database to find out the ODBC data types of the columns of the table\n`Table`.","ref":"odbc.html#describe_table/3"},{"type":"function","title":"odbc.disconnect/1","doc":"Closes a connection to a database. This will also terminate all processes that\nmay have been spawned when the connection was opened. This call will always\nsucceed. If the connection cannot be disconnected gracefully it will be brutally\nkilled. However you may receive an error message as result if you try to\ndisconnect a connection started by another process.","ref":"odbc.html#disconnect/1"},{"type":"type","title":"odbc.extended_error/0","doc":"extended error type with ODBC and native database error codes, as well as the\nbase reason that would have been returned had extended_errors not been enabled.","ref":"odbc.html#t:extended_error/0"},{"type":"function","title":"odbc.first/1","doc":"Equivalent to  first/2 .","ref":"odbc.html#first/1"},{"type":"function","title":"odbc.first/2","doc":"Returns the first row of the result set and positions a cursor at this row.","ref":"odbc.html#first/2"},{"type":"function","title":"odbc.last/1","doc":"Equivalent to  last/2 .","ref":"odbc.html#last/1"},{"type":"function","title":"odbc.last/2","doc":"Returns the last row of the result set and positions a cursor at this row.","ref":"odbc.html#last/2"},{"type":"type","title":"odbc.n_rows/0","doc":"The number of affected rows for UPDATE, INSERT, or DELETE queries. For other\nquery types the value is driver defined, and hence should be ignored.","ref":"odbc.html#t:n_rows/0"},{"type":"function","title":"odbc.next/1","doc":"Equivalent to  next/2 .","ref":"odbc.html#next/1"},{"type":"function","title":"odbc.next/2","doc":"Returns the next row of the result set relative the current cursor position and\npositions the cursor at this row. If the cursor is positioned at the last row of\nthe result set when this function is called the returned value will be\n`{selected, ColNames,[]}` e.i. the list of row values is empty indicating that\nthere is no more data to fetch.","ref":"odbc.html#next/2"},{"type":"type","title":"odbc.odbc_data_type/0","doc":"Data type used by ODBC, to learn which Erlang data type corresponds to an ODBC\ndata type see the Erlang to ODBC data type [mapping](databases.md#type) in the\nUser's Guide.","ref":"odbc.html#t:odbc_data_type/0"},{"type":"function","title":"odbc.param_query/3","doc":"Equivalent to  param_query/4 .","ref":"odbc.html#param_query/3"},{"type":"function","title":"odbc.param_query/4","doc":"Executes a parameterized SQL query. For an example see the\n[\"Using the Erlang API\"](getting_started.md#param_query) in the Erlang ODBC\nUser's Guide.\n\n> #### Note {: .info }\n>\n> Use the function describe_table/\\[2,3] to find out which ODBC data type that\n> is expected for each column of that table. If a column has a data type that is\n> described with capital letters, alas it is not currently supported by the\n> param_query function. To learn which Erlang data type corresponds to an ODBC\n> data type see the Erlang to ODBC data type [mapping](databases.md#type) in the\n> User's Guide.","ref":"odbc.html#param_query/4"},{"type":"function","title":"odbc.prev/1","doc":"Equivalent to  prev/2 .","ref":"odbc.html#prev/1"},{"type":"function","title":"odbc.prev/2","doc":"Returns the previous row of the result set relative the current cursor position\nand positions the cursor at this row.","ref":"odbc.html#prev/2"},{"type":"type","title":"odbc.row/0","doc":"A tuple, with the number of elements selected form columns in a database row,\ncontaing the values of the columns such as `{value(), value() ... value()} `.","ref":"odbc.html#t:row/0"},{"type":"function","title":"odbc.select/3","doc":"Equivalent to  select/4 .","ref":"odbc.html#select/3"},{"type":"function","title":"odbc.select/4","doc":"Selects `N` consecutive rows of the result set. If `Position` is `next` it is\nsemantically equivalent of calling `next/[1,2]` `N` times. If `Position` is\n`{relative, Pos}`, `Pos` will be used as an offset from the current cursor\nposition to determine the first selected row. If `Position` is\n`{absolute, Pos}`, `Pos` will be the number of the first row selected. After\nthis function has returned the cursor is positioned at the last selected row. If\nthere is less then `N` rows left of the result set the length of `Rows` will be\nless than `N`. If the first row to select happens to be beyond the last row of\nthe result set, the returned value will be `{selected, ColNames,[]}` e.i. the\nlist of row values is empty indicating that there is no more data to fetch.","ref":"odbc.html#select/4"},{"type":"function","title":"odbc.select_count/2","doc":"Equivalent to  select_count/3 .","ref":"odbc.html#select_count/2"},{"type":"function","title":"odbc.select_count/3","doc":"Executes a SQL SELECT query and associates the result set with the connection. A\ncursor is positioned before the first row in the result set and the tuple\n`{ok, NrRows}` is returned.\n\n> #### Note {: .info }\n>\n> Some drivers may not have the information of the number of rows in the result\n> set, then `NrRows` will have the value `undefined`.","ref":"odbc.html#select_count/3"},{"type":"type","title":"odbc.selected/0","doc":"Return value for queries that select data from database tabels.","ref":"odbc.html#t:selected/0"},{"type":"function","title":"odbc.sql_query/2","doc":"Equivalent to  sql_query/3 .","ref":"odbc.html#sql_query/2"},{"type":"function","title":"odbc.sql_query/3","doc":"Executes a SQL query or a batch of SQL queries. If it is a SELECT query the\nresult set is returned, on the format `{selected, ColNames, Rows}`. For other\nquery types the tuple `{updated, NRows}` is returned, and for batched queries,\nif the driver supports them, this function can also return a list of result\ntuples.\n\n> #### Note {: .info }\n>\n> Some drivers may not have the information of the number of affected rows\n> available and then the return value may be `{updated, undefined} `.\n>\n> The list of column names is ordered in the same way as the list of values of a\n> row, e.g. the first `ColName` is associated with the first `Value` in a `Row`.","ref":"odbc.html#sql_query/3"},{"type":"function","title":"odbc.start/0","doc":"Equivalent to  start/1 .","ref":"odbc.html#start/0"},{"type":"function","title":"odbc.start/1","doc":"Starts the odbc application. Default type is temporary.\n[See application(3)](`m:application`)","ref":"odbc.html#start/1"},{"type":"function","title":"odbc.stop/0","doc":"Stops the odbc application. [See application(3)](`m:application`)","ref":"odbc.html#stop/0"},{"type":"type","title":"odbc.updated/0","doc":"Return value for queries that update database tables.","ref":"odbc.html#t:updated/0"},{"type":"type","title":"odbc.value/0","doc":"Erlang data type that corresponds to the ODBC data type being handled.","ref":"odbc.html#t:value/0"},{"type":"extras","title":"ODBC Release Notes","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# ODBC Release Notes\n\nThis document describes the changes made to the odbc application.","ref":"notes.html"},{"type":"extras","title":"ODBC 2.16 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-16"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Enhance specs of timeout for improving documentation and dialyzer analysis.\n\n  Own Id: OTP-19604 Aux Id: [PR-9574]\n\n[PR-9574]: https://github.com/erlang/otp/pull/9574","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Updated odbc configure to enable easier use of iodbc driver.\n\n  Own Id: OTP-19456 Aux Id: [PR-9083]\n\n- Added support for compiling Erlang/OTP for Windows on ARM64.\n\n  Own Id: OTP-19480 Aux Id: [PR-8734]\n\n- When compiling C/C++ code on Unix systems, the compiler hardening flags suggested by the [Open Source Security Foundation](https://github.com/ossf/wg-best-practices-os-developers/blob/main/docs/Compiler-Hardening-Guides/Compiler-Options-Hardening-Guide-for-C-and-C%2B%2B.md) are now enabled by default. To disable them, pass `--disable-security-hardening-flags` to `configure`.\n\n  Own Id: OTP-19519 Aux Id: [PR-9441]\n\n- The license and copyright header has changed format to include an `SPDX-License-Identifier`. At the same time, most files have been updated to follow a uniform standard for license headers.\n\n  Own Id: OTP-19575 Aux Id: [PR-9670]\n\n[PR-9083]: https://github.com/erlang/otp/pull/9083\n[PR-8734]: https://github.com/erlang/otp/pull/8734\n[PR-9441]: https://github.com/erlang/otp/pull/9441\n[PR-9670]: https://github.com/erlang/otp/pull/9670","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"ODBC 2.15 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-15"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Figures in the documentation have been improved.\n\n  Own Id: OTP-19130 Aux Id: [PR-7226]\n\n[PR-7226]: https://github.com/erlang/otp/pull/7226","ref":"notes.html#improvements-and-new-features-1"},{"type":"extras","title":"ODBC 2.14.3 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-14-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- The order of libs in the Makefile has been changed to avoid finding the system's `libei` instead of Erlang's `libei`.\n\n  Own Id: OTP-19030 Aux Id: [GH-8244], [PR-8258]\n\n[GH-8244]: https://github.com/erlang/otp/issues/8244\n[PR-8258]: https://github.com/erlang/otp/pull/8258","ref":"notes.html#fixed-bugs-and-malfunctions-1"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features-2"},{"type":"extras","title":"ODBC 2.14.2 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-14-2"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"* Use spec for API doc\n\n  Own Id: OTP-18926","ref":"notes.html#improvements-and-new-features-3"},{"type":"extras","title":"ODBC 2.14.1 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-14-1"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Allow larger column sizes than 8001 in case DB supports it.\n\n  Own Id: OTP-18539","ref":"notes.html#improvements-and-new-features-4"},{"type":"extras","title":"ODBC 2.14 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-14"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Input for `configure` scripts adapted to `autoconf` 2\\.71.\n\n  Own Id: OTP-17414 Aux Id: PR-4967","ref":"notes.html#improvements-and-new-features-5"},{"type":"extras","title":"ODBC 2.13.5 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-13-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions-2"},{"type":"extras","title":"ODBC 2.13.4 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-13-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Fix compiler warnings produced by the clang compiler.\n\n  Own Id: OTP-17105 Aux Id: PR-2872","ref":"notes.html#fixed-bugs-and-malfunctions-3"},{"type":"extras","title":"ODBC 2.13.3.1 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-13-3-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions-4"},{"type":"extras","title":"ODBC 2.13.3 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-13-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Make sure odbc c-process exits when erlang process orders it to shutdown.\n\n  Own Id: OTP-17188 Aux Id: ERL-1448","ref":"notes.html#fixed-bugs-and-malfunctions-5"},{"type":"extras","title":"ODBC 2.13.2 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-13-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Fixed usage of `AC_CONFIG_AUX_DIRS()` macros in configure script sources.\n\n  Own Id: OTP-17093 Aux Id: ERL-1447, PR-2948","ref":"notes.html#fixed-bugs-and-malfunctions-6"},{"type":"extras","title":"ODBC 2.13.1 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-13-1"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Changes in order to build on the Haiku operating system.\n\n  Thanks to Calvin Buckley\n\n  Own Id: OTP-16707 Aux Id: PR-2638","ref":"notes.html#improvements-and-new-features-6"},{"type":"extras","title":"ODBC 2.13 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Fix various compiler warnings on 64-bit Windows.\n\n  Own Id: OTP-15800","ref":"notes.html#fixed-bugs-and-malfunctions-7"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Rewrite due to the removal of `erl_interface` legacy functions.\n\n  Own Id: OTP-16544 Aux Id: OTP-16328","ref":"notes.html#improvements-and-new-features-7"},{"type":"extras","title":"ODBC 2.12.4.1 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-12-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions-8"},{"type":"extras","title":"ODBC 2.12.4 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-12-4"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Minor adjustments made to build system for parallel configure.\n\n  Own Id: OTP-15340 Aux Id: OTP-14625","ref":"notes.html#improvements-and-new-features-8"},{"type":"extras","title":"ODBC 2.12.3 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-12-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Enhance error handling to avoid stack corruption\n\n  Own Id: OTP-15667 Aux Id: ERL-808, PR-2065","ref":"notes.html#fixed-bugs-and-malfunctions-9"},{"type":"extras","title":"ODBC 2.12.2 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-12-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions-10"},{"type":"extras","title":"ODBC 2.12.1 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-12-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions-11"},{"type":"extras","title":"ODBC 2.12 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-12"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Change configure to skip odbc for old MACs, the change in PR-1227 is not\n  backwards compatible with old MACs, and we do not see a need to continue\n  support for such old versions. However it is still possible to make it work on\n  such machines using the --with-odbc configure option.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-14083","ref":"notes.html#improvements-and-new-features-9"},{"type":"extras","title":"ODBC 2.11.3 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-11-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- ODBC build configure has been updated to accept Mac OS X El Capitan. Fixed by\n  Lee Bannard.\n\n  Own Id: OTP-13781","ref":"notes.html#fixed-bugs-and-malfunctions-12"},{"type":"extras","title":"ODBC 2.11.2 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-11-2"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Configure enhancement for better handling program paths used in the build\n  process\n\n  Own Id: OTP-13559","ref":"notes.html#improvements-and-new-features-10"},{"type":"extras","title":"ODBC 2.11.1 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-11-1"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- New application variable to set timeout of internal communication setup\n  between the erlang code and the c-port program that interfaces the odbc\n  driver. This can be useful if you have an underlying system that is slow due\n  to heavy load at startup.\n\n  With this environment variable you can easily bypass and tailor odbc to the\n  needs of the underlying actual system without changing the configuration.\n  Which is a good thing because this value is very system specific.\n\n  Own Id: OTP-12935","ref":"notes.html#improvements-and-new-features-11"},{"type":"extras","title":"ODBC 2.11 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-11"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Change license text from Erlang Public License to Apache Public License v2\n\n  Own Id: OTP-12845","ref":"notes.html#improvements-and-new-features-12"},{"type":"extras","title":"ODBC 2.10.22 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-22"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- OS X Mavericks is based on Darwin version 13.x, and Yosemite on 14.x. Change\n  the ODBC configure.in script to recognize these versions.\n\n  Own Id: OTP-12260","ref":"notes.html#fixed-bugs-and-malfunctions-13"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- The commands longer than 127 chars sent to odbc server crashed it, e.g. a\n  connection string with driver path and some additional parameters.\n\n  Own Id: OTP-12346\n\n- Distribute `autoconf` helpers to applications at build time instead of having\n  multiple identical copies committed in the repository.\n\n  Own Id: OTP-12348","ref":"notes.html#improvements-and-new-features-13"},{"type":"extras","title":"ODBC 2.10.21 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-21"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Fix compiler warnings reported by LLVM\n\n  Own Id: OTP-12138\n\n- Implement --enable-sanitizers\\[=sanitizers]. Similar to debugging with\n  Valgrind, it's very useful to enable -fsanitize= switches to catch bugs at\n  runtime.\n\n  Own Id: OTP-12153","ref":"notes.html#fixed-bugs-and-malfunctions-14"},{"type":"extras","title":"ODBC 2.10.20 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-20"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Application upgrade (appup) files are corrected for the following\n  applications:\n\n  `asn1, common_test, compiler, crypto, debugger, dialyzer, edoc, eldap, erl_docgen, et, eunit, gs, hipe, inets, observer, odbc, os_mon, otp_mibs, parsetools, percept, public_key, reltool, runtime_tools, ssh, syntax_tools, test_server, tools, typer, webtool, wx, xmerl`\n\n  A new test utility for testing appup files is added to test_server. This is\n  now used by most applications in OTP.\n\n  (Thanks to Tobias Schlager)\n\n  Own Id: OTP-11744","ref":"notes.html#fixed-bugs-and-malfunctions-15"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Removed warnings at compile time by adding missing include file (Thanks to\n  Anthony Ramine)\n\n  Own Id: OTP-11569\n\n- Apple has removed iODBC in OS X 10.9 Mavericks, but forgot to remove all\n  binaries, adopt configure so that will be possible to build odbc with own\n  installation.\n\n  Own Id: OTP-11630","ref":"notes.html#improvements-and-new-features-14"},{"type":"extras","title":"ODBC 2.10.19 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-19"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Updated configure test for header files sql.h and sqlext.h to function\n  correctly on windows.\n\n  Own Id: OTP-11574","ref":"notes.html#fixed-bugs-and-malfunctions-16"},{"type":"extras","title":"ODBC 2.10.18 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-18"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Configure now also checks for the existence of the sql.h header file\n\n  Own Id: OTP-11483","ref":"notes.html#improvements-and-new-features-15"},{"type":"extras","title":"ODBC 2.10.17 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-17"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- The format of the xml source for documentation is corrected in order to\n  conform to the DTDs and to pass xmllint without errors.\n\n  Own Id: OTP-11193","ref":"notes.html#fixed-bugs-and-malfunctions-17"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Introduced functionality for inspection of system and build configuration.\n\n  Own Id: OTP-11196\n\n- Prevent odbcserver crash if it's executed and supplied incorrect data to\n  stdin. Thanks to Sergei Golovan.\n\n  Own Id: OTP-11233","ref":"notes.html#improvements-and-new-features-16"},{"type":"extras","title":"ODBC 2.10.16 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-16"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Fix a 64bit related bug in odbcserver. Thanks to Satoshi Kinoshita.\n\n  Own Id: OTP-10993\n\n- Postscript files no longer needed for the generation of PDF files have been\n  removed.\n\n  Own Id: OTP-11016\n\n- Fix checking for odbc in standard locations when \"with-odbc\" flag present.\n  Thanks to Alexey Saltanov.\n\n  Own Id: OTP-11126","ref":"notes.html#improvements-and-new-features-17"},{"type":"extras","title":"ODBC 2.10.15 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-15"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Fixed calling odbc:param_query/3 and odbc:param_query/4 with unparameterized\n  query string and empty parameters list. Thanks to Danil Onishchenko.\n\n  Own Id: OTP-10798","ref":"notes.html#improvements-and-new-features-18"},{"type":"extras","title":"ODBC 2.10.14 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-14"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Under Unix enable TCP_NODELAY to disable Nagel's socket algorithm. Thanks to\n  Andy Richards\n\n  Impact: Performance gain on Unix systems\n\n  Own Id: OTP-10506\n\n- Added extended_errors option to ODBC\n\n  When enabled, this option alters the return code of ODBC operations that\n  produce errors to include the ODBC error code as well as the native error\n  code, in addition to the ODBC reason field which is returned by default.\n  Thanks to Bernard Duggan.\n\n  Own Id: OTP-10603\n\n- Where necessary a comment stating encoding has been added to Erlang files. The\n  comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630\n\n- Some examples overflowing the width of PDF pages have been corrected.\n\n  Own Id: OTP-10665\n\n- Fix aotocommit for Oracle ODBC driver in Linux. Thanks to Danil Onishchenko.\n\n  Own Id: OTP-10735","ref":"notes.html#improvements-and-new-features-19"},{"type":"extras","title":"ODBC 2.10.13 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-13"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Add support for NULL value in odbc:param_query\n\n  Support atom 'null' in odbc:param_query as database NULL value Fix \"ODBC:\n  received unexpected info:\\{tcp_closed, ...\\}\" when connection is terminated.\n  Fix possible access violation with 64bit ODBC. Thanks to Maxim Zrazhevskiy\n\n  Own Id: OTP-10206","ref":"notes.html#fixed-bugs-and-malfunctions-18"},{"type":"extras","title":"ODBC 2.10.12 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-12"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- An ODBC process should exit normally if its client exits with 'shutdown'\n\n  There is nothing strange about the client shutting down, so the ODBC process\n  should exit normally to avoid generating a crash report for a non-problem.\n  (Thanks to Magnus Henoch)\n\n  Own Id: OTP-9716","ref":"notes.html#fixed-bugs-and-malfunctions-19"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Erlang/OTP can now be built using parallel make if you limit the number of\n  jobs, for instance using '`make -j6`' or '`make -j10`'. '`make -j`' does not\n  work at the moment because of some missing dependencies.\n\n  Own Id: OTP-9451","ref":"notes.html#improvements-and-new-features-20"},{"type":"extras","title":"ODBC 2.10.11 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-11"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- When using output parameters the internal odbc state was not correctly cleaned\n  causing the next call to param_query to misbehave.\n\n  Own Id: OTP-9444\n\n- XML files have been corrected.\n\n  Own Id: OTP-9550 Aux Id: OTP-9541","ref":"notes.html#fixed-bugs-and-malfunctions-20"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Add code to handle old ODBC drivers on solaris. Also adds tests with MySQL.\n\n  Own Id: OTP-8407\n\n- Odbc now supports SQL_WLONGVARCHAR, thanks to Hanfei Shen for the patch.\n\n  Own Id: OTP-8493","ref":"notes.html#improvements-and-new-features-21"},{"type":"extras","title":"ODBC 2.10.10 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-10"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Better error messages for connection issues.\n\n  Own Id: OTP-9111","ref":"notes.html#fixed-bugs-and-malfunctions-21"},{"type":"extras","title":"ODBC 2.10.9 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-9"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Ipv6 is now supported on Windows as well as on UNIX for internal socket\n  communication. (ODBC uses sockets instead of the \"Erlang port pipes\" as some\n  ODBC-drivers are known to mess with stdin/stdout.)\n\n  Loopback address constants are used when connecting the c-side to the\n  erlang-side over local socket API avoiding getaddrinfo problems, and the \\{ip,\n  loopback\\} option is added as a listen option on the erlang-side. Also cleaned\n  up the TIME_STAMP contribution.\n\n  Own Id: OTP-8917","ref":"notes.html#improvements-and-new-features-22"},{"type":"extras","title":"ODBC 2.10.8 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-8"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- ODBC now handles the types SQL_WCHAR and SQL_WVARCHAR. Thanks to Juhani\n  Ränkimies. ODBC also has a new connection option to return all strings as\n  binaries and also expect strings to be binaries in the param_query function.\n  These changes provides some unicode support.\n\n  Own Id: OTP-7452\n\n- Now supports SQL_TYPE_TIMESTAMP on the format \\{\\{YY, MM, DD\\}, \\{HH, MM,\n  SS\\}\\}. Thanks to Juhani Ränkimies.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8511","ref":"notes.html#improvements-and-new-features-23"},{"type":"extras","title":"ODBC 2.10.7 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- The odbc application can now be compiled on FreeBSD. (Thanks to Kenji\n  Rikitake.)\n\n  Own Id: OTP-8444","ref":"notes.html#fixed-bugs-and-malfunctions-22"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Cross compilation improvements and other build system improvements.\n\n  Most notable:\n\n  - Lots of cross compilation improvements. The old cross compilation support\n    was more or less non-existing as well as broken. Please, note that the cross\n    compilation support should still be considered as experimental. Also note\n    that old cross compilation configurations cannot be used without\n    modifications. For more information on cross compiling Erlang/OTP see the\n    `$ERL_TOP/INSTALL-CROSS.md` file.\n  - Support for staged install using\n    [DESTDIR](http://www.gnu.org/prep/standards/html_node/DESTDIR.html). The old\n    broken `INSTALL_PREFIX` has also been fixed. For more information see the\n    `$ERL_TOP/INSTALL.md` file.\n  - Documentation of the `release` target of the top `Makefile`. For more\n    information see the `$ERL_TOP/INSTALL.md` file.\n  - `make install` now by default creates relative symbolic links instead of\n    absolute ones. For more information see the `$ERL_TOP/INSTALL.md` file.\n  - `$ERL_TOP/configure --help=recursive` now works and prints help for all\n    applications with `configure` scripts.\n  - Doing `make install`, or `make release` directly after `make all` no longer\n    triggers miscellaneous rebuilds.\n  - Existing bootstrap system is now used when doing `make install`, or\n    `make release` without a preceding `make all`.\n  - The `crypto` and `ssl` applications use the same runtime library path when\n    dynamically linking against `libssl.so` and `libcrypto.so`. The runtime\n    library search path has also been extended.\n  - The `configure` scripts of `erl_interface` and `odbc` now search for thread\n    libraries and thread library quirks the same way as ERTS do.\n  - The `configure` script of the `odbc` application now also looks for odbc\n    libraries in `lib64` and `lib/64` directories when building on a 64-bit\n    system.\n  - The `config.h.in` file in the `erl_interface` application is now\n    automatically generated in instead of statically updated which reduces the\n    risk of `configure` tests without any effect.\n\n  (Thanks to Henrik Riomar for suggestions and testing)\n\n  (Thanks to Winston Smith for the AVR32-Linux cross configuration and testing)\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-8323\n\n- The documentation is now possible to build in an open source environment after\n  a number of bugs are fixed and some features are added in the documentation\n  build process.\n\n  \\- The arity calculation is updated.\n\n  \\- The module prefix used in the function names for bif's are removed in the\n  generated links so the links will look like\n  \"http://www.erlang.org/doc/man/erlang.html#append_element-2\" instead of\n  \"http://www.erlang.org/doc/man/erlang.html#erlang:append_element-2\".\n\n  \\- Enhanced the menu positioning in the html documentation when a new page is\n  loaded.\n\n  \\- A number of corrections in the generation of man pages (thanks to Sergei\n  Golovan)\n\n  \\- The legal notice is taken from the xml book file so OTP's build process can\n  be used for non OTP applications.\n\n  Own Id: OTP-8343\n\n- odbc:param_query() now properly indicates if nothing was updated. (Thanks to\n  Paul Oliver.)\n\n  Own Id: OTP-8347","ref":"notes.html#improvements-and-new-features-24"},{"type":"extras","title":"Known Bugs and Problems - ODBC Release Notes","doc":"- The ODBC test cases are failing for linux and MacOSX There is problems with\n  setting of options on odbc-connections, and the odbcserver just exits with an\n  exit code.\n\n  Own Id: OTP-8407","ref":"notes.html#known-bugs-and-problems"},{"type":"extras","title":"ODBC 2.10.6 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Applied a patch from Andrew Thompson, which fixes some error cases.\n\n  Own Id: OTP-8291","ref":"notes.html#fixed-bugs-and-malfunctions-23"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- The documentation is now built with open source tools (xsltproc and fop) that\n  exists on most platforms. One visible change is that the frames are removed.\n\n  Own Id: OTP-8250","ref":"notes.html#improvements-and-new-features-25"},{"type":"extras","title":"ODBC 2.10.5 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- A missing return statement in a non void function has been fixed in `odbc`.\n  (Thanks to Nico Kruber)\n\n  Own Id: OTP-7978","ref":"notes.html#fixed-bugs-and-malfunctions-24"},{"type":"extras","title":"ODBC 2.10.4 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-4"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- param_query now handles the in_or_out parameter correctly.\n\n  Own Id: OTP-7720\n\n- Changed the internal socket use so that it will become more robust to\n  non-functional ipv6 and fallback on ipv4.\n\n  Own Id: OTP-7721","ref":"notes.html#improvements-and-new-features-26"},{"type":"extras","title":"ODBC 2.10.3 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-3"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Configure update for mac.\n\n  Own Id: OTP-7418","ref":"notes.html#improvements-and-new-features-27"},{"type":"extras","title":"Known Bugs and Problems - ODBC Release Notes","doc":"- describe_table/\\[2,3] on mac gives an empty result\n\n  Own Id: OTP-7478","ref":"notes.html#known-bugs-and-problems-1"},{"type":"extras","title":"ODBC 2.10.2 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- SQLINTEGERs where not retrieved correctly on 64 bit platforms as an SQLINTEGER\n  is defined to be a 32 bit integer and not a true long.\n\n  Own Id: OTP-7297","ref":"notes.html#fixed-bugs-and-malfunctions-25"},{"type":"extras","title":"ODBC 2.10.1 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10-1"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Now supports out and input parameters for stored procedures.\n\n  Own Id: OTP-7019\n\n- ODBC is now prebuilt for SLES10 in the commercial build and parameters to\n  error_logger:error_report/1 has been corrected.\n\n  Own Id: OTP-7294\n\n- Parametrized queries will now work correctly when using Erlang R12B-2 on Linux\n  (SuSE 10.3), MySQL 5.0.45, myodbc 3.51 and unixODBC 2.2.12. Earlier it could\n  happen that an error was returned even though data was correctly inserted into\n  the database.\n\n  Own Id: OTP-7307","ref":"notes.html#improvements-and-new-features-28"},{"type":"extras","title":"Known Bugs and Problems - ODBC Release Notes","doc":"- SQLINTEGERs are not retrieved correctly on 64 bit platforms as an SQLINTEGER\n  seems to be defined to be a 32 bit integer and not a true long.\n\n  Own Id: OTP-7297","ref":"notes.html#known-bugs-and-problems-2"},{"type":"extras","title":"ODBC 2.10 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-10"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Enhanced configure to among other things work better when there is a library\n  found but it is not usable e.i. 32 bit library in 64 bit build.\n\n  Own Id: OTP-7062","ref":"notes.html#improvements-and-new-features-29"},{"type":"extras","title":"ODBC 2.0.9 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0-9"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- The odbc application now has to be explicitly started and stopped e.i. it will\n  not automatically be started as a temporary application as it did before.\n  Although a practical feature when testing things in the shell, it is not\n  desirable that people take advantage of this and not start the odbc\n  application in a correct way in their products. Added functions to the odbc\n  API that calls application:start/stop.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-6984\n\n- Changed Makefile.in so that odbc is not disabled on 64-bits architectures. It\n  was earlier disabled due to that it had never been tested in that environment.\n\n  Own Id: OTP-6987","ref":"notes.html#improvements-and-new-features-30"},{"type":"extras","title":"ODBC 2.0.8 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0-8"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Minor Makefile changes.\n\n  Own Id: OTP-6689","ref":"notes.html#improvements-and-new-features-31"},{"type":"extras","title":"ODBC 2.0.7 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- When using a parameterized query on a windows platform the data was inserted\n  in the table on the sql-server but the connection was lost, this seems to be\n  due to a compiler error that has now been worked around, but further\n  investigation is ongoing to verify that that really was the problem.\n\n  Own Id: OTP-5504\n\n- param_query/\\[3,4] could return an unexpected row count for some drivers, in\n  this case a postgresdriver.\n\n  Own Id: OTP-6363","ref":"notes.html#fixed-bugs-and-malfunctions-26"},{"type":"extras","title":"ODBC 2.0.6 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- pthread header and library mismatch on linux systems (at least some SuSE and\n  Debian) with both NPTL and Linuxthreads libraries installed.\n\n  Own Id: OTP-5981","ref":"notes.html#fixed-bugs-and-malfunctions-27"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Changed configure to find odbc in /usr/local too\n\n  Own Id: OTP-5966","ref":"notes.html#improvements-and-new-features-32"},{"type":"extras","title":"Known Bugs and Problems - ODBC Release Notes","doc":"- When using a parameterized query on a windows platform the data is inserted in\n  the table on the sql-server but for some reason the connection is lost.\n\n  Own Id: OTP-5504","ref":"notes.html#known-bugs-and-problems-3"},{"type":"extras","title":"ODBC 2.0.5 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- Fixed bug, reported error when deleting nonexisting rows, thanks to Laura M.\n  Castro for reporting this.\n\n  Own Id: OTP-5759","ref":"notes.html#fixed-bugs-and-malfunctions-28"},{"type":"extras","title":"Known Bugs and Problems - ODBC Release Notes","doc":"- When using a parameterized query on a windows platform the data is inserted in\n  the table on the sql-server but for some reason the connection is lost.\n\n  Own Id: OTP-5504","ref":"notes.html#known-bugs-and-problems-4"},{"type":"extras","title":"Odbc 2.0.4 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0-4"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- /usr was added as a default place for configure to look for the odbc library\n  on unix/linux platforms.\n\n  Own Id: OTP-5501\n\n- A legacy timer in the c port program was set to infinity. All timeout handling\n  is handled by the erlang code and a extra timeout in the c code will just lead\n  to confusion if it is released.\n\n  Own Id: OTP-5502","ref":"notes.html#improvements-and-new-features-33"},{"type":"extras","title":"Known Bugs and Problems - ODBC Release Notes","doc":"- When using a parameterized query on a windows platform the data is inserted in\n  the table on the sql-server but for some reason the connection is lost.\n\n  Own Id: OTP-5504","ref":"notes.html#known-bugs-and-problems-5"},{"type":"extras","title":"Odbc 2.0.3 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0-3"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- odbc now uses configure as all \"normal\" applications instead of providing\n  special Makefiles for each commercial supported platform. This also makes it\n  easier to build odbc on non supported platforms.\n\n  Own Id: OTP-5437","ref":"notes.html#improvements-and-new-features-34"},{"type":"extras","title":"odbc 2.0.2 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - ODBC Release Notes","doc":"- When issuing a batch of queries and one of the queries fail the odbc port\n  program crashed. This is no longer the case.\n\n  Own Id: OTP-5176","ref":"notes.html#fixed-bugs-and-malfunctions-29"},{"type":"extras","title":"odbc 2.0.1 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0-1"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Added use of the socket option TCP_NODELAY, as in the case of Erlang odbc the\n  Nagel algorithm will never help, but always cause an unnecessary delay.\n\n  Own Id: OTP-5100","ref":"notes.html#improvements-and-new-features-35"},{"type":"extras","title":"odbc 2.0 - ODBC Release Notes","doc":"","ref":"notes.html#odbc-2-0"},{"type":"extras","title":"Improvements and New Features - ODBC Release Notes","doc":"- Erlang ODBC now handles batches of queries and can return multiple result\n  sets.\n\n  Own Id: OTP-4642 Aux Id: seq7766\n\n- The old interface that became deprecated in odbc 1.0 has now been removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-4794\n\n- The port program now sends different exit codes to Erlang when it exits due to\n  failure. This instead of sending the same exit code and then trying to write\n  to stderr. Erlang encodes the exit code to a descriptive atom.\n\n  Own Id: OTP-4813\n\n- Erlang ODBC now supports parameterized queries for the most common ODBC data\n  types.\n\n  Own Id: OTP-4821\n\n- SQL_NUMERIC and SQL_DECIMAL columns are converted to integer and float values\n  if possible.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-4826\n\n- Result sets are now by default returned as a list of tuples which is the most\n  intuitive and useful mapping. To keep some degree of backwards compatibility\n  you may turn this off to get the old behavior that result sets are returned as\n  lists of lists. However do not use this in new code as it is considered a\n  deprecated feature that eventually will disappear.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-4850\n\n- The odbc implementation now mostly uses sockets to communicate between the c\n  and the erlang process, this is to avoid a lot of problems arising from\n  different odbc-drivers doing strange things that disturbed the port-program\n  communication mechanism.\n\n  Own Id: OTP-4875","ref":"notes.html#improvements-and-new-features-36"},{"type":"extras","title":"Overview","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Overview","ref":"introduction.html"},{"type":"extras","title":"Purpose - Overview","doc":"The purpose of the Erlang ODBC application is to provide the programmer with an\nODBC interface that has a Erlang/OTP touch and feel. So that the programmer may\nconcentrate on solving his/her actual problem instead of struggling with\npointers and memory allocation which is not very relevant for Erlang. This user\nguide will give you some information about technical issues and provide some\nexamples of how to use the Erlang ODBC interface.","ref":"introduction.html#purpose"},{"type":"extras","title":"About ODBC - Overview","doc":"Open Database Connectivity (ODBC) is a Microsoft standard for accessing\nrelational databases that has become widely used. The ODBC standard provides a\nc-level application programming interface (API) for database access. It uses\nStructured Query Language (SQL) as its database access language.","ref":"introduction.html#about-odbc"},{"type":"extras","title":"About the Erlang ODBC application - Overview","doc":"Provides an Erlang interface to communicate with relational SQL-databases. It is\nbuilt on top of Microsofts ODBC interface and therefore requires that you have\nan ODBC driver to the database that you want to connect to. The Erlang ODBC\napplication is designed using the version 3.0 of the ODBC-standard, however\nusing the option `{scrollable_cursors, off} `for a connection has been known to\nmake it work for at least some 2.X drivers.","ref":"introduction.html#about-the-erlang-odbc-application"},{"type":"extras","title":"Examples","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Examples","ref":"getting_started.html"},{"type":"extras","title":"Setting things up - Examples","doc":"As the Erlang ODBC application is dependent on third party products there are a\nfew administrative things that needs to be done before you can get things up and\nrunning.\n\n- The first thing you need to do, is to make sure you have an ODBC driver\n  installed for the database that you want to access. Both the client machine\n  where you plan to run your erlang node and the server machine running the\n  database needs the the ODBC driver. (In some cases the client and the server\n  may be the same machine).\n- Secondly you might need to set environment variables and paths to appropriate\n  values. This may differ a lot between different os's, databases and ODBC\n  drivers. This is a configuration problem related to the third party product\n  and hence we cannot give you a standard solution in this guide.\n- The Erlang ODBC application consists of both `Erlang` and `C` code. The `C`\n  code is delivered as a precompiled executable for windows, solaris and linux\n  (SLES10) in the commercial build. In the open source distribution it is built\n  the same way as all other application using configure and make. You may want\n  to provide the the path to your ODBC libraries using --with-odbc=PATH.\n\n> #### Note {: .info }\n>\n> The Erlang ODBC application should run on all Unix dialects including Linux,\n> Windows 2000, Windows XP and NT. But currently it is only tested for Solaris,\n> Windows 2000, Windows XP and NT.","ref":"getting_started.html#setting-things-up"},{"type":"extras","title":"Using the Erlang API - Examples","doc":"The following dialog within the Erlang shell illustrates the functionality of\nthe Erlang ODBC interface. The table used in the example does not have any\nrelevance to anything that exist in reality, it is just a simple example. The\nexample was created using `sqlserver 7.0 with servicepack 1` as database and the\nODBC driver for `sqlserver` with version `2000.80.194.00`.\n\n```text\n 1 > odbc:start().\n      ok\n```\n\nConnect to the database\n\n```erlang\n 2 > {ok, Ref} = odbc:connect(\"DSN=sql-server;UID=aladdin;PWD=sesame\", []).\n      {ok,<0.342.0>}\n```\n\nCreate a table\n\n```text\n 3 > odbc:sql_query(Ref, \"CREATE TABLE EMPLOYEE (NR integer,\n      FIRSTNAME  char varying(20), LASTNAME  char varying(20), GENDER char(1),\n      PRIMARY KEY(NR))\").\n      {updated,undefined}\n```\n\nInsert some data\n\n```text\n 4 > odbc:sql_query(Ref, \"INSERT INTO EMPLOYEE VALUES(1, 'Jane', 'Doe', 'F')\").\n      {updated,1}\n```\n\nCheck what data types the database assigned for the columns. Hopefully this is\nnot a surprise, some times it can be\\! These are the data types that you should\nuse if you want to do a parameterized query.\n\n```erlang\n 5 > odbc:describe_table(Ref, \"EMPLOYEE\").\n      {ok, [{\"NR\", sql_integer},\n            {\"FIRSTNAME\", {sql_varchar, 20}},\n            {\"LASTNAME\", {sql_varchar, 20}}\n            {\"GENDER\", {sql_char, 1}}]}\n```\n\n[](){: #param_query } Use a parameterized query to insert many rows in one go.\n\n```erlang\n 6 > odbc:param_query(Ref,\"INSERT INTO EMPLOYEE (NR, FIRSTNAME, \"\n                  \"LASTNAME, GENDER) VALUES(?, ?, ?, ?)\",\n                   [{sql_integer,[2,3,4,5,6,7,8]},\n                    {{sql_varchar, 20},\n                             [\"John\", \"Monica\", \"Ross\", \"Rachel\",\n                             \"Piper\", \"Prue\", \"Louise\"]},\n                   {{sql_varchar, 20},\n                             [\"Doe\",\"Geller\",\"Geller\", \"Green\",\n                              \"Halliwell\", \"Halliwell\", \"Lane\"]},\n                   {{sql_char, 1}, [\"M\",\"F\",\"M\",\"F\",\"F\",\"F\",\"F\"]}]).\n      {updated, 7}\n```\n\nFetch all data in the table employee\n\n```erlang\n 7> odbc:sql_query(Ref, \"SELECT * FROM EMPLOYEE\").\n    {selected,[\"NR\",\"FIRSTNAME\",\"LASTNAME\",\"GENDER\"],\n          [{1,\"Jane\",\"Doe\",\"F\"},\n           {2,\"John\",\"Doe\",\"M\"},\n           {3,\"Monica\",\"Geller\",\"F\"},\n           {4,\"Ross\",\"Geller\",\"M\"},\n           {5,\"Rachel\",\"Green\",\"F\"},\n           {6,\"Piper\",\"Halliwell\",\"F\"},\n           {7,\"Prue\",\"Halliwell\",\"F\"},\n           {8,\"Louise\",\"Lane\",\"F\"}]]}\n```\n\nAssociate a result set containing the whole table `EMPLOYEE` to the connection.\nThe number of rows in the result set is returned.\n\n```erlang\n 8 > odbc:select_count(Ref, \"SELECT * FROM EMPLOYEE\").\n      {ok,8}\n```\n\nYou can always traverse the result set sequential by using next\n\n```erlang\n 9 > odbc:next(Ref).\n      {selected,[\"NR\",\"FIRSTNAME\",\"LASTNAME\",\"GENDER\"],[{1,\"Jane\",\"Doe\",\"F\"}]}\n```\n\n```erlang\n 10 > odbc:next(Ref).\n      {selected,[\"NR\",\"FIRSTNAME\",\"LASTNAME\",\"GENDER\"],[{2,\"John\",\"Doe\",\"M\"}]}\n```\n\nIf your driver supports scrollable cursors you have a little more freedom, and\ncan do things like this.\n\n```erlang\n 11 > odbc:last(Ref).\n      {selected,[\"NR\",\"FIRSTNAME\",\"LASTNAME\",\"GENDER\"],[{8,\"Louise\",\"Lane\",\"F\"}]}\n```\n\n```erlang\n 12 > odbc:prev(Ref).\n      {selected,[\"NR\",\"FIRSTNAME\",\"LASTNAME\",\"GENDER\"],[{7,\"Prue\",\"Halliwell\",\"F\"}]}\n```\n\n```erlang\n 13 > odbc:first(Ref).\n      {selected,[\"NR\",\"FIRSTNAME\",\"LASTNAME\",\"GENDER\"],[{1,\"Jane\",\"Doe\",\"F\"}]}\n```\n\n```erlang\n 14 > odbc:next(Ref).\n      {selected,[\"NR\",\"FIRSTNAME\",\"LASTNAME\",\"GENDER\"],[{2,\"John\",\"Doe\",\"M\"}]}\n```\n\nFetch the fields `FIRSTNAME `and `NR `for all female employees\n\n```erlang\n 15 > odbc:sql_query(Ref, \"SELECT FIRSTNAME, NR FROM EMPLOYEE WHERE GENDER = 'F'\").\n     {selected,[\"FIRSTNAME\",\"NR\"],\n          [{\"Jane\",1},\n           {\"Monica\",3},\n           {\"Rachel\",5},\n           {\"Piper\",6},\n           {\"Prue\",7},\n           {\"Louise\",8}]}\n```\n\nFetch the fields `FIRSTNAME `and `NR `for all female employees and sort them on\nthe field `FIRSTNAME `.\n\n```erlang\n 16 > odbc:sql_query(Ref, \"SELECT FIRSTNAME, NR FROM EMPLOYEE WHERE GENDER = 'F'\n      ORDER BY FIRSTNAME\").\n    {selected,[\"FIRSTNAME\",\"NR\"],\n          [{\"Jane\",1},\n           {\"Louise\",8},\n           {\"Monica\",3},\n           {\"Piper\",6},\n           {\"Prue\",7},\n           {\"Rachel\",5}]}\n```\n\nAssociate a result set that contains the fields `FIRSTNAME` and `NR `for all\nfemale employees to the connection. The number of rows in the result set is\nreturned.\n\n```erlang\n 17 > odbc:select_count(Ref, \"SELECT FIRSTNAME, NR FROM EMPLOYEE WHERE GENDER = 'F'\").\n      {ok,6}\n```\n\nA few more ways of retrieving parts of the result set when the driver supports\nscrollable cursors. Note that next will work even without support for scrollable\ncursors.\n\n```erlang\n 18 > odbc:select(Ref, {relative, 2}, 3).\n    {selected,[\"FIRSTNAME\",\"NR\"],[{\"Monica\",3},{\"Rachel\",5},{\"Piper\",6}]}\n```\n\n```erlang\n 19 > odbc:select(Ref, next, 2).\n      {selected,[\"FIRSTNAME\",\"NR\"],[{\"Prue\",7},{\"Louise\",8}]}\n```\n\n```erlang\n 20 > odbc:select(Ref, {absolute, 1}, 2).\n      {selected,[\"FIRSTNAME\",\"NR\"],[{\"Jane\",1},{\"Monica\",3}]}\n```\n\n```erlang\n 21 > odbc:select(Ref, next, 2).\n    {selected,[\"FIRSTNAME\",\"NR\"],[{\"Rachel\",5},{\"Piper\",6}]}\n```\n\n```erlang\n 22 > odbc:select(Ref, {absolute, 1}, 4).\n      {selected,[\"FIRSTNAME\",\"NR\"],\n                [{\"Jane\",1},{\"Monica\",3},{\"Rachel\",5},{\"Piper\",6}]}\n```\n\nSelect, using a parameterized query.\n\n```erlang\n 23 > odbc:param_query(Ref, \"SELECT * FROM EMPLOYEE WHERE GENDER=?\",\n      [{{sql_char, 1}, [\"M\"]}]).\n      {selected,[\"NR\",\"FIRSTNAME\",\"LASTNAME\",\"GENDER\"],\n                [{2,\"John\", \"Doe\", \"M\"},{4,\"Ross\",\"Geller\",\"M\"}]}\n```\n\nDelete the table `EMPLOYEE`.\n\n```text\n 24 > odbc:sql_query(Ref, \"DROP TABLE EMPLOYEE\").\n      {updated,undefined}\n```\n\nShut down the connection.\n\n```erlang\n 25 > odbc:disconnect(Ref).\n      ok\n```\n\nShut down the application.\n\n```text\n 26 > odbc:stop().\n    =INFO REPORT==== 7-Jan-2004::17:00:59 ===\n    application: odbc\n    exited: stopped\n    type: temporary\n\n    ok\n```","ref":"getting_started.html#using-the-erlang-api"},{"type":"extras","title":"Databases","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Databases","ref":"databases.html"},{"type":"extras","title":"Databases - Databases","doc":"If you need to access a relational database such as `sqlserver`, `mysql`,\n`postgres`, `oracle`, `cybase` etc. from your erlang application using the\nErlang ODBC interface is a good way to go about it.\n\nThe Erlang ODBC application should work for any relational database that has an\nODBC driver. But currently it is only regularly tested for `sqlserver` and\n`postgres`.","ref":"databases.html#databases"},{"type":"extras","title":"Database independence - Databases","doc":"The Erlang ODBC interface is in principal database independent, e.i. an erlang\nprogram using the interface could be run without changes towards different\ndatabases. But as SQL is used it is alas possible to write database dependent\nprograms. Even though SQL is an ANSI-standard meant to be database independent,\ndifferent databases have proprietary extensions to SQL defining their own data\ntypes. If you keep to the ANSI data types you will minimize the problem. But\nunfortunately there is no guarantee that all databases actually treats the ANSI\ndata types equivalently. For instance an installation of\n`Oracle Enterprise release 8.0.5.0.0 for unix` will accept that you create a\ntable column with the ANSI data type `integer`, but when retrieving values from\nthis column the driver reports that it is of type `SQL_DECIMAL(0, 38)` and not\n`SQL_INTEGER` as you may have expected.\n\nAnother obstacle is that some drivers do not support scrollable cursors which\nhas the effect that the only way to traverse the result set is sequentially,\nwith next, from the first row to the last, and once you pass a row you cannot go\nback. This means that some functions in the interface will not work together\nwith certain drivers. A similar problem is that not all drivers support \"row\ncount\" for select queries, hence resulting in that the function\n`select_count/[3,4]` will return `{ok, undefined}` instead of `{ok, NrRows}`\nwhere `NrRows` is the number of rows in the result set.","ref":"databases.html#database-independence"},{"type":"extras","title":"Data types - Databases","doc":"The following is a list of the ANSI data types. For details turn to the ANSI\nstandard documentation. Usage of other data types is of course possible, but you\nshould be aware that this makes your application dependent on the database you\nare using at the moment.\n\n- CHARACTER (size), CHAR (size)\n- NUMERIC (precision, scale), DECIMAL (precision, scale), DEC (precision, scale\n  ) precision - total number of digits, scale - total number of decimal places\n- INTEGER, INT, SMALLINT\n- FLOAT (precision)\n- REAL\n- DOUBLE PRECISION\n- CHARACTER VARYING(size), CHAR VARYING(size)\n\nWhen inputting data using sql_query/\\[2,3] the values will always be in string\nformat as they are part of an SQL-query. Example:\n\n```text\n      odbc:sql_query(Ref, \"INSERT INTO TEST VALUES(1, 2, 3)\").\n```\n\n> #### Note {: .info }\n>\n> Note that when the value of the data to input is a string, it has to be quoted\n> with `'`. Example:\n>\n> ```text\n> odbc:sql_query(Ref, \"INSERT INTO EMPLOYEE VALUES(1, 'Jane', 'Doe', 'F')\").\n> ```\n\nYou may also input data using [param_query/3,4](`odbc:param_query/4`) and\nthen the input data will have the Erlang type corresponding to the ODBC type of\nthe column.[See ODBC to Erlang mapping](databases.md#type)\n\n[](){: #type } When selecting data from a table, all data types are returned\nfrom the database to the ODBC driver as an ODBC data type. The tables below\nshows the mapping between those data types and what is returned by the Erlang\nAPI.\n\n| ODBC Data Type                                                                | Erlang Data Type                               |\n| ----------------------------------------------------------------------------- | ---------------------------------------------- |\n| SQL_CHAR(size)                                                                | String \\| Binary (configurable)                |\n| SQL_WCHAR(size)                                                               | Unicode binary encoded as UTF16 little endian. |\n| SQL_NUMERIC(p,s) when (p >= 0 and p <= 9 and s == 0)                          | Integer                                        |\n| SQL_NUMERIC(p,s) when (p >= 10 and p <= 15 and s == 0) or (s <= 15 and s > 0) | Float                                          |\n| SQL_NUMERIC(p,s) when p >= 16                                                 | String                                         |\n| SQL_DECIMAL(p,s) when (p >= 0 and p <= 9 and s == 0)                          | Integer                                        |\n| SQL_DECIMAL(p,s) when (p >= 10 and p <= 15 and s == 0) or (s <= 15 and s > 0) | Float                                          |\n| SQL_DECIMAL(p,s) when p >= 16                                                 | String                                         |\n| SQL_INTEGER                                                                   | Integer                                        |\n| SQL_SMALLINT                                                                  | Integer                                        |\n| SQL_FLOAT                                                                     | Float                                          |\n| SQL_REAL                                                                      | Float                                          |\n| SQL_DOUBLE                                                                    | Float                                          |\n| SQL_VARCHAR(size)                                                             | String \\| Binary (configurable)                |\n| SQL_WVARCHAR(size)                                                            | Unicode binary encoded as UTF16 little endian. |\n\n_Table: Mapping of ODBC data types to the Erlang data types returned to the\nErlang application._\n\n| ODBC Data Type         | Erlang Data Type                               |\n| ---------------------- | ---------------------------------------------- |\n| SQL_TYPE_DATE          | String                                         |\n| SQL_TYPE_TIME          | String                                         |\n| SQL_TYPE_TIMESTAMP     | \\{\\{YY, MM, DD\\}, \\{HH, MM, SS\\}\\}             |\n| SQL_LONGVARCHAR        | String \\| Binary (configurable)                |\n| SQL_WLONGVARCHAR(size) | Unicode binary encoded as UTF16 little endian. |\n| SQL_BINARY             | String \\| Binary (configurable)                |\n| SQL_VARBINARY          | String \\| Binary (configurable)                |\n| SQL_LONGVARBINARY      | String \\| Binary (configurable)                |\n| SQL_TINYINT            | Integer                                        |\n| SQL_BIT                | Boolean                                        |\n\n_Table: Mapping of extended ODBC data types to the Erlang data types returned to\nthe Erlang application._\n\n> #### Note {: .info }\n>\n> To find out which data types will be returned for the columns in a table use\n> the function [describe_table/2,3](`odbc:describe_table/3`)","ref":"databases.html#data-types"},{"type":"extras","title":"Batch handling - Databases","doc":"Grouping of SQL queries can be desirable in order to reduce network traffic.\nAnother benefit can be that the data source sometimes can optimize execution of\na batch of SQL queries.\n\nExplicit batches an procedures described below will result in multiple results\nbeing returned from sql_query/\\[2,3]. while with parameterized queries only one\nresult will be returned from param_query/\\[2,3].","ref":"databases.html#batch-handling"},{"type":"extras","title":"Explicit batches - Databases","doc":"The most basic form of a batch is created by semicolons separated SQL queries,\nfor example:\n\n```text\n\"SELECT * FROM FOO; SELECT * FROM BAR\" or\n\"INSERT INTO FOO VALUES(1,'bar'); SELECT * FROM FOO\"\n```","ref":"databases.html#explicit-batches"},{"type":"extras","title":"Procedures - Databases","doc":"Different databases may also support creating of procedures that contains more\nthan one SQL query. For example, the following SQLServer-specific statement\ncreates a procedure that returns a result set containing information about\nemployees that work at the department and a result set listing the customers of\nthat department.\n\n```text\n CREATE PROCEDURE DepartmentInfo (@DepartmentID INT) AS\n SELECT * FROM Employee WHERE department = @DepartmentID\n SELECT * FROM Customers WHERE department = @DepartmentID\n```","ref":"databases.html#procedures"},{"type":"extras","title":"Parameterized queries - Databases","doc":"To effectively perform a batch of similar queries, you can use parameterized\nqueries. This means that you in your SQL query string will mark the places that\nusually would contain values with question marks and then provide lists of\nvalues for each parameter. For instance you can use this to insert multiple rows\ninto the `EMPLOYEE` table while executing only a single SQL statement, for\nexample code see [\"Using the Erlang API\"](getting_started.md#param_query)\nsection in the \"Getting Started\" chapter.","ref":"databases.html#parameterized-queries"},{"type":"extras","title":"Error handling","doc":"<!--\n%CopyrightBegin%\n\nSPDX-License-Identifier: Apache-2.0\n\nCopyright Ericsson AB 2023-2025. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Error handling","ref":"error_handling.html"},{"type":"extras","title":"Strategy - Error handling","doc":"On a conceptual level starting a database connection using the Erlang ODBC API\nis a basic client server application. The client process uses the API to start\nand communicate with the server process that manages the connection. The\nstrategy of the Erlang ODBC application is that programming faults in the\napplication itself will cause the connection process to terminate\nabnormally.(When a process terminates abnormally its supervisor will log\nrelevant error reports.) Calls to API functions during or after termination of\nthe connection process, will return `{error, connection_closed}`. Contextual\nerrors on the other hand will not terminate the connection it will only return\n`{error, Reason} `to the client, where `Reason` may be any erlang term.","ref":"error_handling.html#strategy"},{"type":"extras","title":"Clients - Error handling","doc":"The connection is associated with the process that created it and can only be\naccessed through it. The reason for this is to preserve the semantics of result\nsets and transactions when select_count/\\[2,3] is called or auto_commit is\nturned off. Attempts to use the connection from another process will fail. This\nwill not effect the connection. On the other hand, if the client process dies\nthe connection will be terminated.","ref":"error_handling.html#clients"},{"type":"extras","title":"Timeouts - Error handling","doc":"All request made by the client to the connection are synchronous. If the timeout\nis used and expires the client process will exit with reason timeout. Probably\nthe right thing to do is let the client die and perhaps be restarted by its\nsupervisor. But if the client chooses to catch this timeout, it is a good idea\nto wait a little while before trying again. If there are too many consecutive\ntimeouts that are caught the connection process will conclude that there is\nsomething radically wrong and terminate the connection.","ref":"error_handling.html#timeouts"},{"type":"extras","title":"Guards - Error handling","doc":"All API-functions are guarded and if you pass an argument of the wrong type a\nruntime error will occur. All input parameters to internal functions are trusted\nto be correct. It is a good programming practise to only distrust input from\ntruly external sources. You are not supposed to catch these errors, it will only\nmake the code very messy and much more complex, which introduces more bugs and\nin the worst case also covers up the actual faults. Put your effort on testing\ninstead, you should trust your own input.","ref":"error_handling.html#guards"},{"type":"extras","title":"The whole picture - Error handling","doc":"As the Erlang ODBC application relies on third party products and communicates\nwith a database that probably runs on another computer in the network there are\nplenty of things that might go wrong. To fully understand the things that might\nhappen it facilitate to know the design of the Erlang ODBC application, hence\nhere follows a short description of the current design.\n\n> #### Note {: .info }\n>\n> Please note that design is something, that not necessarily will, but might\n> change in future releases. While the semantics of the API will not change as\n> it is independent of the implementation.\n\n![Architecture of the Erlang odbc application](assets/odbc_app_arc.gif \"Architecture of the Erlang odbc application\")\n\nWhen you do application:start(odbc) the only thing that happens is that a\nsupervisor process is started. For each call to the API function connect/2 a\nprocess is spawned and added as a child to the Erlang ODBC supervisor. The\nsupervisors only tasks are to provide error-log reports, if a child process\nshould die abnormally, and the possibility to do a code change. Only the client\nprocess has the knowledge to decide if this connection managing process should\nbe restarted.\n\nThe erlang connection process spawned by connect/2, will open a port to a\nc-process that handles the communication with the database through Microsoft's\nODBC API. The erlang port will be kept open for exit signal propagation, if\nsomething goes wrong in the c-process and it exits we want know as mush as\npossible about the reason. The main communication with the c-process is done\nthrough sockets. The C-process consists of two threads, the supervisor thread\nand the database handler thread. The supervisor thread checks for shutdown\nmessages on the supervisor socket and the database handler thread receives\nrequests and sends answers on the database socket. If the database thread seems\nto hang on some database call, the erlang control process will send a shutdown\nmessage on the supervisor socket, in this case the c-process will exit. If the\nc-process crashes/exits it will bring the erlang-process down too and vice versa\ni.e. the connection is terminated.","ref":"error_handling.html#the-whole-picture"},{"type":"extras","title":"Error types - Error handling","doc":"The types of errors that may occur can be divide into the following categories.\n\n- Configuration problems - Everything from that the database was not set up\n  right to that the c-program that should be run through the erlang port was not\n  compiled for your platform.\n- Errors discovered by the ODBC driver - If calls to the ODBC-driver fails due\n  to circumstances that cannot be controlled by the Erlang ODBC application\n  programmer, an error string will be dug up from the driver. This string will\n  be the `Reason` in the `{error, Reason} `return value. How good this error\n  message is will of course be driver dependent. Examples of such circumstances\n  are trying to insert the same key twice, invalid SQL-queries and that the\n  database has gone off line.\n- Connection termination - If a connection is terminated in an abnormal way, or\n  if you try to use a connection that you have already terminated in a normal\n  way by calling disconnect/1, the return value will\n  be`{error, connection_closed}`. A connection could end abnormally because of\n  an programming error in the Erlang ODBC application, but also if the ODBC\n  driver crashes.\n- Contextual errors - If API functions are used in the wrong context, the\n  `Reason` in the error tuple will be a descriptive atom. For instance if you\n  try to call the function `last/[1,2] `without first calling\n  `select_count/[2,3] `to associate a result set with the connection. If the\n  ODBC-driver does not support some functions, or if you disabled some\n  functionality for a connection and then try to use it.","ref":"error_handling.html#error-types"}],"proglang":"erlang","content_type":"text/markdown","producer":{"name":"ex_doc","version":"0.38.1"}}