/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.project;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.project.FileSystemExplorerView;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.utils.CommonUtils;

public class PrefPageProjectResourceDetails
extends AbstractPrefPage
implements IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.resourceDetails";
    private static final Log log = Log.getLog(PrefPageProjectResourceDetails.class);
    private IAdaptable element;
    private Path resourcePath;

    public PrefPageProjectResourceDetails() {
        this.setDescription("Resource information details");
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)2);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.resourcePath == null) {
            return composite;
        }
        UIUtils.createLabelText((Composite)composite, (String)"Path", (String)DBFUtils.convertPathToString((Path)this.resourcePath), (int)2056);
        FileAttributeView fileAttributeView = Files.getFileAttributeView(this.resourcePath, PosixFileAttributeView.class, new LinkOption[0]);
        if (fileAttributeView == null) {
            fileAttributeView = Files.getFileAttributeView(this.resourcePath, FileOwnerAttributeView.class, new LinkOption[0]);
        }
        if (fileAttributeView == null) {
            fileAttributeView = Files.getFileAttributeView(this.resourcePath, BasicFileAttributeView.class, new LinkOption[0]);
        }
        if (fileAttributeView instanceof BasicFileAttributeView) {
            BasicFileAttributeView basicAttrsView = fileAttributeView;
            try {
                BasicFileAttributes attributes = basicAttrsView.readAttributes();
                if (attributes.isDirectory()) {
                    UIUtils.createCheckbox((Composite)composite, (String)"Directory", null, (boolean)attributes.isDirectory(), (int)2).setEnabled(false);
                } else {
                    UIUtils.createLabelText((Composite)composite, (String)"File size", (String)FileSystemExplorerView.FILE_SIZE_FORMAT.format(attributes.size()), (int)2056);
                }
                UIUtils.createLabelText((Composite)composite, (String)"Creation time", (String)FileSystemExplorerView.FILE_TIMESTAMP_FORMAT.format(attributes.creationTime().toMillis()), (int)2056);
                UIUtils.createLabelText((Composite)composite, (String)"Last modified time", (String)FileSystemExplorerView.FILE_TIMESTAMP_FORMAT.format(attributes.lastModifiedTime().toMillis()), (int)2056);
                Object fileKey = attributes.fileKey();
                if (fileKey != null) {
                    UIUtils.createLabelText((Composite)composite, (String)"File key", (String)CommonUtils.toString((Object)fileKey), (int)2056);
                }
                if (attributes instanceof PosixFileAttributes) {
                    Set<PosixFilePermission> permissions;
                    GroupPrincipal group;
                    PosixFileAttributes posixAttributes = (PosixFileAttributes)attributes;
                    UserPrincipal owner = posixAttributes.owner();
                    if (owner != null) {
                        UIUtils.createLabelText((Composite)composite, (String)"File owner", (String)CommonUtils.toString((Object)owner.getName()), (int)2056);
                    }
                    if ((group = posixAttributes.group()) != null) {
                        UIUtils.createLabelText((Composite)composite, (String)"File group", (String)CommonUtils.toString((Object)group.getName()), (int)2056);
                    }
                    if (!CommonUtils.isEmpty(permissions = posixAttributes.permissions())) {
                        UIUtils.createLabelText((Composite)composite, (String)"Permissions", (String)permissions.stream().map(Enum::name).collect(Collectors.joining(",")), (int)2056);
                    }
                }
            }
            catch (IOException e) {
                DBWorkbench.getPlatformUI().showError("Error reading file attributes", null, (Throwable)e);
            }
        }
        return composite;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
        this.resourcePath = (Path)DBUtils.getAdapter(Path.class, (Object)element);
    }
}

