/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view;

import java.io.IOException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dashboard.internal.UIDashboardMessages;
import org.jkiss.dbeaver.ui.dashboard.model.DashboardViewer;
import org.jkiss.dbeaver.ui.dashboard.view.DashboardManagerDialog;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class DashboardViewConfigDialog
extends BaseDialog {
    private final DashboardViewer view;
    private Text dashboardNameText;
    private Button initWithDefaultChartsCheck;
    private Button connectOnActivationCheck;

    public DashboardViewConfigDialog(Shell shell, DashboardViewer view) {
        super(shell, NLS.bind((String)UIDashboardMessages.dialog_dashboard_view_config_title, (Object)view.getDataSourceContainer().getName()), null);
        this.view = view;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return null;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        Group viewGroup = UIUtils.createControlGroup((Composite)composite, (String)UIDashboardMessages.dialog_dashboard_view_config_group_viewcfg, (int)2, (int)768, (int)0);
        Text dashboardIdText = UIUtils.createLabelText((Composite)viewGroup, (String)"ID", (String)CommonUtils.notEmpty((String)this.view.getConfiguration().getDashboardId()));
        dashboardIdText.setEnabled(false);
        this.dashboardNameText = UIUtils.createLabelText((Composite)viewGroup, (String)UIDashboardMessages.dialog_edit_dashboard_maininfo_labels_display_name, (String)CommonUtils.notEmpty((String)this.view.getConfiguration().getDashboardName()));
        this.initWithDefaultChartsCheck = UIUtils.createCheckbox((Composite)viewGroup, (String)UIDashboardMessages.dialog_dashboard_view_config_group_viewcfg_checkbox_init_default, (String)UIDashboardMessages.dialog_dashboard_view_config_group_viewcfg_checkbox_init_default_tooltip, (boolean)this.view.getConfiguration().isInitDefaultCharts(), (int)2);
        this.connectOnActivationCheck = UIUtils.createCheckbox((Composite)viewGroup, (String)UIDashboardMessages.dialog_dashboard_view_config_group_viewcfg_checkbox_connect, (String)UIDashboardMessages.dialog_dashboard_view_config_group_viewcfg_checkbox_connect_tooltip, (boolean)this.view.getConfiguration().isOpenConnectionOnActivate(), (int)2);
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
            Button managerButton = this.createButton(parent, 1, UIDashboardMessages.dialog_add_dashboard_button_manage, false);
            ((GridData)managerButton.getLayoutData()).horizontalAlignment = 1;
            ((GridData)managerButton.getLayoutData()).grabExcessHorizontalSpace = true;
            managerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    new DashboardManagerDialog(UIUtils.getActiveWorkbenchShell()).open();
                }
            });
        }
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        try {
            String dbName = this.dashboardNameText.getText();
            if (CommonUtils.isEmpty((String)dbName)) {
                throw new IOException("Empty dashboard name");
            }
            this.view.getConfiguration().setDashboardName(dbName);
            this.view.getConfiguration().setInitDefaultCharts(this.initWithDefaultChartsCheck.getSelection());
            this.view.getConfiguration().setOpenConnectionOnActivate(this.connectOnActivationCheck.getSelection());
            this.view.getConfigurationList().saveConfiguration();
            super.okPressed();
        }
        catch (IOException e) {
            DBWorkbench.getPlatformUI().showError("Error saving dashboard view", null, (Throwable)e);
        }
    }
}

