/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.format;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.model.sql.registry.SQLFormatterConfigurationRegistry;

public class SQLFormatUtils {
    public static String formatSQL(DBPDataSource dataSource, String query) {
        return SQLFormatUtils.formatSQL(dataSource, query, null);
    }

    public static String formatSQL(@Nullable DBPDataSource dataSource, @NotNull SQLSyntaxManager syntaxManager, String query) {
        return SQLFormatUtils.formatSQL(dataSource, syntaxManager, query, null);
    }

    public static String formatSQL(DBPDataSource dataSource, String query, @Nullable String indent) {
        SQLSyntaxManager syntaxManager = new SQLSyntaxManager();
        syntaxManager.init(dataSource.getSQLDialect(), dataSource.getContainer().getPreferenceStore());
        return SQLFormatUtils.formatSQL(dataSource, syntaxManager, query, indent);
    }

    public static String formatSQL(@Nullable DBPDataSource dataSource, @NotNull SQLSyntaxManager syntaxManager, @NotNull String query, @Nullable String indent) {
        SQLFormatter formatter;
        SQLFormatterConfiguration configuration = new SQLFormatterConfiguration(dataSource, syntaxManager);
        if (indent != null) {
            configuration.setIndentString(indent);
        }
        if ((formatter = SQLFormatterConfigurationRegistry.getInstance().createFormatter(configuration)) == null) {
            return query;
        }
        return formatter.format(query, configuration);
    }
}

