/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.greenplum.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumDataSource;
import org.jkiss.dbeaver.ext.greenplum.model.GreenplumUtils;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableRegular;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class GreenplumTable
extends PostgreTableRegular {
    private static final Log log = Log.getLog(GreenplumTable.class);
    private int[] distributionColumns;
    private boolean supportsReplicatedDistribution = false;
    private String accessMethod;

    public GreenplumTable(PostgreSchema catalog) {
        super(catalog);
    }

    public GreenplumTable(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
        PostgreDataSource dataSource;
        if (catalog.getDataSource().isServerVersionAtLeast(9, 1)) {
            this.supportsReplicatedDistribution = true;
        }
        if ((dataSource = (PostgreDataSource)this.getDataSource()) instanceof GreenplumDataSource && ((GreenplumDataSource)dataSource).isGreenplumVersionAtLeast(7, 0)) {
            this.accessMethod = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"amname");
        }
    }

    @Nullable
    public String getAccessMethod() {
        return this.accessMethod;
    }

    private List<PostgreTableColumn> getDistributionPolicy(DBRProgressMonitor monitor) throws DBException {
        if (this.distributionColumns == null) {
            try {
                this.distributionColumns = GreenplumUtils.readDistributedColumns(monitor, (PostgreTableReal)this);
            }
            catch (Throwable e) {
                log.error((Object)"Error reading distribution policy", e);
            }
            if (this.distributionColumns == null) {
                this.distributionColumns = new int[0];
            }
        }
        if (this.distributionColumns.length == 0) {
            return null;
        }
        ArrayList<PostgreTableColumn> columns = new ArrayList<PostgreTableColumn>(this.distributionColumns.length);
        int i = 0;
        while (i < this.distributionColumns.length) {
            PostgreTableColumn attr = this.getAttributeByPos(monitor, this.distributionColumns[i]);
            if (attr == null) {
                log.debug((Object)("Bad policy attribute position: " + this.distributionColumns[i]));
            } else {
                columns.add(attr);
            }
            ++i;
        }
        return columns;
    }

    public void appendTableModifiers(DBRProgressMonitor monitor, StringBuilder ddl) {
        try {
            List<PostgreTableColumn> distributionColumns = this.getDistributionPolicy(monitor);
            if (CommonUtils.isEmpty(distributionColumns)) {
                distributionColumns = GreenplumUtils.getDistributionTableColumns(monitor, distributionColumns, (PostgreTableReal)this);
            }
            boolean readPartitionInfo = true;
            PostgreDataSource dataSource = (PostgreDataSource)this.getDataSource();
            if (dataSource instanceof GreenplumDataSource) {
                readPartitionInfo = !((GreenplumDataSource)dataSource).isGreenplumVersionAtLeast(7, 0);
            }
            GreenplumUtils.addObjectModifiersToDDL(monitor, ddl, (PostgreTableReal)this, distributionColumns, this.supportsReplicatedDistribution, readPartitionInfo);
        }
        catch (DBException e) {
            log.error((Object)"Error reading Greenplum table properties", (Throwable)e);
        }
    }
}

