/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.preferences;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;

public abstract class AbstractUserPreferenceStore
extends AbstractPreferenceStore {
    private static final Log log = Log.getLog(AbstractUserPreferenceStore.class);
    protected final DBPPreferenceStore parentStore;
    protected final Map<String, Object> userPreferences = new HashMap<String, Object>();

    public AbstractUserPreferenceStore(@NotNull DBPPreferenceStore parentStore) {
        this.parentStore = parentStore;
    }

    public void updateAllUserPreferences(@NotNull Map<String, Object> newUserPreferences) {
        this.userPreferences.clear();
        this.userPreferences.putAll(newUserPreferences);
    }

    @Override
    public String getString(@NotNull String name) {
        Object value = this.userPreferences.get(name);
        return value == null ? this.getDefaultString(name) : value.toString();
    }

    @Override
    public boolean contains(@NotNull String name) {
        return this.userPreferences.containsKey(name) || this.parentStore.contains(name);
    }

    @Override
    public boolean getBoolean(@NotNull String name) {
        return this.toBoolean(this.getString(name));
    }

    @Override
    public double getDouble(@NotNull String name) {
        return this.toDouble(this.getString(name));
    }

    @Override
    public float getFloat(@NotNull String name) {
        return this.toFloat(this.getString(name));
    }

    @Override
    public int getInt(@NotNull String name) {
        return this.toInt(this.getString(name));
    }

    @Override
    public long getLong(@NotNull String name) {
        return this.toLong(this.getString(name));
    }

    @Override
    public boolean getDefaultBoolean(@NotNull String name) {
        return this.toBoolean(this.getDefaultString(name));
    }

    @Override
    public double getDefaultDouble(@NotNull String name) {
        return this.toDouble(this.getDefaultString(name));
    }

    @Override
    public float getDefaultFloat(@NotNull String name) {
        return this.toFloat(this.getDefaultString(name));
    }

    @Override
    public int getDefaultInt(@NotNull String name) {
        return this.toInt(this.getDefaultString(name));
    }

    @Override
    public long getDefaultLong(@NotNull String name) {
        return this.toLong(this.getDefaultString(name));
    }

    @Override
    public void setDefault(@NotNull String name, double value) {
        this.setDefault(name, String.valueOf(value));
    }

    @Override
    public void setDefault(@NotNull String name, float value) {
        this.setDefault(name, String.valueOf(value));
    }

    @Override
    public void setDefault(@NotNull String name, int value) {
        this.setDefault(name, String.valueOf(value));
    }

    @Override
    public void setDefault(@NotNull String name, long value) {
        this.setDefault(name, String.valueOf(value));
    }

    @Override
    public void setDefault(@NotNull String name, @Nullable String defaultObject) {
        this.parentStore.setDefault(name, defaultObject);
    }

    @Override
    public void setDefault(@NotNull String name, boolean value) {
        this.setDefault(name, String.valueOf(value));
    }

    @Override
    public void setValue(@NotNull String name, double value) {
        this.setUserPreference(name, value);
    }

    @Override
    public void setValue(@NotNull String name, float value) {
        this.setUserPreference(name, Float.valueOf(value));
    }

    @Override
    public void setValue(@NotNull String name, int value) {
        this.setUserPreference(name, value);
    }

    @Override
    public void setValue(@NotNull String name, long value) {
        this.setUserPreference(name, value);
    }

    @Override
    public void setValue(@NotNull String name, @Nullable String value) {
        this.setUserPreference(name, value);
    }

    @Override
    public void setValue(@NotNull String name, boolean value) {
        this.setUserPreference(name, value);
    }

    protected abstract void setUserPreference(String var1, Object var2);
}

