/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model;

import java.sql.ResultSet;
import java.util.Arrays;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridTable;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableColumn;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;

public class CubridTableColumn
extends GenericTableColumn {
    static final String[] customTypes = new String[]{"ENUM", "JSON"};
    public boolean isForeignKey;

    public CubridTableColumn(@NotNull GenericTableBase table, @Nullable String columnName, @Nullable String dataType, boolean autoIncrement, boolean isForeignKey, @Nullable JDBCResultSet dbResult) throws DBException {
        super(table);
        if (dbResult != null) {
            this.isForeignKey = isForeignKey;
            this.setName(columnName);
            this.setDataType(dataType);
            this.setPrecision(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"prec"));
            this.setMaxLength(this.getPrecision().intValue());
            this.setScale(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"scale"));
            this.setRequired(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"is_nullable").equals("NO"));
            this.setDescription(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"comment"));
            this.setDefaultValue(JDBCUtils.safeGetString((ResultSet)dbResult, (String)"default_value"));
            this.setAutoIncrement(autoIncrement);
            this.setOrdinalPosition(JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"ref_order"));
            this.setPersisted(true);
        }
    }

    public void setName(@NotNull String name) {
        super.setName(name != null ? name.toLowerCase() : null);
    }

    @NotNull
    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    public void setDataType(@NotNull String fullTypeName) throws DBException {
        String type = Arrays.stream(customTypes).filter(item -> fullTypeName.contains((CharSequence)item)).findFirst().orElse(null);
        if (type == null) {
            this.setFullTypeName(fullTypeName);
        } else {
            this.setTypeName(fullTypeName);
        }
    }

    @Property(viewable=true, editable=true, updatableExpr="!object.foreignKey && object.cubridTable", order=20, listProvider=JDBCTableColumn.ColumnTypeNameListProvider.class)
    @NotNull
    public String getTypeName() {
        return super.getTypeName();
    }

    @Property(viewable=true, editable=true, updatableExpr="!object.foreignKey && object.cubridTable", order=40)
    @Nullable
    public long getMaxLength() {
        if (this.getDataKind().equals((Object)DBPDataKind.STRING)) {
            return super.getMaxLength();
        }
        return 0L;
    }

    @Property(viewable=true, editable=true, updatableExpr="!object.foreignKey && object.cubridTable", order=50)
    @NotNull
    public boolean isRequired() {
        return super.isRequired();
    }

    @Property(viewable=true, editable=true, updatableExpr="!object.foreignKey && object.cubridTable", order=70)
    @Nullable
    public String getDefaultValue() {
        return super.getDefaultValue();
    }

    @Nullable
    public boolean isInUniqueKey() {
        return false;
    }

    @Nullable
    public boolean isAutoGenerated() {
        return false;
    }

    @Nullable
    public int getRadix() {
        return 0;
    }

    @Property(viewable=true, editable=true, updatableExpr="object.descriptionEditable", length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return super.getDescription();
    }

    public boolean isCubridTable() {
        return this.getTable() instanceof CubridTable;
    }

    public boolean isDescriptionEditable() {
        return ((GenericDataSource)((GenericTableBase)this.getTable()).getDataSource()).isServerVersionAtLeast(11, 0) || this.isCubridTable() && !this.isForeignKey();
    }
}

