/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.driver;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenArtifact;
import org.jkiss.dbeaver.registry.maven.MavenArtifactReference;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class EditMavenArtifactDialog
extends BaseDialog {
    private static final Log log = Log.getLog(EditMavenArtifactDialog.class);
    private static final Pattern REGEX_FOR_GRADLE = Pattern.compile("([\\w_.-]+):([\\w_.-]+)(?::([\\w_.-]+))(?::([\\w_.-]+))?", 8);
    private final DriverLibraryMavenArtifact originalArtifact;
    private final DriverDescriptor driver;
    private final List<DriverLibraryMavenArtifact> artifacts = new ArrayList<DriverLibraryMavenArtifact>();
    private boolean ignoreDependencies;
    private boolean loadOptionalDependencies;
    private Text groupText;
    private Text artifactText;
    private Text classifierText;
    private Text preferredVersionText;
    private Combo fallbackVersionText;
    private Text fieldText;
    private CLabel errorLabel;
    private CTabFolder tabFolder;
    private boolean isReadOnly = false;

    public EditMavenArtifactDialog(@NotNull Shell shell, @NotNull DriverDescriptor driver, @Nullable DriverLibraryMavenArtifact library) {
        super(shell, UIConnectionMessages.dialog_edit_driver_edit_maven_title, (DBPImage)DBIcon.TREE_USER);
        this.driver = driver;
        this.originalArtifact = library;
    }

    @NotNull
    public List<DriverLibraryMavenArtifact> getArtifacts() {
        return this.artifacts;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = UIUtils.getFontHeight((Font)composite.getFont()) * 40;
        this.tabFolder = new CTabFolder(composite, 0x800080);
        this.tabFolder.setLayoutData((Object)gd);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMavenArtifactDialog.this.artifacts.clear();
                CTabItem selection = EditMavenArtifactDialog.this.tabFolder.getSelection();
                if (selection != null && selection.getData() == TabType.DEPENDENCY_DECLARATION) {
                    UIUtils.asyncExec(() -> EditMavenArtifactDialog.access$1(EditMavenArtifactDialog.this));
                }
            }
        });
        if (this.originalArtifact == null) {
            this.createDependencyDeclarationTab(this.tabFolder);
        }
        this.createDeclareArtifactManuallyTab(this.tabFolder);
        Group settingsGroup = UIUtils.createControlGroup((Composite)composite, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_settings, (int)1, (int)768, (int)0);
        final Button ignoreDependenciesCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_ignore_transient_dependencies, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_load_optional_dependencies_tip, (this.originalArtifact != null && this.originalArtifact.isIgnoreDependencies() ? 1 : 0) != 0, (int)2);
        ignoreDependenciesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMavenArtifactDialog.this.ignoreDependencies = ignoreDependenciesCheckbox.getSelection();
            }
        });
        final Button loadOptionalDependenciesCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_load_optional_dependencies, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_load_optional_dependencies_tip, (this.originalArtifact != null && this.originalArtifact.isLoadOptionalDependencies() ? 1 : 0) != 0, (int)2);
        loadOptionalDependenciesCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditMavenArtifactDialog.this.loadOptionalDependencies = loadOptionalDependenciesCheckbox.getSelection();
            }
        });
        return composite;
    }

    private void parseArtifactText() {
        try {
            this.artifacts.clear();
            if (!this.fieldText.getText().isEmpty()) {
                this.artifacts.addAll(this.parseMaven());
                this.setStatus(false, NLS.bind((String)UIConnectionMessages.dialog_edit_driver_edit_maven_artifacts_count, (Object)this.artifacts.size()));
            } else {
                this.setStatus(false, UIConnectionMessages.dialog_edit_driven_edit_maven_field_text_message);
            }
        }
        catch (Exception e) {
            if (REGEX_FOR_GRADLE.matcher(this.fieldText.getText()).find()) {
                try {
                    this.artifacts.addAll(this.parseGradle());
                    this.setStatus(false, NLS.bind((String)UIConnectionMessages.dialog_edit_driver_edit_maven_artifacts_count, (Object)this.artifacts.size()));
                }
                catch (DBException dBException) {
                    this.setStatus(true, e.getMessage());
                    log.debug((Object)"Error parsing dependency declaration", (Throwable)e);
                }
            }
            this.setStatus(true, e.getMessage());
            log.debug((Object)"Error parsing dependency declaration", (Throwable)e);
        }
    }

    private void setStatus(boolean error, String message) {
        this.enableButton(0, !error);
        this.errorLabel.setVisible(!message.isEmpty());
        if (!message.isEmpty()) {
            this.errorLabel.setImage(DBeaverIcons.getImage((DBPImage)(error ? DBIcon.SMALL_ERROR : DBIcon.SMALL_INFO)));
            this.errorLabel.setText(message);
        }
    }

    private void createDependencyDeclarationTab(@NotNull CTabFolder folder) {
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        container.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.heightHint = UIUtils.getFontHeight((Font)container.getFont()) * 12;
        this.fieldText = new Text(container, 2562);
        this.fieldText.setLayoutData((Object)gd);
        this.fieldText.addModifyListener(event -> this.parseArtifactText());
        this.errorLabel = new CLabel(container, 0);
        this.errorLabel.setLayoutData((Object)new GridData(768));
        this.errorLabel.setVisible(false);
        CTabItem item = new CTabItem(folder, 0);
        item.setText(UIConnectionMessages.dialog_edit_driver_edit_maven_raw);
        item.setControl((Control)container);
        item.setData((Object)TabType.DEPENDENCY_DECLARATION);
    }

    private void createDeclareArtifactManuallyTab(@NotNull CTabFolder folder) {
        Composite container = new Composite((Composite)folder, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        container.setLayoutData((Object)gd);
        this.groupText = UIUtils.createLabelText((Composite)container, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_group_id_label, (String)(this.originalArtifact != null ? CommonUtils.notEmpty((String)this.originalArtifact.getReference().getGroupId()) : ""));
        this.artifactText = UIUtils.createLabelText((Composite)container, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_artifact_id_label, (String)(this.originalArtifact != null ? CommonUtils.notEmpty((String)this.originalArtifact.getReference().getArtifactId()) : ""));
        this.classifierText = UIUtils.createLabelText((Composite)container, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_classifier_label, (String)(this.originalArtifact != null ? CommonUtils.notEmpty((String)this.originalArtifact.getReference().getClassifier()) : ""));
        this.preferredVersionText = UIUtils.createLabelText((Composite)container, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_version_label, (String)(this.originalArtifact != null ? this.originalArtifact.getPreferredVersion() : ""));
        this.fallbackVersionText = UIUtils.createLabelCombo((Composite)container, (String)UIConnectionMessages.dialog_edit_driver_edit_maven_fallback_version_label, (int)2052);
        this.fallbackVersionText.add("RELEASE");
        this.fallbackVersionText.add("LATEST");
        if (this.originalArtifact != null) {
            this.fallbackVersionText.setText(CommonUtils.notEmpty((String)this.originalArtifact.getReference().getFallbackVersion()));
        }
        if (this.fallbackVersionText.getText().isEmpty()) {
            this.fallbackVersionText.select(0);
        }
        if (this.originalArtifact != null && !this.originalArtifact.isCustom()) {
            this.groupText.setEditable(false);
            this.artifactText.setEditable(false);
            this.classifierText.setEditable(false);
            this.preferredVersionText.setEditable(false);
            this.fallbackVersionText.setEnabled(false);
            this.isReadOnly = true;
            UIUtils.createInfoLabel((Composite)container, (String)"Predefined Maven artifacts are read-only", (int)768, (int)2);
        }
        CTabItem item = new CTabItem(folder, 0);
        item.setText(UIConnectionMessages.dialog_edit_driver_edit_maven_manual);
        item.setControl((Control)container);
        item.setData((Object)TabType.DECLARE_ARTIFACT_MANUALLY);
        ModifyListener ml = e -> this.updateButtons();
        this.groupText.addModifyListener(ml);
        this.artifactText.addModifyListener(ml);
        this.fallbackVersionText.addModifyListener(ml);
        this.preferredVersionText.addModifyListener(ml);
    }

    protected void createButtonsForButtonBar(@NotNull Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    private void updateButtons() {
        this.enableButton(0, !CommonUtils.isEmpty((String)this.groupText.getText()) && !CommonUtils.isEmpty((String)this.artifactText.getText()) && !CommonUtils.isEmpty((String)this.fallbackVersionText.getText()));
    }

    private List<DriverLibraryMavenArtifact> parseGradle() throws DBException {
        ArrayList<DriverLibraryMavenArtifact> artifacts = new ArrayList<DriverLibraryMavenArtifact>();
        Matcher matcher = REGEX_FOR_GRADLE.matcher(this.fieldText.getText());
        while (matcher.find()) {
            String group = matcher.group(1);
            String name = matcher.group(2);
            String version = matcher.group(3);
            if (CommonUtils.isNotEmpty((String)group) && CommonUtils.isNotEmpty((String)name)) {
                DriverLibraryMavenArtifact lib = new DriverLibraryMavenArtifact(this.driver, DBPDriverLibrary.FileType.jar, "", version);
                lib.setReference(new MavenArtifactReference(CommonUtils.notEmpty((String)group), CommonUtils.notEmpty((String)name), null, null, "RELEASE"));
                lib.setPreferredVersion(version);
                artifacts.add(lib);
                continue;
            }
            throw new DBException("Wrong Gradle configuration: " + matcher.group());
        }
        return artifacts;
    }

    @NotNull
    private List<DriverLibraryMavenArtifact> parseMaven() throws XMLException {
        ArrayList<DriverLibraryMavenArtifact> artifacts = new ArrayList<DriverLibraryMavenArtifact>();
        try {
            SAXReader reader = new SAXReader((Reader)new StringReader(this.fieldText.getText()));
            reader.parse((SAXListener)new SAXMavenListener(artifacts));
        }
        catch (IOException e) {
            throw new XMLException("Error parsing XML", (Throwable)e);
        }
        return artifacts;
    }

    protected void okPressed() {
        if (this.isReadOnly) {
            super.okPressed();
            return;
        }
        CTabItem selection = this.tabFolder.getSelection();
        if (selection != null && selection.getData() == TabType.DECLARE_ARTIFACT_MANUALLY) {
            if (this.originalArtifact != null) {
                this.originalArtifact.setReference(new MavenArtifactReference(this.groupText.getText(), this.artifactText.getText(), CommonUtils.nullIfEmpty((String)this.classifierText.getText()), CommonUtils.nullIfEmpty((String)this.fallbackVersionText.getText()), this.preferredVersionText.getText()));
                this.originalArtifact.setPreferredVersion(this.preferredVersionText.getText().isEmpty() ? null : this.preferredVersionText.getText());
                this.originalArtifact.setIgnoreDependencies(this.ignoreDependencies);
                this.originalArtifact.setLoadOptionalDependencies(this.loadOptionalDependencies);
            } else {
                DriverLibraryMavenArtifact lib = new DriverLibraryMavenArtifact(this.driver, DBPDriverLibrary.FileType.jar, "", this.preferredVersionText.getText().isEmpty() ? null : this.preferredVersionText.getText());
                lib.setReference(new MavenArtifactReference(this.groupText.getText(), this.artifactText.getText(), this.classifierText.getText(), this.fallbackVersionText.getText(), this.preferredVersionText.getText()));
                lib.setPreferredVersion(this.preferredVersionText.getText().isEmpty() ? null : this.preferredVersionText.getText());
                lib.setLoadOptionalDependencies(this.loadOptionalDependencies);
                lib.setIgnoreDependencies(this.ignoreDependencies);
                this.artifacts.add(lib);
            }
        } else {
            for (DriverLibraryMavenArtifact artifact : this.artifacts) {
                artifact.setLoadOptionalDependencies(this.loadOptionalDependencies);
                artifact.setIgnoreDependencies(this.ignoreDependencies);
            }
        }
        super.okPressed();
    }

    static /* synthetic */ void access$1(EditMavenArtifactDialog editMavenArtifactDialog) {
        editMavenArtifactDialog.parseArtifactText();
    }

    private class SAXMavenListener
    extends SAXListener.BaseListener {
        private final List<DriverLibraryMavenArtifact> artifacts;
        private final Deque<State> state;
        private String groupId;
        private String artifactId;
        private String classifier;
        private String version;

        public SAXMavenListener(List<DriverLibraryMavenArtifact> artifacts) {
            this.artifacts = artifacts;
            this.state = new ArrayDeque<State>();
        }

        public void saxStartElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String name, @NotNull Attributes attributes) {
            if (this.state.isEmpty() && "dependencies".equals(name)) {
                this.state.offer(State.DEPENDENCIES);
            } else if ((this.state.isEmpty() || this.state.element() == State.DEPENDENCIES) && "dependency".equals(name)) {
                this.state.offer(State.DEPENDENCY);
                this.groupId = null;
                this.artifactId = null;
                this.classifier = null;
                this.version = null;
            } else if (this.state.peekLast() == State.DEPENDENCY && "groupId".equals(name)) {
                this.state.offer(State.DEPENDENCY_GROUP_ID);
            } else if (this.state.peekLast() == State.DEPENDENCY && "artifactId".equals(name)) {
                this.state.offer(State.DEPENDENCY_ARTIFACT_ID);
            } else if (this.state.peekLast() == State.DEPENDENCY && "classifier".equals(name)) {
                this.state.offer(State.DEPENDENCY_CLASSIFIER);
            } else if (this.state.peekLast() == State.DEPENDENCY && "version".equals(name)) {
                this.state.offer(State.DEPENDENCY_VERSION);
            }
        }

        public void saxEndElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String name) {
            if (this.state.peekLast() == State.DEPENDENCY && "dependency".equals(name)) {
                DriverLibraryMavenArtifact lib = new DriverLibraryMavenArtifact(EditMavenArtifactDialog.this.driver, DBPDriverLibrary.FileType.jar, "", this.version);
                lib.setReference(new MavenArtifactReference(this.groupId, this.artifactId, this.classifier, "RELEASE", this.version));
                lib.setPreferredVersion(this.version);
                this.artifacts.add(lib);
                this.state.removeLast();
            } else if (this.state.peekLast() == State.DEPENDENCIES && "dependencies".equals(name) || this.state.peekLast() == State.DEPENDENCY_GROUP_ID && "groupId".equals(name) || this.state.peekLast() == State.DEPENDENCY_ARTIFACT_ID && "artifactId".equals(name) || this.state.peekLast() == State.DEPENDENCY_CLASSIFIER && "classifier".equals(name) || this.state.peekLast() == State.DEPENDENCY_VERSION && "version".equals(name)) {
                this.state.removeLast();
            }
        }

        public void saxText(@NotNull SAXReader reader, @NotNull String data) {
            if (this.state.isEmpty()) {
                return;
            }
            switch (this.state.peekLast()) {
                case DEPENDENCY_GROUP_ID: {
                    this.groupId = data;
                    break;
                }
                case DEPENDENCY_ARTIFACT_ID: {
                    this.artifactId = data;
                    break;
                }
                case DEPENDENCY_CLASSIFIER: {
                    this.classifier = data;
                    break;
                }
                case DEPENDENCY_VERSION: {
                    this.version = data;
                    break;
                }
            }
        }
    }

    private static enum State {
        DEPENDENCIES,
        DEPENDENCY,
        DEPENDENCY_GROUP_ID,
        DEPENDENCY_ARTIFACT_ID,
        DEPENDENCY_CLASSIFIER,
        DEPENDENCY_VERSION;

    }

    private static enum TabType {
        DEPENDENCY_DECLARATION,
        DECLARE_ARTIFACT_MANUALLY;

    }
}

