/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics;

import java.util.List;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMUtils;

public class SQLQueryComplexName {
    @NotNull
    public final STMTreeNode syntaxNode;
    @NotNull
    public final List<SQLQuerySymbolEntry> parts;
    @NotNull
    public final List<String> stringParts;
    public final int invalidPartsCount;
    @Nullable
    public final SQLQueryMemberAccessEntry endingPeriodNode;

    public SQLQueryComplexName(@NotNull STMTreeNode syntaxNode, @NotNull List<SQLQuerySymbolEntry> parts, int invalidPartsCount, @Nullable SQLQueryMemberAccessEntry endingPeriodNode) {
        this.syntaxNode = syntaxNode;
        this.parts = parts;
        this.stringParts = parts.stream().map(e -> e == null ? null : e.getName()).toList();
        this.invalidPartsCount = invalidPartsCount;
        this.endingPeriodNode = endingPeriodNode;
    }

    private SQLQueryComplexName(@NotNull STMTreeNode syntaxNode, @NotNull List<SQLQuerySymbolEntry> parts, @NotNull List<String> stringParts, int invalidPartsCount, @Nullable SQLQueryMemberAccessEntry endingPeriodNode) {
        this.syntaxNode = syntaxNode;
        this.parts = parts;
        this.stringParts = stringParts;
        this.invalidPartsCount = invalidPartsCount;
        this.endingPeriodNode = endingPeriodNode;
    }

    @Nullable
    public SQLQueryComplexName trimEnd() {
        return this.parts.size() < 2 ? null : new SQLQueryComplexName(this.syntaxNode, this.parts.subList(0, this.parts.size() - 1), this.stringParts.subList(0, this.parts.size() - 1), this.invalidPartsCount, this.parts.getLast() != null ? this.parts.getLast().getMemberAccess() : this.endingPeriodNode);
    }

    @Nullable
    public SQLQueryComplexName trimStart() {
        return this.parts.size() < 2 ? null : new SQLQueryComplexName(this.syntaxNode, this.parts.subList(1, this.parts.size()), this.stringParts.subList(1, this.parts.size()), this.invalidPartsCount, this.endingPeriodNode);
    }

    @NotNull
    public SQLQueryComplexName prepend(SQLQuerySymbolEntry entry) {
        return new SQLQueryComplexName(this.syntaxNode, STMUtils.combineLists(List.of(entry), this.parts), STMUtils.combineLists(List.of(entry.getName()), this.stringParts), this.invalidPartsCount, this.endingPeriodNode);
    }

    public String getNameString() {
        return String.join((CharSequence)"", STMUtils.expandTermStrings((STMTreeNode)this.syntaxNode).reversed());
    }

    public boolean isNotClassified() {
        if (this.invalidPartsCount == 0) {
            return this.parts.getLast().isNotClassified();
        }
        return this.parts.stream().filter(Objects::nonNull).allMatch(SQLQuerySymbolEntry::isNotClassified);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        void name;
        if (this == o) {
            return true;
        }
        if (!(o instanceof SQLQueryComplexName)) {
            return false;
        }
        SQLQueryComplexName sQLQueryComplexName = (SQLQueryComplexName)o;
        return Objects.deepEquals(this.stringParts, name.stringParts);
    }

    public int hashCode() {
        return Objects.hashCode(this.stringParts);
    }

    public String toString() {
        return "SQLQueryComplexName[" + String.join((CharSequence)Character.toString('.'), this.stringParts) + "]";
    }
}

