/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.exasol.model.security;

import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.exasol.ExasolMessages;
import org.jkiss.dbeaver.ext.exasol.model.ExasolDataSource;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class ExasolSecurityPolicy
implements DBPRefreshableObject,
DBPSaveableObject {
    private ExasolDataSource dataSource;
    private String name = ExasolMessages.exasol_security_policy_name;
    private String description = ExasolMessages.exasol_security_policy_description;
    private Boolean persisted = true;
    private Integer minLength;
    private Integer maxLength;
    private Integer minLowerCase;
    private Integer minUpperCase;
    private Integer minNumericChars;
    private Integer minSpecialChars;
    private Integer reusableAfterChanges;
    private Integer reusableAfterDays;
    private Integer maxFailedLoginAttempts;
    private Boolean enabled;

    public static HashMap<String, Integer> parseInput(String input) {
        if (input.equals("OFF")) {
            return new HashMap<String, Integer>();
        }
        String[] parms = input.split(":");
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        int i = 0;
        while (i < parms.length) {
            String parm = parms[i];
            String[] data = parm.split("=");
            ret.put(data[0], Integer.parseInt(data[1]));
            ++i;
        }
        return ret;
    }

    private void assignValues(HashMap<String, Integer> values) {
        if (values.isEmpty()) {
            this.enabled = false;
        }
        Iterator<String> iterator = values.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = iterator.next()) {
                case "MIN_LENGTH": {
                    this.minLength = values.get(key);
                    break;
                }
                case "MAX_LENGTH": {
                    this.maxLength = values.get(key);
                    break;
                }
                case "MIN_LOWER_CASE": {
                    this.minLowerCase = values.get(key);
                    break;
                }
                case "MIN_UPPER_CASE": {
                    this.minUpperCase = values.get(key);
                    break;
                }
                case "MIN_NUMERIC_CHARS": {
                    this.minNumericChars = values.get(key);
                    break;
                }
                case "MIN_SPECIAL_CHARS": {
                    this.minSpecialChars = values.get(key);
                    break;
                }
                case "REUSABLE_AFTER_CHANGES": {
                    this.reusableAfterChanges = values.get(key);
                    break;
                }
                case "REUSABLE_AFTER_DAYS": {
                    this.reusableAfterDays = values.get(key);
                    break;
                }
                case "MAX_FAILED_LOGIN_ATTEMPTS": {
                    this.maxFailedLoginAttempts = values.get(key);
                    break;
                }
            }
        }
    }

    public ExasolSecurityPolicy(ExasolDataSource dataSource, ResultSet dbResult) {
        this.dataSource = dataSource;
        String value = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SYSTEM_VALUE");
        if (value.isEmpty() | value.equals("OFF")) {
            this.enabled = false;
        } else {
            this.assignValues(ExasolSecurityPolicy.parseInput(value));
        }
    }

    @Property(viewable=true, order=20, length=PropertyLength.MULTILINE)
    public String getDescription() {
        return this.description;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public ExasolDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, order=10)
    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @Property(viewable=true, editable=true, updatable=true, order=30)
    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.minLength = minLength;
        this.enabled = true;
    }

    @Property(viewable=true, editable=true, updatable=true, order=40)
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.enabled = true;
        this.maxLength = maxLength;
    }

    @Property(viewable=true, editable=true, updatable=true, order=50)
    public Integer getMinLowerCase() {
        return this.minLowerCase;
    }

    public void setMinLowerCase(Integer minLowerCase) {
        this.minLowerCase = minLowerCase;
        this.enabled = true;
    }

    @Property(viewable=true, editable=true, updatable=true, order=60)
    public Integer getMinUpperCase() {
        return this.minUpperCase;
    }

    public void setMinUpperCase(Integer minUpperCase) {
        this.minUpperCase = minUpperCase;
        this.enabled = true;
    }

    @Property(viewable=true, editable=true, updatable=true, order=70)
    public Integer getMinSpecialChars() {
        return this.minSpecialChars;
    }

    public void setMinSpecialChars(Integer specialChars) {
        this.enabled = true;
        this.minSpecialChars = specialChars;
    }

    @Property(viewable=true, editable=true, updatable=true, order=80)
    public Integer getReusableAfterChanges() {
        return this.reusableAfterChanges;
    }

    public void setReusableAfterChanges(Integer reusableAfterChanges) {
        this.enabled = true;
        this.reusableAfterChanges = reusableAfterChanges;
    }

    @Property(viewable=true, editable=true, updatable=true, order=90)
    public Integer getReusableAfterDays() {
        return this.reusableAfterDays;
    }

    public void setReusableAfterDays(Integer reusableAfterDays) {
        this.enabled = true;
        this.reusableAfterDays = reusableAfterDays;
    }

    @Property(viewable=true, editable=true, updatable=true, order=100)
    public Integer getMaxFailedLoginAttempts() {
        return this.maxFailedLoginAttempts;
    }

    public void setMaxFailedLoginAttempts(Integer maxFailedLoginAttempts) {
        this.enabled = true;
        this.maxFailedLoginAttempts = maxFailedLoginAttempts;
    }

    @Property(viewable=true, editable=true, updatable=true, order=110)
    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
        if (!enabled.booleanValue()) {
            this.maxFailedLoginAttempts = null;
            this.maxLength = null;
            this.minLength = null;
            this.minLowerCase = null;
            this.minUpperCase = null;
            this.minNumericChars = null;
            this.reusableAfterChanges = null;
            this.reusableAfterDays = null;
            this.minSpecialChars = null;
        }
    }

    @Property(viewable=true, editable=true, updatable=true, order=75)
    public Integer getMinNumericChars() {
        return this.minNumericChars;
    }

    public void setMinNumericChars(Integer minNumericChars) {
        this.minNumericChars = minNumericChars;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this;
    }

    public String getSecurityString() {
        if (!this.enabled.booleanValue()) {
            return "OFF";
        }
        ArrayList<CallSite> str = new ArrayList<CallSite>();
        if (this.maxFailedLoginAttempts != null) {
            str.add((CallSite)((Object)("MAX_FAILED_LOGIN_ATTEMPTS=" + this.maxFailedLoginAttempts.toString())));
        }
        if (this.minLength != null) {
            str.add((CallSite)((Object)("MIN_LENGTH=" + this.minLength.toString())));
        }
        if (this.maxLength != null) {
            str.add((CallSite)((Object)("MAX_LENGTH=" + this.maxLength.toString())));
        }
        if (this.minLowerCase != null) {
            str.add((CallSite)((Object)("MIN_LOWER_CASE=" + this.minLowerCase.toString())));
        }
        if (this.maxFailedLoginAttempts != null) {
            str.add((CallSite)((Object)("MIN_UPPER_CASE=" + this.minUpperCase.toString())));
        }
        if (this.minNumericChars != null) {
            str.add((CallSite)((Object)("MIN_NUMERIC_CHARS=" + this.minNumericChars.toString())));
        }
        if (this.minSpecialChars != null) {
            str.add((CallSite)((Object)("MIN_SPECIAL_CHARS=" + this.minSpecialChars.toString())));
        }
        if (this.reusableAfterChanges != null) {
            str.add((CallSite)((Object)("REUSABLE_AFTER_CHANGES=" + this.reusableAfterChanges.toString())));
        }
        if (this.reusableAfterDays != null) {
            str.add((CallSite)((Object)("REUSABLE_AFTER_DAYS=" + this.reusableAfterDays.toString())));
        }
        return CommonUtils.joinStrings((String)":", str);
    }
}

